/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.AbstractTreeDetailForDetailListUI;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import org.apache.log4j.Logger;

public abstract class TreeDetailForDetailListUI
extends AbstractTreeDetailForDetailListUI {
    private static final Logger logger = CoreUIObject.getLogger(TreeDetailForDetailListUI.class);
    private EntityViewInfo[] initDetailEntityViewInfo = null;
    private EntityViewInfo[] detailEntityViewInfo = null;
    private IMetaDataPK[] detailQueryPK = null;
    private String[] detailRelationField = null;
    private KDTable[] detailTable = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        this.initDetails();
        super.onLoad();
        this.chkIncludeChild.setVisible(false);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.prepareDetailFilter(e);
        this.refreshDetails();
    }

    private void initDetails() {
        this.setDetailEntityViewInfo(this.getDetialViewInfos());
        this.setDetailQueryPK(this.getDetailIMetaDataPKs());
        this.setDetailTable(this.getDetailTables());
        this.setDetailRelationField(this.getDetailRelations());
        this.initDetailEntityViewInfo = (EntityViewInfo[])this.getDetialViewInfos().clone();
        this.addTableListerns();
    }

    protected abstract EntityViewInfo[] getDetialViewInfos();

    protected abstract IMetaDataPK[] getDetailIMetaDataPKs();

    protected abstract KDTable[] getDetailTables();

    protected abstract String[] getDetailRelations();

    public void addTableListerns() {
        for (int i = 0; i < this.detailTable.length; ++i) {
            final int index = i;
            this.detailTable[i].addRequestRowSetListener(new RequestRowSetListener(){

                public void doRequestRowSet(RequestRowSetEvent e) {
                    TreeDetailForDetailListUI.this.detailTable_doRequestRowSet(e, index);
                }
            });
        }
    }

    protected void detailTable_doRequestRowSet(RequestRowSetEvent e, int i) {
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        try {
            IQueryExecutor exec = this.getDetailQueryExecutor(this.detailQueryPK[i], this.detailEntityViewInfo[i]);
            IRowSet rowSet = exec.executeQuery(start, length);
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    protected IQueryExecutor getDetailQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        return exec;
    }

    private void setDetailQueryPK(IMetaDataPK[] detailQueryPK) {
        this.detailQueryPK = detailQueryPK;
    }

    private void setDetailRelationField(String[] relationField) {
        this.detailRelationField = relationField;
    }

    private void setDetailEntityViewInfo(EntityViewInfo[] detailEntityViewInfo) {
        this.detailEntityViewInfo = detailEntityViewInfo;
    }

    private void setDetailTable(KDTable[] detailTable) {
        this.detailTable = detailTable;
    }

    private void prepareDetailFilter(KDTSelectEvent e) throws Exception {
        KDTSelectBlock selectBlock = e.getSelectBlock();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            ICell cell = row.getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            Object keyValue = cell.getValue();
            this.detailEntityViewInfo = (EntityViewInfo[])this.initDetailEntityViewInfo.clone();
            if (keyValue != null) {
                for (int i = 0; i < this.detailEntityViewInfo.length; ++i) {
                    FilterInfo filter = new FilterInfo();
                    if (this.detailRelationField[i] == null || this.detailRelationField[i].length() == 0) {
                        filter.getFilterItems().add(new FilterItemInfo("id", keyValue, CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo(this.detailRelationField[i], keyValue));
                    }
                    if (this.detailEntityViewInfo[i] == null) {
                        this.detailEntityViewInfo[i] = new EntityViewInfo();
                    }
                    if (FilterUtility.hasFilterItem(this.detailEntityViewInfo[i].getFilter())) {
                        this.detailEntityViewInfo[i].getFilter().mergeFilter(filter, "AND");
                        continue;
                    }
                    this.detailEntityViewInfo[i].setFilter(filter);
                }
            }
        }
    }

    protected void refreshDetails() throws Exception {
        for (int i = 0; i < this.detailQueryPK.length; ++i) {
            this.detailTable[i].repaint();
            this.detailTable[i].removeRows();
        }
    }
}

