/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.AbstractTreeListUI;
import com.kingdee.eas.framework.client.FindListEvent;
import com.kingdee.eas.framework.client.IMoveTreeListener;
import com.kingdee.eas.framework.client.MoveTree;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.framework.client.uisidebar.UISideBarFactory;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.QuickFilteringSupportManager;
import com.kingdee.eas.framework.util.WindowsUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeListUI
extends AbstractTreeListUI {
    protected ITreeBuilder treeBuilder;
    private TreeBaseInfo sourceTreeNode;
    private KDTreeNode sourceSelectNode;
    private boolean disableTableChangeListener = false;
    private TreeSelectionListener treeSelectionListener;
    private boolean includeAllChildren = false;
    private MoveTree moveTreeDialog = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnMoveTree);
        this.btnMoveTree.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.menuItemMoveTree.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (e != null && e.getNewLeadSelectionPath() == null) {
            return;
        }
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            this.sourceTreeNode = (TreeBaseInfo)this.getSelectedTreeNode().getUserObject();
            this.sourceSelectNode = this.getSelectedTreeNode();
            if (!this.getTreeInterface().exists((IObjectPK)new ObjectUuidPK(this.sourceTreeNode.getId()))) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
        }
        this.setLocatePre(false);
        this.buildTreeFilter();
        this.execQuery();
        this.setSelectFirstRow(this.tblMain);
        this.setLocatePre(true);
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected String getEditUIName() {
        return null;
    }

    protected String getSelectedNodeKeyValue() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            return ((TreeBaseInfo)treeNode.getUserObject()).getId().toString();
        }
        SysUtil.abort();
        return null;
    }

    protected void buildTreeFilter() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        FilterItemCollection col = this.removeQueryFilterAndSorter(this.mainQuery);
        this.mainQuery.getFilter().remove("maskString");
        if (treeNode.getUserObject() instanceof TreeBaseInfo) {
            col.add(new FilterItemInfo(this.getLongNumberFieldName(), (Object)((TreeBaseInfo)treeNode.getUserObject()).getLongNumber()));
            col.add(new FilterItemInfo(this.getLongNumberFieldName(), (Object)(((TreeBaseInfo)treeNode.getUserObject()).getLongNumber() + "!%"), CompareType.LIKE));
            if (!this.isIncludeAllChildren()) {
                col.add(new FilterItemInfo("level", (Object)new Integer(((TreeBaseInfo)treeNode.getUserObject()).getLevel() - 1)));
                this.mainQuery.getFilter().setMaskString("#0 or (#1 and #2)");
            } else {
                this.mainQuery.getFilter().setMaskString("#0 or #1");
            }
        } else if (!this.isIncludeAllChildren()) {
            col.add(new FilterItemInfo("level", (Object)new Integer(1)));
        }
        try {
            this.getEntityViewInfo(this.mainQuery);
            if (this.getDefaultEntityViewInfo() != null) {
                this.MergeCommonQuery(this.getDefaultEntityViewInfo());
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            this.abort();
        }
        if (this.getCurrentOrder() != null) {
            this.mainQuery.getSorter().add(this.getCurrentOrder());
        } else {
            String longNumberFieldName = this.getLongNumberFieldName();
            boolean found = false;
            for (int i = 0; i < this.mainQuery.getSorter().size(); ++i) {
                SorterItemInfo sorterItem = this.mainQuery.getSorter().get(i);
                if (!sorterItem.getPropertyName().equalsIgnoreCase(longNumberFieldName)) continue;
                found = true;
            }
            if (!found) {
                this.mainQuery.getSorter().add(new SorterItemInfo(longNumberFieldName));
            }
        }
    }

    @Override
    public RequestContext prepareQueryContext(RequestRowSetEvent e) {
        RequestContext request = super.prepareQueryContext(e);
        EntityViewInfo info = request.getQuery();
        if (info == null) {
            info = new EntityViewInfo();
        }
        if (this.getCurrentOrder() != null) {
            info.getSorter().add(this.getCurrentOrder());
        } else {
            String longNumberFieldName = this.getLongNumberFieldName();
            boolean found = false;
            for (int i = 0; i < info.getSorter().size(); ++i) {
                SorterItemInfo sorterItem = info.getSorter().get(i);
                if (!sorterItem.getPropertyName().equalsIgnoreCase(longNumberFieldName)) continue;
                found = true;
            }
            if (!found) {
                info.getSorter().add(new SorterItemInfo(longNumberFieldName));
            }
        }
        request.setQuery(info);
        return request;
    }

    protected String getLongNumberFieldName() {
        return "longNumber";
    }

    protected String getRootName() {
        return "root";
    }

    protected Object getRootObject() {
        return this.getRootName();
    }

    public RequestContext prepareInitTree() {
        RequestContext request = new RequestContext();
        ITreeBase _interface = null;
        try {
            _interface = this.getTreeInterface();
            if (_interface != null) {
                request.put("TreeCtrlBOSObjectType", _interface.getType());
            }
            request.put("TreeInitialLevel", new Integer(this.getTreeInitialLevel()));
            request.put("TreeExpandLevel", new Integer(this.getTreeExpandLevel()));
            request.put("selectorForTree", this.getSelectorForTree());
            request.put("selectedKeyValue", this.getSelectedKeyValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        request.put("treeDefaultFilter", this.getDefaultFilterForTree());
        request.put("defaultEntityViewInfo", this.getDefaultEntityViewInfo());
        request.put("currentOrder", this.getCurrentOrder());
        request.put("isIncludeAllChildren", this.isIncludeAllChildren());
        return request;
    }

    @Override
    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman post = super.prepareQuery(e);
        RequestContext request = this.prepareInitTree();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (node != null && node.getUserObject() instanceof TreeBaseInfo) {
            TreeBaseInfo treeBaseInfo = (TreeBaseInfo)node.getUserObject();
            request.put("selectedTreeNode", treeBaseInfo);
        }
        post.setRequestContext((Serializable)request);
        return post;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        if (postman != null) {
            RequestContext request = this.prepareInitTree();
            postman.setRequestContext((Serializable)request);
        }
        return postman;
    }

    @Override
    public RequestContext prepareActionRefresh(IItemAction itemAction) throws Exception {
        int defaultInitialLevel;
        RequestContext request = super.prepareActionRefresh(itemAction);
        RequestContext requestContext = this.prepareInitTree();
        request.putAll(requestContext);
        int initLevel = -1;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (node != null && node.getUserObject() instanceof TreeBaseInfo) {
            TreeBaseInfo treeBaseInfo = (TreeBaseInfo)node.getUserObject();
            initLevel = treeBaseInfo.getLevel();
        }
        if (initLevel < (defaultInitialLevel = this.getTreeInitialLevel())) {
            initLevel = defaultInitialLevel;
        }
        request.put("TreeInitialLevel", new Integer(initLevel));
        request.put("treeDefaultFilter", this.getDefaultFilterForTree());
        request.put("defaultEntityViewInfo", this.getDefaultEntityViewInfo());
        request.put("currentOrder", this.getCurrentOrder());
        request.put("isIncludeAllChildren", this.isIncludeAllChildren());
        return request;
    }

    @Override
    public void onLoad() throws Exception {
        this.setDoRequestData(false);
        super.onLoad();
        this.setDoRequestData(true);
        if (!this.treeView.isShowControlPanel()) {
            this.treeView.getActionMap().clear();
        }
        this.initTree();
        this.treeMain.setSelectionRow(0);
        Component[] component = new Component[]{this.treeMain, this.tblMain};
        this.pnlMain.setFocusCycleRoot(true);
        this.pnlMain.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(component));
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.treeMain.requestFocus();
    }

    protected void initTree() throws Exception {
        int defaultInitialLevel;
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        this.treeSelectionListener = listeners[0];
        this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        int initLevel = -1;
        KDTreeNode node = this.getSelectedTreeNode();
        if (node != null && node.getUserObject() instanceof TreeBaseInfo) {
            TreeBaseInfo treeBaseInfo = (TreeBaseInfo)node.getUserObject();
            initLevel = treeBaseInfo.getLevel();
        }
        if (initLevel < (defaultInitialLevel = this.getTreeInitialLevel())) {
            initLevel = defaultInitialLevel;
        }
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder(this.getLNTreeNodeCtrl(), initLevel, this.getTreeExpandLevel(), this.getDefaultFilterForTree(), this.getSelectorForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)((Object)rootNode));
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
        this.initPopmenu();
        this.SelectNode();
    }

    protected SelectorItemCollection getSelectorForTree() {
        return null;
    }

    protected FilterInfo getDefaultFilterForTree() {
        return this.getDefaultCUFilter(this.isIgnoreTreeCUFilter());
    }

    protected boolean isIgnoreTreeCUFilter() {
        return false;
    }

    protected void initPopmenu() {
        JPopupMenu menu = this.treeMain.getPopupMenu();
        EventListener[] ls = this.treeMain.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            this.treeMain.addTreePopupMenu(new TreePopupMenuListener(){

                public boolean popMenu(TreePopupMenuEvent event) {
                    return true;
                }
            });
        }
    }

    protected int getTreeInitialLevel() {
        return 3;
    }

    protected int getTreeExpandLevel() {
        return 3;
    }

    protected ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    protected abstract ITreeBase getTreeInterface() throws Exception;

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.disableTableChangeListener = true;
        super.actionRemove_actionPerformed(e);
        this.disableTableChangeListener = false;
        this.refresh(e);
    }

    @Override
    public IUIActionPostman prepareRemove(RequestContext request) {
        DefaultKingdeeTreeNode parentNode;
        IUIActionPostman postman = super.prepareRemove(request);
        RequestContext req = new RequestContext();
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getParent() != null && (parentNode = (DefaultKingdeeTreeNode)treeNode.getParent()).getUserObject() instanceof TreeBaseInfo) {
            req.put("parentNode", parentNode.getUserObject());
        }
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            TreeBaseInfo treeBaseInfo = (TreeBaseInfo)treeNode.getUserObject();
            req.put("selectedTreeNode", treeBaseInfo);
        }
        try {
            ITreeBase _interface = this.getTreeInterface();
            if (_interface != null) {
                req.put("TreeCtrlBOSObjectType", _interface.getType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        req.put("TreeExpandLevel", new Integer(this.getTreeExpandLevel()));
        req.put("treeDefaultFilter", this.getDefaultFilterForTree());
        req.put("defaultEntityViewInfo", this.getDefaultEntityViewInfo());
        req.put("currentOrder", this.getCurrentOrder());
        req.put("isIncludeAllChildren", this.isIncludeAllChildren());
        req.setQueryUuid(this.getQueryUuid());
        postman.setRequestContext((Serializable)req);
        return postman;
    }

    @Override
    protected void refresh(ActionEvent e) throws Exception {
        KDTreeNode treeNode;
        if (e == null) {
            return;
        }
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals((Object)this.actionRemove) || action.equals((Object)this.actionEdit)) {
            KDTreeNode treeNode2 = (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
            if (treeNode2 != null && treeNode2.getParent() != null) {
                TreePath oldPath = this.treeMain.getSelectionPath();
                TreePath parentPath = this.treeMain.getSelectionPath().getParentPath();
                KDTreeNode parentNode = (KDTreeNode)((Object)treeNode2.getParent());
                parentNode.remove((MutableTreeNode)((Object)treeNode2));
                this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
                this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)parentNode);
                this.treeMain.updateUI();
                this.treeBuilder.refreshTreeNode(this.treeMain, parentNode, this.getDefaultFilterForTree());
                this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, this.treeMain.getModel(), oldPath));
                if (parentNode.getUserObject() != null && parentNode.getChildCount() == 0 && parentNode.getUserObject() instanceof TreeBaseInfo && !((TreeBaseInfo)parentNode.getUserObject()).isIsLeaf()) {
                    ((TreeBaseInfo)parentNode.getUserObject()).setIsLeaf(true);
                }
                if (!parentPath.equals(this.treeMain.getSelectionPath())) {
                    TreePath thisPath = this.treeMain.getSelectionPath();
                    this.treeMain.setSelectionPath(parentPath);
                    this.prepareQuery(null).callHandler();
                    this.treeMain_valueChanged(new TreeSelectionEvent((Object)this.treeMain, parentPath, true, thisPath, parentPath));
                }
                this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
                this.treeMain.expandPath(parentPath);
            } else {
                super.refresh(e);
                ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Refresh");
                this.refresh(evt);
            }
        } else if (action.equals((Object)this.actionRefresh)) {
            TreePath oldPath = this.treeMain.getSelectionPath();
            this.initTree();
            TreePath path = TreePathUtil.getNewTreePath((JTree)this.treeMain, this.treeMain.getModel(), oldPath);
            if (path != null) {
                this.treeMain.setSelectionPath(path);
            } else {
                this.treeMain.setSelectionRow(0);
            }
        } else if (action.equals((Object)this.actionView) && this.isModify) {
            super.refresh(e);
            this.initTree();
            this.treeMain.setSelectionRow(0);
            this.isModify = false;
        } else if (action.equals((Object)this.actionAddNew) && (treeNode = (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent())) != null) {
            TreePath oldPath = this.treeMain.getSelectionPath();
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo && ((TreeBaseInfo)treeNode.getUserObject()).isIsLeaf()) {
                ((TreeBaseInfo)treeNode.getUserObject()).setIsLeaf(false);
            }
            this.treeBuilder.refreshTreeNode(this.treeMain, treeNode, this.getDefaultFilterForTree());
            this.treeMain.setSelectionRow(-1);
            this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, this.treeMain.getModel(), oldPath));
            this.treeMain.expandPath(oldPath);
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = this.mainQueryPK.getFullName()) && !this.isFirstDefaultQuery()) {
            if (this.dialog == null) {
                this.dialog = this.initCommonQueryDialog();
                this.dialog.setMaxReturnCountVisible(true);
            }
            if (this.isSupportDynQuery()) {
                this.dialog.setDynQueryVisible(true);
            }
            if (this.dialog.show()) {
                this.tHelper.setDialog(this.dialog);
                this.MaxReturnRowCount = iQuery.getMaxNumView(this.getClass().getName(), queryName);
                this.mainQuery.getSorter().clear();
                this.mainQuery = this.getEntityViewInfo((EntityViewInfo)this.dialog.getEntityViewInfoResult().clone());
                this.setDefaultEntityViewInfo(this.dialog.getEntityViewInfoResult());
                if (this.mainQuery.getSorter() != null && this.mainQuery.getSorter().size() > 0) {
                    this.setIsIgnoreOrder(true);
                } else {
                    this.setIsIgnoreOrder(false);
                }
                this.prepareQuery(null).callHandler();
                this.handleDynQuery(this.mainQuery, this.dialog);
                this.doQuery(this.dialog);
                this.setLocatePre(true);
                this.execQuery();
                this.setIsIgnoreOrder(false);
                UISideBarFactory.reBuildSideBar(this);
            } else {
                this.tHelper.setDialog(this.dialog);
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.treeMain.getRowCount() == 0) {
            return;
        }
        ItemAction action = this.getActionFromActionEvent(e);
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode parentTreeNode = null;
        if (treeNode != null && treeNode.getParent() != null) {
            parentTreeNode = (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent()).getParent();
        }
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            if (action.equals((Object)this.actionAddNew)) {
                uiContext.put((Object)"ParentNode", treeNode.getUserObject());
            } else if (parentTreeNode != null && parentTreeNode.getUserObject() instanceof TreeBaseInfo) {
                uiContext.put((Object)"ParentNode", parentTreeNode.getUserObject());
            } else {
                uiContext.put((Object)"ParentNode", null);
            }
        } else {
            uiContext.put((Object)"ParentNode", null);
        }
    }

    protected boolean isIncludeAllChildren() {
        return this.includeAllChildren;
    }

    protected void setIncludeAllChildren(boolean flag) {
        this.includeAllChildren = flag;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return this.getTreeInterface();
    }

    protected String getMoveTreeTitle() {
        return this.btnMoveTree.getToolTipText();
    }

    @Override
    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode selectedNode = this.getSelectedTreeNode();
        if (selectedNode == null) {
            return;
        }
        if (!(selectedNode.getUserObject() instanceof TreeBaseInfo)) {
            return;
        }
        Window onwer = ComponentUtil.getOwnerWindow((Component)((Object)this));
        if (onwer instanceof Frame) {
            this.moveTreeDialog = new MoveTree((Frame)onwer, this.getMoveTreeTitle(), this.getRootName(), this.getTreeInterface(), (TreeBaseInfo)this.getSelectedTreeNode().getUserObject(), true, this.getDefaultFilterForTree());
        }
        this.moveTreeDialog = onwer instanceof Dialog ? new MoveTree((Dialog)onwer, this.getMoveTreeTitle(), this.getRootName(), this.getTreeInterface(), (TreeBaseInfo)this.getSelectedTreeNode().getUserObject(), true, this.getDefaultFilterForTree()) : new MoveTree((Component)((Object)this), this.getMoveTreeTitle(), this.getRootName(), this.getTreeInterface(), (TreeBaseInfo)this.getSelectedTreeNode().getUserObject(), true, this.getDefaultFilterForTree());
        this.moveTreeDialog.addMoveTreeListener(new IMoveTreeListener(){

            @Override
            public void SelectTreeCancel(MoveTreeEvent e) {
                TreeListUI.this.moveTreeDialog.dispose();
                TreeListUI.this.moveTreeDialog = null;
            }

            @Override
            public void SelectTreeNode(MoveTreeEvent e) {
                TreeListUI.this.moveTreeNode(e);
            }
        });
        this.moveTreeDialog.setLocation(WindowsUtility.getWindowCenter((Component)((Object)this.moveTreeDialog)));
        this.moveTreeDialog.show();
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        try {
            this.sourceTreeNode = (TreeBaseInfo)this.getSelectedTreeNode().getUserObject();
            this.sourceSelectNode = this.getSelectedTreeNode();
            if (!this.isMoveTree()) {
                return;
            }
            this.getTreeInterface().moveTreeNode(this.sourceTreeNode, e.getTargetTreeBaseInfo());
            KDTreeNode sourceParentNode = (KDTreeNode)((Object)this.sourceSelectNode.getParent());
            sourceParentNode.remove((MutableTreeNode)((Object)this.sourceSelectNode));
            e.getTargetNode().add((MutableTreeNode)((Object)this.sourceSelectNode));
            this.moveTreeDialog.dispose();
            this.moveTreeDialog = null;
            this.initTree();
            if (this.treeMain.getSelectionPath() == null) {
                this.SelectNode(this.sourceTreeNode.getId().toString());
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
            super.abort();
        }
    }

    protected boolean isMoveTree() {
        return true;
    }

    @Override
    protected void locate(FindListEvent e) {
        super.locate(e);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.disableTableChangeListener) {
            return;
        }
        if (e.getPrevSelectBlock() == null || e.getSelectBlock() == null) {
            return;
        }
        if (!e.getPrevSelectBlock().equals((Object)e.getSelectBlock()) && e.getSelectBlock().getBeginRow() == e.getSelectBlock().getEndRow()) {
            this.SelectNode();
        }
    }

    private void SelectNode(String keyValue) throws EASBizException, BOSException, Exception {
        if (keyValue == null) {
            return;
        }
        this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        TreeBaseInfo selectRow = this.getTreeInterface().getTreeBaseInfo((IObjectPK)new ObjectUuidPK(keyValue));
        String fullLN = selectRow.getLongNumber();
        this.treeMain.setSelectionRow(0);
        KDTreeNode selectNode = this.getSelectedTreeNode();
        this.getSelectNode(fullLN, selectNode);
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
    }

    protected void SelectNode() throws EASBizException, BOSException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        TreeBaseInfo selectRow = this.getTreeInterface().getTreeBaseInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        String fullLN = selectRow.getLongNumber();
        this.treeMain.setSelectionRow(0);
        TreePath oldPath = this.treeMain.getSelectionPath();
        KDTreeNode selectNode = this.getSelectedTreeNode();
        if (!(selectNode.getUserObject() instanceof TreeBaseInfo)) {
            selectNode = this.getSelectedTreeNode();
        }
        this.getSelectNode(fullLN, selectNode);
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
    }

    private void getSelectNode(String fullLN, DefaultKingdeeTreeNode selectNode) throws Exception {
        int j;
        if (selectNode.getChildCount() == 0) {
            return;
        }
        if (selectNode instanceof KDTreeNode && ((KDTreeNode)selectNode).isVirtual() && selectNode.getUserObject() instanceof TreeBaseInfo && fullLN != null && fullLN.startsWith(((TreeBaseInfo)selectNode.getUserObject()).getLongNumber())) {
            this.treeBuilder.refreshTreeNode(this.treeMain, (KDTreeNode)selectNode);
        }
        Object[] nodeArray = new Object[selectNode.getChildCount()];
        for (j = 0; j < selectNode.getChildCount(); ++j) {
            nodeArray[j] = selectNode.getChildAt(j);
        }
        for (j = 0; j < nodeArray.length; ++j) {
            DefaultKingdeeTreeNode tempNode;
            if (nodeArray[j] == null || !(nodeArray[j] instanceof DefaultKingdeeTreeNode) || (tempNode = (DefaultKingdeeTreeNode)nodeArray[j]).getUserObject() == null) continue;
            TreeBaseInfo tempTree = (TreeBaseInfo)tempNode.getUserObject();
            if (fullLN != null && !fullLN.startsWith(tempTree.getLongNumber())) continue;
            if (tempTree.getLongNumber().equals(fullLN)) {
                this.treeMain.setSelectionNode(tempNode);
                break;
            }
            this.getSelectNode(fullLN, tempNode);
        }
    }

    @Override
    protected QuickFilteringSupportManager createQuickFilteringSupportManager() throws Exception {
        if (this.isViewForIdList() || this.getQuickFilteringSupportManager() != null) {
            return this.getQuickFilteringSupportManager();
        }
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && this.getBizType() != null) {
            qfsi.setBosType(this.getBizType().toString());
        }
        qfsi.setMustQueryAtFirst(true);
        return new QuickFilteringSupportManager(this, qfsi, (Component)this.pnlMain);
    }
}

