/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import javax.swing.JTree;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreePathUtil {
    public static TreePath getNewTreePath(JTree tree, TreeModel treeModel, TreePath oldTreePath) {
        if (oldTreePath == null) {
            return null;
        }
        Object[] oldPaths = oldTreePath.getPath();
        Object[] newPaths = new Object[oldPaths.length];
        KDTreeNode root = (KDTreeNode)((Object)treeModel.getRoot());
        KDTreeNode[] treeNodes = new KDTreeNode[]{root};
        KDTreeNode curNode = null;
        for (int i = 0; i < oldPaths.length; ++i) {
            int k;
            int j;
            KDTreeNode oldTreeNode = (KDTreeNode)((Object)oldPaths[i]);
            for (j = 0; j < treeNodes.length && !TreePathUtil.equalTreeNode(oldTreeNode, treeNodes[j]); ++j) {
            }
            if (j >= treeNodes.length) {
                return null;
            }
            newPaths[i] = treeNodes[j];
            Object[] currentPaths = new Object[i + 1];
            for (k = 0; k < currentPaths.length; ++k) {
                currentPaths[k] = newPaths[k];
            }
            try {
                tree.fireTreeWillExpand(new TreePath(currentPaths));
            }
            catch (ExpandVetoException e) {
                e.printStackTrace();
                return null;
            }
            curNode = treeNodes[j];
            treeNodes = new KDTreeNode[curNode.getChildCount()];
            for (k = 0; k < curNode.getChildCount(); ++k) {
                treeNodes[k] = (KDTreeNode)((Object)curNode.getChildAt(k));
            }
        }
        return new TreePath(newPaths);
    }

    private static boolean equalTreeNode(KDTreeNode treeNode1, KDTreeNode treeNode2) {
        Object value1 = treeNode1.getUserObject();
        Object value2 = treeNode2.getUserObject();
        if (treeNode1 == treeNode2 || value1 == value2 || value1.equals(value2)) {
            return true;
        }
        return value1 instanceof TreeBaseInfo && value2 instanceof TreeBaseInfo && ((TreeBaseInfo)value1).getId().equals((Object)((TreeBaseInfo)value2).getId());
    }
}

