/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.cloud.screen;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.framework.client.cloud.screen.IPrintScreenListener;
import com.kingdee.eas.framework.client.cloud.screen.PrintScreenRef;
import com.kingdee.eas.framework.client.cloud.screen.draw.DrawingBoard;
import com.kingdee.eas.framework.client.cloud.screen.tools.Direction;
import com.kingdee.eas.framework.client.cloud.screen.tools.Tools;
import com.kingdee.eas.framework.client.cloud.screen.util.ScreenGamer;
import com.kingdee.eas.framework.client.cloud.screen.util.ScreenRect;
import com.kingdee.eas.framework.client.resource.FWResourceManager;
import com.kingdee.eas.framework.util.FileUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class PrintScreen
extends JDialog {
    private static final long serialVersionUID = 6468764049133653002L;
    private static final Logger logger = Logger.getLogger(PrintScreen.class);
    private int screenWidth = Tools.SCREEN_WIDTH;
    private int screenHeight = Tools.SCREEN_HEIGHT;
    private Point coordinate1 = new Point();
    private Point coordinate2 = new Point();
    private Point tdATemp = new Point();
    private Point tdBTemp = new Point();
    private int mXTemp;
    private int mYTemp;
    private int x = 0;
    private int y = 0;
    private Image originalImageCache;
    private Image imageCache;
    private BufferedImage sbi;
    private ScreenRect r = new ScreenRect();
    private ScreenGamer sg = new ScreenGamer();
    private FileDialog fileDialog;
    private Direction direction = Direction.STOP;
    private boolean selectedScreen = true;
    private boolean startSelectScreen = true;
    private int mouseKeyCode;
    PrintScreenRef imageRef;
    DrawingBoard draw = new DrawingBoard();
    boolean isUserDrawed = false;
    JDialog parentDialog;
    JFrame parentFrame;
    static final int toolBarWidth = 230;
    static final int toolBarHeight = 30;
    static final int rectTopLen = 15;
    static final int rectDownLen = 35;
    static final int toolBarBtnWidth = 26;
    static final int toolBarBtnHeight = 24;
    static final int btnUp = 3;
    static final int btnLeft = 3;
    static final int btnSpace = 2;
    File fileForPic;
    IPrintScreenListener lis;

    public PrintScreen(Dialog dialog, PrintScreenRef ref) {
        super(dialog);
        this.imageRef = ref;
        this.initPrintScreen();
    }

    public PrintScreen(PrintScreenRef ref) {
        this.imageRef = ref;
        this.initPrintScreen();
    }

    private void initPrintScreen() {
        final SelectPanel selectPnl = new SelectPanel(this);
        this.setContentPane(selectPnl);
        this.fileDialog = new FileDialog((Dialog)this, EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"30_PrintScreen"), 1);
        try {
            this.originalImageCache = new Robot().createScreenCapture(new Rectangle(0, 0, this.screenWidth, this.screenHeight));
        }
        catch (AWTException e1) {
            System.out.println("init screen imageCache...");
        }
        this.setUndecorated(true);
        this.setCursor(new Cursor(1));
        this.setBounds(0, 0, this.screenWidth, this.screenHeight);
        this.setVisible(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PrintScreen.this.mouseKeyCode = e.getButton();
                if (selectPnl.isDrawed()) {
                    return;
                }
                if (e.getButton() == 1) {
                    if (PrintScreen.this.selectedScreen) {
                        ((PrintScreen)PrintScreen.this).coordinate1.x = e.getX();
                        ((PrintScreen)PrintScreen.this).coordinate1.y = e.getY();
                        PrintScreen.this.startSelectScreen = true;
                    } else if (PrintScreen.this.x > ((PrintScreen)PrintScreen.this).coordinate1.x + 2 && PrintScreen.this.x < ((PrintScreen)PrintScreen.this).coordinate2.x - 2 && PrintScreen.this.y > ((PrintScreen)PrintScreen.this).coordinate1.y + 2 && PrintScreen.this.y < ((PrintScreen)PrintScreen.this).coordinate2.y - 2) {
                        PrintScreen.this.setCursor(new Cursor(13));
                        PrintScreen.this.mXTemp = e.getX();
                        PrintScreen.this.mYTemp = e.getY();
                        ((PrintScreen)PrintScreen.this).tdATemp.x = ((PrintScreen)PrintScreen.this).coordinate1.x;
                        ((PrintScreen)PrintScreen.this).tdATemp.y = ((PrintScreen)PrintScreen.this).coordinate1.y;
                        ((PrintScreen)PrintScreen.this).tdBTemp.x = ((PrintScreen)PrintScreen.this).coordinate2.x;
                        ((PrintScreen)PrintScreen.this).tdBTemp.y = ((PrintScreen)PrintScreen.this).coordinate2.y;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PrintScreen.this.mouseKeyCode = 0;
                if (1 == e.getButton()) {
                    if (PrintScreen.this.selectedScreen) {
                        if (e.getX() == ((PrintScreen)PrintScreen.this).coordinate1.x) {
                            int n = ((PrintScreen)PrintScreen.this).coordinate2.x = PrintScreen.this.screenWidth - e.getX() > 230 ? e.getX() + 230 : e.getX() - 230;
                        }
                        if (e.getY() == ((PrintScreen)PrintScreen.this).coordinate1.y) {
                            ((PrintScreen)PrintScreen.this).coordinate2.y = PrintScreen.this.screenHeight - e.getY() > 230 ? e.getY() + 230 : e.getY() - 230;
                        }
                        int tempx1 = ((PrintScreen)PrintScreen.this).coordinate1.x;
                        int tempy1 = ((PrintScreen)PrintScreen.this).coordinate1.y;
                        int tempx2 = ((PrintScreen)PrintScreen.this).coordinate2.x;
                        int tempy2 = ((PrintScreen)PrintScreen.this).coordinate2.y;
                        if (((PrintScreen)PrintScreen.this).coordinate2.x < ((PrintScreen)PrintScreen.this).coordinate1.x && ((PrintScreen)PrintScreen.this).coordinate2.y > ((PrintScreen)PrintScreen.this).coordinate1.y) {
                            ((PrintScreen)PrintScreen.this).coordinate1.x = tempx2;
                            ((PrintScreen)PrintScreen.this).coordinate1.y = tempy1;
                            ((PrintScreen)PrintScreen.this).coordinate2.x = tempx1;
                            ((PrintScreen)PrintScreen.this).coordinate2.y = tempy2;
                        } else if (((PrintScreen)PrintScreen.this).coordinate2.x < ((PrintScreen)PrintScreen.this).coordinate1.x && ((PrintScreen)PrintScreen.this).coordinate2.y < ((PrintScreen)PrintScreen.this).coordinate1.y) {
                            ((PrintScreen)PrintScreen.this).coordinate1.x = tempx2;
                            ((PrintScreen)PrintScreen.this).coordinate1.y = tempy2;
                            ((PrintScreen)PrintScreen.this).coordinate2.x = tempx1;
                            ((PrintScreen)PrintScreen.this).coordinate2.y = tempy1;
                        } else if (((PrintScreen)PrintScreen.this).coordinate2.x > ((PrintScreen)PrintScreen.this).coordinate1.x && ((PrintScreen)PrintScreen.this).coordinate2.y < ((PrintScreen)PrintScreen.this).coordinate1.y) {
                            ((PrintScreen)PrintScreen.this).coordinate1.x = tempx1;
                            ((PrintScreen)PrintScreen.this).coordinate1.y = tempy2;
                            ((PrintScreen)PrintScreen.this).coordinate2.x = tempx2;
                            ((PrintScreen)PrintScreen.this).coordinate2.y = tempy1;
                        }
                        PrintScreen.this.getContentPane().repaint();
                        PrintScreen.this.selectedScreen = !PrintScreen.this.selectedScreen;
                        selectPnl.initToolPanel();
                        selectPnl.repaint();
                    } else {
                        PrintScreen.this.setCursor(new Cursor(0));
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                if (2 == me.getButton() && me.getClickCount() == 1) {
                    PrintScreen.this.dispose();
                }
                if (1 == me.getButton() && me.getClickCount() == 2) {
                    if (PrintScreen.this.imageCache == null) {
                        PrintScreen.this.getBufferedImageForSave();
                    } else {
                        PrintScreen.this.getBufferedImage(PrintScreen.this.imageCache);
                    }
                    if (PrintScreen.this.imageRef != null) {
                        PrintScreen.this.imageRef.setBufferedImage(PrintScreen.this.sbi);
                    }
                    PrintScreen.this.firePrintScreenListener();
                    PrintScreen.this.dispose();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (selectPnl.isDrawed()) {
                    return;
                }
                if (PrintScreen.this.mouseKeyCode == 1) {
                    if (PrintScreen.this.selectedScreen) {
                        ((PrintScreen)PrintScreen.this).coordinate2.x = e.getX();
                        ((PrintScreen)PrintScreen.this).coordinate2.y = e.getY();
                    }
                    PrintScreen.this.sg.GamermouseDraggedEvent(e);
                    switch (PrintScreen.this.direction) {
                        case LEFT: {
                            ((PrintScreen)PrintScreen.this).coordinate1.x = e.getX();
                            break;
                        }
                        case RIGHT: {
                            ((PrintScreen)PrintScreen.this).coordinate2.x = e.getX();
                            break;
                        }
                        case UP: {
                            ((PrintScreen)PrintScreen.this).coordinate1.y = e.getY();
                            break;
                        }
                        case DOWN: {
                            ((PrintScreen)PrintScreen.this).coordinate2.y = e.getY();
                            break;
                        }
                        case LEFT_UP: {
                            ((PrintScreen)PrintScreen.this).coordinate1.x = e.getX();
                            ((PrintScreen)PrintScreen.this).coordinate1.y = e.getY();
                            break;
                        }
                        case LEFT_DOWN: {
                            ((PrintScreen)PrintScreen.this).coordinate1.x = e.getX();
                            ((PrintScreen)PrintScreen.this).coordinate2.y = e.getY();
                            break;
                        }
                        case RIGHT_UP: {
                            ((PrintScreen)PrintScreen.this).coordinate2.x = e.getX();
                            ((PrintScreen)PrintScreen.this).coordinate1.y = e.getY();
                            break;
                        }
                        case RIGHT_DOWN: {
                            ((PrintScreen)PrintScreen.this).coordinate2.x = e.getX();
                            ((PrintScreen)PrintScreen.this).coordinate2.y = e.getY();
                            break;
                        }
                        case AT_CENTER: {
                            this.moveRect(e);
                            break;
                        }
                        default: {
                            ((PrintScreen)PrintScreen.this).coordinate2.x = e.getX();
                            ((PrintScreen)PrintScreen.this).coordinate2.y = e.getY();
                        }
                    }
                }
                PrintScreen.this.getContentPane().repaint();
            }

            private void moveRect(MouseEvent e) {
                int x1 = ((PrintScreen)PrintScreen.this).tdATemp.x + (e.getX() - PrintScreen.this.mXTemp);
                int y1 = ((PrintScreen)PrintScreen.this).tdATemp.y + (e.getY() - PrintScreen.this.mYTemp);
                int x2 = ((PrintScreen)PrintScreen.this).tdBTemp.x + (e.getX() - PrintScreen.this.mXTemp);
                int y2 = ((PrintScreen)PrintScreen.this).tdBTemp.y + (e.getY() - PrintScreen.this.mYTemp);
                int width = x2 - x1;
                int height = y2 - y1;
                if (x1 < 0 && y1 < 15) {
                    ((PrintScreen)PrintScreen.this).coordinate1.x = 0;
                    ((PrintScreen)PrintScreen.this).coordinate1.y = 15;
                    ((PrintScreen)PrintScreen.this).coordinate2.x = 0 + width;
                    ((PrintScreen)PrintScreen.this).coordinate2.y = 15 + height;
                } else if (x1 > 0 && y1 < 15 && x2 < PrintScreen.this.screenWidth) {
                    ((PrintScreen)PrintScreen.this).coordinate1.x = x1;
                    ((PrintScreen)PrintScreen.this).coordinate1.y = 15;
                    ((PrintScreen)PrintScreen.this).coordinate2.x = x2;
                    ((PrintScreen)PrintScreen.this).coordinate2.y = 15 + height;
                } else if (y1 < 15 && x2 > PrintScreen.this.screenWidth) {
                    ((PrintScreen)PrintScreen.this).coordinate1.x = PrintScreen.this.screenWidth - width;
                    ((PrintScreen)PrintScreen.this).coordinate1.y = 15;
                    ((PrintScreen)PrintScreen.this).coordinate2.x = PrintScreen.this.screenWidth;
                    ((PrintScreen)PrintScreen.this).coordinate2.y = 15 + height;
                } else if (y1 > 15 && x2 > PrintScreen.this.screenWidth && y2 < PrintScreen.this.screenHeight) {
                    ((PrintScreen)PrintScreen.this).coordinate1.x = PrintScreen.this.screenWidth - width;
                    ((PrintScreen)PrintScreen.this).coordinate1.y = y1;
                    ((PrintScreen)PrintScreen.this).coordinate2.x = PrintScreen.this.screenWidth;
                    ((PrintScreen)PrintScreen.this).coordinate2.y = y2;
                } else if (x2 > PrintScreen.this.screenWidth && y2 > PrintScreen.this.screenHeight - 35) {
                    ((PrintScreen)PrintScreen.this).coordinate1.x = PrintScreen.this.screenWidth - width;
                    ((PrintScreen)PrintScreen.this).coordinate1.y = PrintScreen.this.screenHeight - height - 35;
                    ((PrintScreen)PrintScreen.this).coordinate2.x = PrintScreen.this.screenWidth;
                    ((PrintScreen)PrintScreen.this).coordinate2.y = PrintScreen.this.screenHeight - 35;
                } else if (x1 > 0 && x2 < PrintScreen.this.screenWidth && y2 > PrintScreen.this.screenHeight - 35) {
                    ((PrintScreen)PrintScreen.this).coordinate1.x = x1;
                    ((PrintScreen)PrintScreen.this).coordinate1.y = PrintScreen.this.screenHeight - height - 35;
                    ((PrintScreen)PrintScreen.this).coordinate2.x = x2;
                    ((PrintScreen)PrintScreen.this).coordinate2.y = PrintScreen.this.screenHeight - 35;
                } else if (x1 < 0 && y2 > PrintScreen.this.screenHeight - 35) {
                    ((PrintScreen)PrintScreen.this).coordinate1.x = 0;
                    ((PrintScreen)PrintScreen.this).coordinate1.y = PrintScreen.this.screenHeight - height - 35;
                    ((PrintScreen)PrintScreen.this).coordinate2.x = width;
                    ((PrintScreen)PrintScreen.this).coordinate2.y = PrintScreen.this.screenHeight - 35;
                } else if (x1 < 0 && y1 > 15 && y2 < PrintScreen.this.screenHeight - 35) {
                    ((PrintScreen)PrintScreen.this).coordinate1.x = 0;
                    ((PrintScreen)PrintScreen.this).coordinate1.y = y1;
                    ((PrintScreen)PrintScreen.this).coordinate2.x = width;
                    ((PrintScreen)PrintScreen.this).coordinate2.y = y2;
                } else {
                    ((PrintScreen)PrintScreen.this).coordinate1.x = x1;
                    ((PrintScreen)PrintScreen.this).coordinate1.y = y1;
                    ((PrintScreen)PrintScreen.this).coordinate2.x = x2;
                    ((PrintScreen)PrintScreen.this).coordinate2.y = y2;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (selectPnl.isDrawed()) {
                    return;
                }
                if (!PrintScreen.this.selectedScreen) {
                    PrintScreen.this.x = e.getX();
                    PrintScreen.this.y = e.getY();
                    if (PrintScreen.this.x >= ((PrintScreen)PrintScreen.this).coordinate1.x - 2 && PrintScreen.this.x <= ((PrintScreen)PrintScreen.this).coordinate1.x + 2 && PrintScreen.this.y >= ((PrintScreen)PrintScreen.this).coordinate1.y - 2 && PrintScreen.this.y <= ((PrintScreen)PrintScreen.this).coordinate1.y + 2) {
                        PrintScreen.this.direction = Direction.LEFT_UP;
                    } else if (PrintScreen.this.x >= ((PrintScreen)PrintScreen.this).coordinate1.x - 2 && PrintScreen.this.x <= ((PrintScreen)PrintScreen.this).coordinate1.x + 2 && PrintScreen.this.y >= ((PrintScreen)PrintScreen.this).coordinate2.y - 2 && PrintScreen.this.y <= ((PrintScreen)PrintScreen.this).coordinate2.y + 2) {
                        PrintScreen.this.direction = Direction.LEFT_DOWN;
                    } else if (PrintScreen.this.x >= ((PrintScreen)PrintScreen.this).coordinate1.x - 2 && PrintScreen.this.x <= ((PrintScreen)PrintScreen.this).coordinate1.x + 2 && PrintScreen.this.y >= (((PrintScreen)PrintScreen.this).coordinate1.y + ((PrintScreen)PrintScreen.this).coordinate2.y) / 2 - 2 && PrintScreen.this.y <= (((PrintScreen)PrintScreen.this).coordinate1.y + ((PrintScreen)PrintScreen.this).coordinate2.y) / 2 + 2) {
                        PrintScreen.this.direction = Direction.LEFT;
                    } else if (PrintScreen.this.x >= ((PrintScreen)PrintScreen.this).coordinate2.x - 2 && PrintScreen.this.x <= ((PrintScreen)PrintScreen.this).coordinate2.x + 2 && PrintScreen.this.y >= ((PrintScreen)PrintScreen.this).coordinate1.y - 2 && PrintScreen.this.y <= ((PrintScreen)PrintScreen.this).coordinate1.y + 2) {
                        PrintScreen.this.direction = Direction.RIGHT_UP;
                    } else if (PrintScreen.this.x >= ((PrintScreen)PrintScreen.this).coordinate2.x - 2 && PrintScreen.this.x <= ((PrintScreen)PrintScreen.this).coordinate2.x + 2 && PrintScreen.this.y >= ((PrintScreen)PrintScreen.this).coordinate2.y - 2 && PrintScreen.this.y <= ((PrintScreen)PrintScreen.this).coordinate2.y + 2) {
                        PrintScreen.this.direction = Direction.RIGHT_DOWN;
                    } else if (PrintScreen.this.x >= ((PrintScreen)PrintScreen.this).coordinate2.x - 2 && PrintScreen.this.x <= ((PrintScreen)PrintScreen.this).coordinate2.x + 2 && PrintScreen.this.y >= (((PrintScreen)PrintScreen.this).coordinate1.y + ((PrintScreen)PrintScreen.this).coordinate2.y) / 2 - 2 && PrintScreen.this.y <= (((PrintScreen)PrintScreen.this).coordinate1.y + ((PrintScreen)PrintScreen.this).coordinate2.y) / 2 + 2) {
                        PrintScreen.this.direction = Direction.RIGHT;
                    } else if (PrintScreen.this.x >= (((PrintScreen)PrintScreen.this).coordinate1.x + ((PrintScreen)PrintScreen.this).coordinate2.x) / 2 - 2 && PrintScreen.this.x <= (((PrintScreen)PrintScreen.this).coordinate1.x + ((PrintScreen)PrintScreen.this).coordinate2.x) / 2 + 2 && PrintScreen.this.y >= ((PrintScreen)PrintScreen.this).coordinate1.y - 2 && PrintScreen.this.y <= ((PrintScreen)PrintScreen.this).coordinate1.y + 2) {
                        PrintScreen.this.direction = Direction.UP;
                    } else if (PrintScreen.this.x >= (((PrintScreen)PrintScreen.this).coordinate1.x + ((PrintScreen)PrintScreen.this).coordinate2.x) / 2 - 2 && PrintScreen.this.x <= (((PrintScreen)PrintScreen.this).coordinate1.x + ((PrintScreen)PrintScreen.this).coordinate2.x) / 2 + 2 && PrintScreen.this.y >= ((PrintScreen)PrintScreen.this).coordinate2.y - 2 && PrintScreen.this.y <= ((PrintScreen)PrintScreen.this).coordinate2.y + 2) {
                        PrintScreen.this.direction = Direction.DOWN;
                    } else if (PrintScreen.this.x > ((PrintScreen)PrintScreen.this).coordinate1.x && PrintScreen.this.x < ((PrintScreen)PrintScreen.this).coordinate2.x && PrintScreen.this.y > ((PrintScreen)PrintScreen.this).coordinate1.y && PrintScreen.this.y < ((PrintScreen)PrintScreen.this).coordinate2.y) {
                        PrintScreen.this.direction = Direction.AT_CENTER;
                    } else {
                        PrintScreen.this.direction = Direction.STOP;
                    }
                    switch (PrintScreen.this.direction) {
                        case LEFT_UP: {
                            PrintScreen.this.setCursor(new Cursor(6));
                            break;
                        }
                        case LEFT: {
                            PrintScreen.this.setCursor(new Cursor(10));
                            break;
                        }
                        case LEFT_DOWN: {
                            PrintScreen.this.setCursor(new Cursor(4));
                            break;
                        }
                        case RIGHT_UP: {
                            PrintScreen.this.setCursor(new Cursor(7));
                            break;
                        }
                        case RIGHT: {
                            PrintScreen.this.setCursor(new Cursor(11));
                            break;
                        }
                        case RIGHT_DOWN: {
                            PrintScreen.this.setCursor(new Cursor(5));
                            break;
                        }
                        case UP: {
                            PrintScreen.this.setCursor(new Cursor(8));
                            break;
                        }
                        case DOWN: {
                            PrintScreen.this.setCursor(new Cursor(9));
                            break;
                        }
                        default: {
                            PrintScreen.this.setCursor(new Cursor(0));
                        }
                    }
                }
            }
        });
    }

    public JDialog getParentDialog() {
        return this.parentDialog;
    }

    public void setParentDialog(JDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(JFrame parent) {
        this.parentFrame = parent;
    }

    public void saveImageFile() {
        this.setAlwaysOnTop(false);
        this.fileDialog.setVisible(true);
        if (this.fileDialog.getDirectory() == null) {
            return;
        }
        this.fileDialog.setFilenameFilter(new FilenameFilter(){
            String about = "png";

            @Override
            public boolean accept(File dir, String name) {
                if (!name.endsWith(".png")) {
                    String ns = name + ".png";
                    PrintScreen.this.fileForPic = new File(ns);
                    this.about = "PNG";
                }
                return false;
            }
        });
        File file = new File(this.fileDialog.getDirectory());
        file.mkdir();
        this.sbi = ((BufferedImage)this.imageCache).getSubimage(this.coordinate1.x, this.coordinate1.y, Math.abs(this.coordinate2.x - this.coordinate1.x), Math.abs(this.coordinate2.y - this.coordinate1.y));
        try {
            ImageIO.write((RenderedImage)this.sbi, "png", new File(file, this.fileDialog.getFile() + ".png"));
        }
        catch (IOException e1) {
            System.out.println("save failed\uff01");
        }
        this.dispose();
    }

    public void getBufferedImageForSave() {
        try {
            if (this.isUserDrawed) {
                this.imageCache = new Robot().createScreenCapture(new Rectangle(0, 0, this.screenWidth, this.screenHeight));
                this.getBufferedImage(this.imageCache);
            } else {
                this.getBufferedImage(this.originalImageCache);
            }
        }
        catch (AWTException e) {
            System.out.println("create picture cache failed!");
        }
    }

    public BufferedImage getBufferedImage(Image img) {
        if (this.coordinate2.x > this.coordinate1.x && this.coordinate2.y > this.coordinate1.y) {
            this.sbi = ((BufferedImage)img).getSubimage(this.coordinate1.x, this.coordinate1.y, Math.abs(this.coordinate2.x - this.coordinate1.x), Math.abs(this.coordinate2.y - this.coordinate1.y));
        } else if (this.coordinate2.x < this.coordinate1.x && this.coordinate2.y < this.coordinate1.y) {
            this.sbi = ((BufferedImage)img).getSubimage(this.coordinate2.x, this.coordinate2.y, Math.abs(this.coordinate1.x - this.coordinate2.x), Math.abs(this.coordinate1.y - this.coordinate2.y));
        } else if (this.coordinate2.x > this.coordinate1.x && this.coordinate2.y < this.coordinate1.y) {
            this.sbi = ((BufferedImage)img).getSubimage(this.coordinate1.x, this.coordinate2.y, Math.abs(this.coordinate2.x - this.coordinate1.x), Math.abs(this.coordinate1.y - this.coordinate2.y));
        } else if (this.coordinate2.x < this.coordinate1.x && this.coordinate2.y > this.coordinate1.y) {
            this.sbi = ((BufferedImage)img).getSubimage(this.coordinate2.x, this.coordinate1.y, Math.abs(this.coordinate1.x - this.coordinate2.x), Math.abs(this.coordinate2.y - this.coordinate1.y));
        }
        return this.sbi;
    }

    public void addPrintScreenListener(IPrintScreenListener l) {
        if (l != null) {
            this.lis = l;
        }
    }

    public void firePrintScreenListener() {
        if (this.lis != null) {
            this.lis.printScreenClose(this.imageRef);
        }
    }

    public static void main(String[] args) {
        PrintScreenRef ref = new PrintScreenRef();
        new PrintScreen(ref);
    }

    private class SelectPanel
    extends JPanel {
        private static final long serialVersionUID = 9015324286219405893L;
        JPanel pnlTool = new JPanel();
        JToolBar toolBar = new JToolBar();
        KDToggleButton btnPen = new KDToggleButton();
        KDWorkButton btnEllipse = new KDWorkButton();
        KDWorkButton btnRect = new KDWorkButton();
        KDWorkButton btnWord = new KDWorkButton();
        KDWorkButton btnClear = new KDWorkButton();
        KDWorkButton btnSave = new KDWorkButton();
        KDWorkButton btnCancel = new KDWorkButton();
        KDWorkButton btnComplete = new KDWorkButton();
        KDSeparator sp1 = new KDSeparator();
        Window parent;
        boolean binitToolPanel = false;
        boolean isDrawed = false;
        boolean isSave = false;

        public SelectPanel(Window owner) {
            this.parent = owner;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.update(g);
            PrintScreen.this.r.setLocation(PrintScreen.this.coordinate1, PrintScreen.this.coordinate2);
            if (this.isDrawed) {
                PrintScreen.this.r.setMoveabled(false);
            }
            PrintScreen.this.r.drawRect(g);
            this.setBackground(Color.cyan);
            if (!PrintScreen.this.selectedScreen) {
                this.initToolPanel();
                this.pnlTool.repaint();
            }
        }

        @Override
        public void update(Graphics g) {
            if (PrintScreen.this.originalImageCache == null) {
                try {
                    PrintScreen.this.imageCache = new Robot().createScreenCapture(new Rectangle(0, 0, PrintScreen.this.screenWidth, PrintScreen.this.screenHeight));
                }
                catch (AWTException e) {
                    System.out.println("create picture cache failed!");
                }
            }
            g.drawImage(PrintScreen.this.originalImageCache, 0, 0, PrintScreen.this.screenWidth, PrintScreen.this.screenHeight, this);
        }

        private void initToolPanel() {
            if (this.binitToolPanel) {
                this.initToolBarLayout();
            }
            this.sp1.setOrientation(1);
            this.sp1.setSize(2, 26);
            this.btnPen.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"31_PrintScreen"));
            this.btnPen.setIcon(FWResourceManager.getIcon("tbtn_brush.gif"));
            this.btnPen.setHorizontalTextPosition(0);
            this.btnEllipse.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"32_PrintScreen"));
            this.btnEllipse.setIcon(FWResourceManager.getIcon("tbtn_round.gif"));
            this.btnRect.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"33_PrintScreen"));
            this.btnRect.setIcon(FWResourceManager.getIcon("tbtn_rectangle.gif"));
            this.btnWord.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"34_PrintScreen"));
            this.btnWord.setIcon(FWResourceManager.getIcon("tbtn_word.gif"));
            this.btnClear.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"35_PrintScreen"));
            this.btnClear.setIcon(FWResourceManager.getIcon("tbtn_revoked.gif"));
            this.btnSave.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"36_PrintScreen"));
            this.btnSave.setIcon(FWResourceManager.getIcon("tbtn_save.gif"));
            this.btnCancel.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"12_CloudShareDialog"));
            this.btnCancel.setIcon(FWResourceManager.getIcon("tbtn_cancel.gif"));
            this.btnComplete.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"37_PrintScreen"));
            this.btnComplete.setIcon(FWResourceManager.getIcon("tbtn_determine.gif"));
            this.btnComplete.setHorizontalTextPosition(2);
            this.btnPen.setSize(26, 24);
            this.btnPen.setLocation(3, 3);
            this.btnEllipse.setSize(26, 24);
            this.btnEllipse.setLocation(this.btnPen.getX() + 26 + 2, 3);
            this.btnRect.setSize(26, 24);
            this.btnRect.setLocation(this.btnEllipse.getX() + 26 + 2, 3);
            this.btnWord.setSize(26, 24);
            this.btnWord.setLocation(this.btnRect.getX() + 26 + 2, 3);
            this.btnClear.setSize(26, 24);
            this.btnClear.setLocation(this.btnWord.getX() + 26 + 2, 3);
            this.sp1.setLocation(115, 2);
            this.btnSave.setSize(26, 24);
            this.btnSave.setLocation(this.btnClear.getX() + 26 + 4, 3);
            this.btnCancel.setSize(26, 24);
            this.btnCancel.setLocation(this.btnSave.getX() + 26 + 2, 3);
            this.btnComplete.setSize(26, 24);
            this.btnComplete.setLocation(this.btnCancel.getX() + 26 + 2, 3);
            this.initToolBarLayout();
            if (!this.binitToolPanel) {
                this.initToolBarListener();
            }
            this.binitToolPanel = true;
        }

        private void initToolBarListener() {
            this.btnPen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectPanel.this.initDraw();
                    PrintScreen.this.draw.setTool(4);
                    PrintScreen.this.draw.setStrokeIndex(4);
                    PrintScreen.this.draw.setForeground(Color.BLACK);
                }
            });
            this.btnRect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectPanel.this.initDraw();
                    PrintScreen.this.draw.setTool(1);
                    PrintScreen.this.draw.setStrokeIndex(0);
                    PrintScreen.this.draw.setForeground(Color.red);
                }
            });
            this.btnEllipse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectPanel.this.initDraw();
                    PrintScreen.this.draw.setTool(2);
                    PrintScreen.this.draw.setStrokeIndex(0);
                    PrintScreen.this.draw.setForeground(Color.red);
                }
            });
            this.btnWord.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectPanel.this.initDraw();
                    PrintScreen.this.draw.setTool(7);
                    PrintScreen.this.draw.setStrokeIndex(0);
                    PrintScreen.this.draw.setForeground(Color.red);
                }
            });
            this.btnClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectPanel.this.initDraw();
                    PrintScreen.this.draw.clearBoard();
                }
            });
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectPanel.this.initDraw();
                    PrintScreen.this.getBufferedImageForSave();
                    SelectPanel.this.doSave();
                    if (SelectPanel.this.isSave) {
                        if (PrintScreen.this.parentDialog != null) {
                            PrintScreen.this.parentDialog.setVisible(true);
                        }
                        if (PrintScreen.this.getParentFrame() != null) {
                            PrintScreen.this.getParentFrame().setVisible(true);
                        }
                        PrintScreen.this.firePrintScreenListener();
                        PrintScreen.this.dispose();
                    } else {
                        PrintScreen.this.draw.repaint();
                    }
                }
            });
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PrintScreen.this.parentDialog != null) {
                        PrintScreen.this.parentDialog.setVisible(true);
                    }
                    if (PrintScreen.this.getParentFrame() != null) {
                        PrintScreen.this.getParentFrame().setVisible(true);
                    }
                    PrintScreen.this.dispose();
                }
            });
            this.btnComplete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintScreen.this.getBufferedImageForSave();
                    if (PrintScreen.this.imageRef != null) {
                        PrintScreen.this.imageRef.setBufferedImage(PrintScreen.this.sbi);
                    }
                    if (PrintScreen.this.parentDialog != null) {
                        PrintScreen.this.parentDialog.setVisible(true);
                    }
                    if (PrintScreen.this.getParentFrame() != null) {
                        PrintScreen.this.getParentFrame().setVisible(true);
                    }
                    PrintScreen.this.firePrintScreenListener();
                    PrintScreen.this.dispose();
                }
            });
        }

        private void initToolBarLayout() {
            if (((PrintScreen)PrintScreen.this).coordinate2.x > ((PrintScreen)PrintScreen.this).coordinate1.x && ((PrintScreen)PrintScreen.this).coordinate2.y > ((PrintScreen)PrintScreen.this).coordinate1.y) {
                this.pnlTool.setBounds(((PrintScreen)PrintScreen.this).coordinate2.x - 230, ((PrintScreen)PrintScreen.this).coordinate2.y + 5, 230, 30);
            } else if (((PrintScreen)PrintScreen.this).coordinate2.x < ((PrintScreen)PrintScreen.this).coordinate1.x && ((PrintScreen)PrintScreen.this).coordinate2.y < ((PrintScreen)PrintScreen.this).coordinate1.y) {
                this.pnlTool.setBounds(((PrintScreen)PrintScreen.this).coordinate1.x - 230, ((PrintScreen)PrintScreen.this).coordinate1.y + 5, 230, 30);
            } else if (((PrintScreen)PrintScreen.this).coordinate2.x > ((PrintScreen)PrintScreen.this).coordinate1.x && ((PrintScreen)PrintScreen.this).coordinate2.y < ((PrintScreen)PrintScreen.this).coordinate1.y) {
                this.pnlTool.setBounds(((PrintScreen)PrintScreen.this).coordinate2.x - 230, ((PrintScreen)PrintScreen.this).coordinate1.y + 5, 230, 30);
            } else if (((PrintScreen)PrintScreen.this).coordinate2.x < ((PrintScreen)PrintScreen.this).coordinate1.x && ((PrintScreen)PrintScreen.this).coordinate2.y > ((PrintScreen)PrintScreen.this).coordinate1.y) {
                this.pnlTool.setBounds(((PrintScreen)PrintScreen.this).coordinate1.x - 230, ((PrintScreen)PrintScreen.this).coordinate2.y + 5, 230, 30);
            }
            this.toolBar.setBounds(0, 0, 230, 30);
            this.toolBar.add((Component)this.btnPen);
            this.toolBar.add((Component)this.btnRect);
            this.toolBar.add((Component)this.btnEllipse);
            this.toolBar.add((Component)this.btnWord);
            this.toolBar.add((Component)this.btnClear);
            this.toolBar.addSeparator();
            this.toolBar.add((Component)this.btnSave);
            this.toolBar.add((Component)this.btnCancel);
            this.toolBar.add((Component)this.btnComplete);
            this.pnlTool.add(this.toolBar);
            this.add(this.pnlTool);
        }

        public boolean isDrawed() {
            return this.isDrawed;
        }

        private void initDraw() {
            if (this.isDrawed) {
                return;
            }
            PrintScreen.this.draw.setSize(((PrintScreen)PrintScreen.this).coordinate2.x - ((PrintScreen)PrintScreen.this).coordinate1.x, ((PrintScreen)PrintScreen.this).coordinate2.y - ((PrintScreen)PrintScreen.this).coordinate1.y);
            PrintScreen.this.draw.setLocation(((PrintScreen)PrintScreen.this).coordinate1.x, ((PrintScreen)PrintScreen.this).coordinate1.y);
            BufferedImage img = PrintScreen.this.getBufferedImage(PrintScreen.this.originalImageCache);
            PrintScreen.this.draw.setImage(img);
            this.add(PrintScreen.this.draw);
            PrintScreen.this.isUserDrawed = this.isDrawed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSave() {
            try {
                KDFileChooser jfc = FileUtils.initPicKDFileChooser();
                int i = jfc.showSaveDialog((Component)this.parent);
                if (i == 0) {
                    File file = jfc.getSelectedFile();
                    int index = file.getName().indexOf(".");
                    String about = file.getName().substring(index + 1).toUpperCase();
                    if (ImageIO.write((RenderedImage)PrintScreen.this.sbi, about, file)) {
                        this.isSave = true;
                        System.out.println("save file:" + file.toString());
                    }
                }
            }
            catch (Exception exe) {
                exe.printStackTrace();
                logger.error((Object)exe);
            }
        }

        private class PNGfilter
        extends FileFilter {
            private PNGfilter() {
            }

            @Override
            public boolean accept(File file) {
                return file.toString().toLowerCase(Locale.ENGLISH).endsWith(".png") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"28_CloudShareDialog");
            }
        }

        private class JPGfilter
        extends FileFilter {
            @Override
            public boolean accept(File file) {
                return file.toString().toLowerCase(Locale.ENGLISH).endsWith(".jpg") || file.toString().toLowerCase(Locale.ENGLISH).endsWith(".jpeg") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"27_CloudShareDialog");
            }
        }
    }
}

