/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.cloud.screen.draw;

import com.kingdee.eas.framework.client.cloud.screen.draw.IShape;
import com.kingdee.eas.framework.client.cloud.screen.draw.PointsSet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;

public class PolyGon
implements IShape {
    private Color color;
    private Stroke stroke;
    private PointsSet pointsSet = new PointsSet();
    private boolean finalized;
    private int currX;
    private int currY;

    public PolyGon(Color c, Stroke s, int x, int y) {
        this.color = c;
        this.stroke = s;
        this.pointsSet.addPoint(x, y);
        this.currX = x;
        this.currY = y;
        this.finalized = false;
    }

    @Override
    public void processCursorEvent(MouseEvent e, int t) {
        this.currX = e.getX();
        this.currY = e.getY();
        if (t == 0) {
            this.pointsSet.addPoint(this.currX, this.currY);
        } else if (t == 1) {
            this.finalized = true;
            this.pointsSet.addPoint(this.currX, this.currY);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(this.color);
        g.setStroke(this.stroke);
        if (this.finalized) {
            int[][] points = this.pointsSet.getPoints();
            int s = points[0].length;
            if (s == 1) {
                int x = points[0][0];
                int y = points[1][0];
                g.drawLine(x, y, x, y);
            } else {
                g.drawPolygon(points[0], points[1], s);
            }
        } else {
            int[][] points = this.pointsSet.getPoints(this.currX, this.currY);
            g.drawPolyline(points[0], points[1], points[0].length);
        }
    }
}

