/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.cloud.screen.draw;

import com.kingdee.eas.framework.client.cloud.screen.draw.IShape;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.MouseEvent;

public abstract class RectBoundedShape
implements IShape {
    protected Color color;
    protected Stroke stroke;
    protected int startX;
    protected int startY;
    protected int endX;
    protected int endY;

    protected RectBoundedShape(Color c, Stroke s, int x, int y) {
        this.color = c;
        this.stroke = s;
        this.startX = this.endX = x;
        this.startY = this.endY = y;
    }

    @Override
    public void processCursorEvent(MouseEvent e, int t) {
        if (t != 2) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (e.isShiftDown()) {
            this.regulateShape(x, y);
        } else {
            this.endX = x;
            this.endY = y;
        }
    }

    protected void regulateShape(int x, int y) {
        int w = x - this.startX;
        int h = y - this.startY;
        int s = Math.min(Math.abs(w), Math.abs(h));
        if (s == 0) {
            this.endX = this.startX;
            this.endY = this.startY;
        } else {
            this.endX = this.startX + s * (w / Math.abs(w));
            this.endY = this.startY + s * (h / Math.abs(h));
        }
    }
}

