/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.commonquery;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.base.commonquery.ColumnItemData;
import com.kingdee.eas.base.commonquery.UserCustomConfigItemData;
import org.apache.log4j.Logger;

public class CommonQueryUtil {
    private static Logger logger = Logger.getLogger(CommonQueryUtil.class);
    public static final String IS_NOT_MUST_QUERY_FIELD = "DYNAMIC_CAN_DELETE";

    public static SelectorItemCollection getNotNeedQueryCollection(KDTable table, UserCustomConfigItemData itemData, QueryInfo queryInfo) {
        SelectorItemCollection notNeedQueryCollection = null;
        if (itemData != null && queryInfo != null) {
            notNeedQueryCollection = new SelectorItemCollection();
            QueryFieldCollection queryFields = queryInfo.getUnits().getQueryFields();
            for (String key : itemData.getColumnData().keySet()) {
                ColumnItemData columnData = (ColumnItemData)itemData.getColumnData().get(key);
                if (!columnData.isHidden()) continue;
                String queryFieldName = CommonQueryUtil.getFieldNameByKeyFromTable(table, key);
                if (queryFieldName == null) {
                    notNeedQueryCollection.add(new SelectorItemInfo(key));
                    continue;
                }
                if (!queryFields.contains(queryFieldName)) {
                    notNeedQueryCollection.add(new SelectorItemInfo(queryFieldName));
                    continue;
                }
                QueryFieldInfo queryField = queryFields.get(queryFieldName);
                if (!"true".equalsIgnoreCase(queryField.getExtendedProperty(IS_NOT_MUST_QUERY_FIELD))) continue;
                notNeedQueryCollection.add(new SelectorItemInfo(queryFieldName));
            }
        }
        return notNeedQueryCollection;
    }

    public static String getFieldNameByKeyFromTable(KDTable table, String key) {
        if (table != null && key != null) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                IColumn col = table.getColumn(i);
                if (!key.equals(col.getKey())) continue;
                return col.getFieldName();
            }
        }
        return null;
    }
}

