/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.context;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.client.service.FieldPermissionService;

public class OrgContextHelper {
    private IObjectPK userPK = null;
    private IMetaDataPK mainQueryPK = null;
    private KDTable tblMain = null;
    private DataBinder dataBinder = null;
    private BOSObjectType bizObjectType = null;
    private ContextTypeEnum contextType = null;

    public OrgContextHelper(IMetaDataPK mainQueryPK, KDTable tblMain) {
        this.mainQueryPK = mainQueryPK;
        this.tblMain = tblMain;
        this.contextType = ContextTypeEnum.INQUERYING;
        this.userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    public OrgContextHelper(DataBinder dataBinder, BOSObjectType bizObjectType) {
        this.dataBinder = dataBinder;
        this.bizObjectType = bizObjectType;
        this.contextType = ContextTypeEnum.INMAINTAINING;
        this.userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    public void handleFieldPermission(IObjectPK orgPK) throws Exception {
        if (ContextTypeEnum.INQUERYING.equals((Object)this.contextType)) {
            FieldPermissionService.doFieldPermission(this.mainQueryPK, this.userPK, orgPK, this.tblMain);
        }
        if (ContextTypeEnum.INMAINTAINING.equals((Object)this.contextType)) {
            FieldPermissionService.doFieldPermission(this.bizObjectType, this.userPK, orgPK, this.dataBinder);
        }
    }

    public FilterInfo buildBotpFilter() {
        return null;
    }

    public OrgUnitCollection getHasPermissionOrgs() {
        return null;
    }

    public ContextTypeEnum getContextType() {
        return this.contextType;
    }

    public void setContextType(ContextTypeEnum contextType) {
        this.contextType = contextType;
    }

    public FilterInfo buildCooperatedFilter() {
        return null;
    }
}

