/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.context;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewHROF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.OrgContextHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;

public class OrgContextManager {
    private IMultiOrgSupport owner = null;
    private OrgContextHelper helper = null;
    private ContextTypeEnum contextType = null;
    private Context mainOrgContext = null;
    private IDelegationSupport delegationSupport = null;
    private Map uiContext = null;

    public OrgContextManager(IMultiOrgSupport owner, ContextTypeEnum contextType, OrgContextHelper helper) {
        this.owner = owner;
        this.contextType = contextType;
        this.helper = helper;
        this.mainOrgContext = new Context();
    }

    public OrgContextManager(IMultiOrgSupport owner, ContextTypeEnum contextType, OrgContextHelper helper, IDelegationSupport delegationSupport) {
        this(owner, contextType, helper);
        this.delegationSupport = delegationSupport;
    }

    public IMultiOrgSupport getOwner() {
        return this.owner;
    }

    public void init(Map uiContext) {
        if (this.owner == null) {
            return;
        }
        this.uiContext = uiContext;
        KDBizPromptBox prmtBizOrg = this.owner.getMainOrg();
        if (prmtBizOrg != null) {
            this.setMainBizOrgF7(prmtBizOrg);
            this.initDefaultMainOrgContext(uiContext);
            prmtBizOrg.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    OrgChangeVO orgChg = new OrgChangeVO(eventObj.getOldValue(), eventObj.getNewValue());
                    if (orgChg.isDiffrent()) {
                        OrgUnitInfo org = OrgContextManager.this.convertDataToOrgUnitInfo(orgChg.getNewOrg());
                        OrgUnitCollection orgCol = OrgContextManager.this.convertDataToOrgUnitCol(orgChg.getNewOrg());
                        if (org != null) {
                            OrgContextManager.this.initMainOrgContext(org.getId().toString());
                        }
                        if (ContextTypeEnum.INQUERYING.equals((Object)OrgContextManager.this.contextType) && orgCol != null) {
                            OrgContextManager.this.uiContext.put("multi_org_context", orgCol);
                        }
                        if (OrgContextManager.this.owner.getF7ContextManager() != null) {
                            if (ContextTypeEnum.INQUERYING.equals((Object)OrgContextManager.this.contextType)) {
                                OrgContextManager.this.owner.getF7ContextManager().changeF7Context(OrgContextManager.this.uiContext, OrgContextManager.this.mainOrgContext, orgCol);
                            } else {
                                OrgContextManager.this.owner.getF7ContextManager().changeF7Context(OrgContextManager.this.uiContext, OrgContextManager.this.mainOrgContext);
                            }
                        }
                        OrgContextManager.this.owner.afterMainOrgChanged(orgChg);
                    }
                }
            });
        }
    }

    protected void initDefaultMainOrgContext(Map uiContext) {
        if (ContextTypeEnum.INMAINTAINING.equals((Object)this.contextType) && uiContext.get("CONTEXT_INMAINTAINING_STATE") != null && OprtState.ADDNEW.equals(uiContext.get("CONTEXT_INMAINTAINING_STATE"))) {
            OrgUnitInfo orgUnitInfo = null;
            if (this.owner != null) {
                if (uiContext.get(this.owner.getMainOrgType()) != null && uiContext.get(this.owner.getMainOrgType()) instanceof OrgUnitInfo) {
                    orgUnitInfo = (OrgUnitInfo)uiContext.get(this.owner.getMainOrgType());
                }
                if (orgUnitInfo == null) {
                    orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit(this.owner.getMainOrgType());
                }
                try {
                    FullOrgUnitCollection orgCol;
                    UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
                    String permissionItem = this.owner.getPermissionItem();
                    IPermission permission = PermissionFactory.getRemoteInstance();
                    if (!StringUtils.isEmpty((String)permissionItem) && orgUnitInfo != null && user != null && !permission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), permissionItem)) {
                        orgUnitInfo = null;
                    }
                    if (orgUnitInfo == null && (orgCol = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(user.getId()), this.owner.getMainOrgType(), (IObjectPK)new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)this.owner.getMainOrgType())), permissionItem)) != null && orgCol.size() > 0) {
                        orgUnitInfo = orgCol.get(0);
                    }
                    if (orgUnitInfo != null) {
                        this.initMainOrgContext(orgUnitInfo.getId().toString());
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
    }

    private void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox) {
        if (bizOrgUnitBox != null && this.owner != null) {
            NewOrgUnitFilterInfoProducer iProducer = null;
            String permissionItem = this.owner.getPermissionItem();
            if (ContextTypeEnum.INQUERYING.equals((Object)this.contextType)) {
                NewHROF7 model = null;
                if (this.owner.getMainOrgType().equals((Object)OrgType.HRO)) {
                    model = new NewHROF7();
                }
                iProducer = !this.owner.isSupportVirturalOrgs() ? new NewOrgUnitFilterInfoProducer(this.owner.getMainOrgType()) : (model != null ? new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)model) : new NewOrgUnitFilterInfoProducer(this.owner.getMainOrgType()));
            } else {
                iProducer = new NewOrgUnitFilterInfoProducer(this.owner.getMainOrgType());
            }
            if (iProducer != null) {
                if (permissionItem != null) {
                    iProducer.getModel().setPermissionItem(permissionItem);
                }
                bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                if (iProducer.getModel() != null) {
                    bizOrgUnitBox.setSelector((KDPromptSelector)iProducer.getModel());
                    iProducer.getModel().setMultiSelect(this.owner.isSupportMultiOrgs());
                }
            }
            bizOrgUnitBox.setCommitFormat("$number$;$code$");
            bizOrgUnitBox.setEditFormat("$number$");
            bizOrgUnitBox.setDisplayFormat("$name$");
            bizOrgUnitBox.setEnabledMultiSelection(this.owner.isSupportMultiOrgs());
            if (this.owner.getMainOrgType().equals((Object)OrgType.HRO)) {
                bizOrgUnitBox.setQueryInfo("com.kingdee.eas.basedata.org.app.HROrgUnitQuery");
            }
        }
    }

    protected void initMainOrgContext(String orgId) {
        OrgUnitInfo orgUnitInfo;
        if (orgId == null) {
            return;
        }
        if (this.mainOrgContext != null) {
            orgUnitInfo = FrameWorkUtils.getCurrentOrgUnit(this.mainOrgContext, this.owner.getMainOrgType());
            if (orgUnitInfo != null && orgId.equals(orgUnitInfo.getId().toString())) {
                return;
            }
        } else {
            this.mainOrgContext = new Context();
        }
        try {
            FrameWorkUtils.switchOrg(this.mainOrgContext, orgId);
            orgUnitInfo = FrameWorkUtils.getCurrentOrgUnit(this.mainOrgContext, this.owner.getMainOrgType());
            if (orgUnitInfo != null) {
                this.uiContext.put(this.owner.getMainOrgType(), orgUnitInfo);
                this.uiContext.put("ORG.PK", new ObjectUuidPK(orgUnitInfo.getId()));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public OrgType getMainOrgType() {
        if (this.owner != null) {
            return this.owner.getMainOrgType();
        }
        return null;
    }

    public Context getMainOrgContext() {
        return this.mainOrgContext;
    }

    private OrgUnitInfo convertDataToOrgUnitInfo(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof OrgUnitInfo) {
            return (OrgUnitInfo)data;
        }
        if (data instanceof Object[]) {
            Object[] orgs = (Object[])data;
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            BOSUuid userDefaultOrgID = userInfo.getDefOrgUnit().getId();
            for (int i = 0; i < orgs.length; ++i) {
                if (!((OrgUnitInfo)orgs[i]).getId().equals((Object)userDefaultOrgID)) continue;
                return (OrgUnitInfo)orgs[i];
            }
            if (orgs.length > 0) {
                return (OrgUnitInfo)orgs[0];
            }
        }
        return null;
    }

    private OrgUnitCollection convertDataToOrgUnitCol(Object data) {
        if (data == null) {
            return null;
        }
        OrgUnitCollection col = new OrgUnitCollection();
        if (data instanceof OrgUnitInfo) {
            col.add((OrgUnitInfo)data);
            return col;
        }
        if (data instanceof Object[]) {
            Object[] orgs = (Object[])data;
            for (int i = 0; i < orgs.length; ++i) {
                col.add((OrgUnitInfo)orgs[i]);
            }
            return col;
        }
        return null;
    }

    public FilterInfo changeQueryContext(QuerySolutionInfo solution, Map uiContext) throws Exception {
        this.uiContext = uiContext;
        OrgUnitInfo[] orgs = this.getOrgFromQuerySolution(solution);
        OrgUnitInfo mainOrg = this.convertDataToOrgUnitInfo(orgs);
        if (mainOrg == null && this.owner != null) {
            String permissionItem;
            OrgUnitInfo currOrg = SysContext.getSysContext().getCurrentOrgUnit(this.owner.getMainOrgType());
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            if (currOrg != null && user != null && !StringUtils.isEmpty((String)(permissionItem = this.owner.getPermissionItem())) && PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(currOrg.getId()), permissionItem)) {
                mainOrg = currOrg;
            }
        }
        if (mainOrg != null) {
            this.initMainOrgContext(mainOrg.getId().toString());
            if (orgs == null) {
                orgs = new OrgUnitInfo[]{mainOrg};
            }
        }
        if (orgs != null) {
            OrgUnitCollection col = new OrgUnitCollection();
            for (int i = 0; i < orgs.length; ++i) {
                col.add(orgs[i]);
            }
            this.uiContext.put("multi_org_context", col);
        }
        FilterInfo filter = new FilterInfo();
        if (this.delegationSupport != null && this.owner != null && this.delegationSupport.getPropertyOfBizOrg(this.owner.getMainOrgType()) != null) {
            if (orgs != null && orgs.length > 0) {
                HashSet<String> idSet = new HashSet<String>();
                for (int i = 0; i < orgs.length; ++i) {
                    idSet.add(orgs[i].getId().toString());
                }
                filter.getFilterItems().add(new FilterItemInfo(this.delegationSupport.getPropertyOfBizOrg(this.owner.getMainOrgType()), idSet, CompareType.INCLUDE));
            } else if (mainOrg != null) {
                filter.getFilterItems().add(new FilterItemInfo(this.delegationSupport.getPropertyOfBizOrg(this.owner.getMainOrgType()), (Object)mainOrg.getId().toString()));
            }
        }
        return filter;
    }

    private OrgUnitInfo[] getOrgFromQuerySolution(QuerySolutionInfo solution) throws Exception {
        if (this.owner == null) {
            return null;
        }
        String key = this.owner.getMainOrgKeyForCustomerParams(this.owner.getMainOrgType());
        if (solution != null && key != null) {
            QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
            int size = queryPanelCollection.size();
            for (int i = 0; i < size; ++i) {
                String params;
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
                if (queryPanelInfo.getPanelClassName() == null || !QueryPanelTypeEnum.CUSTOMER_PANEL.equals((Object)queryPanelInfo.getQueryPanelType()) || (params = queryPanelInfo.getCustomerParams()) == null) continue;
                CustomerParams cp = new CustomerParams();
                ArrayList al = XMLBean.TransStrToAL((String)params);
                Iterator j = al.iterator();
                XMLBean xb = null;
                while (j.hasNext()) {
                    xb = (XMLBean)j.next();
                    cp.addCustomerParam(xb.getName(), xb.getValue());
                }
                String orgs = cp.getCustomerParam(key);
                if (orgs == null) continue;
                return this.getOrgUnitInfos(orgs, ";");
            }
        }
        return null;
    }

    private OrgUnitInfo[] getOrgUnitInfos(String ids, String delim) throws Exception {
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getKeyIdList(ids, delim), CompareType.INCLUDE));
        view.setFilter(filter);
        FullOrgUnitCollection collection = iOrgUnit.getFullOrgUnitCollection(view);
        OrgUnitInfo[] results = new OrgUnitInfo[collection.size()];
        for (int i = 0; i < collection.size(); ++i) {
            results[i] = collection.get(i);
        }
        return results;
    }

    private LinkedHashSet getKeyIdList(String ids, String delim) {
        StringTokenizer stk = new StringTokenizer(ids, delim);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        while (stk.hasMoreTokens()) {
            result.add(String.valueOf(stk.nextToken()).trim());
        }
        return result;
    }

    public FilterInfo changeQueryContext(Map uiContext) {
        OrgUnitCollection orgCol;
        String filterItem;
        FilterInfo filter = new FilterInfo();
        if (this.delegationSupport != null && this.owner != null && !StringUtils.isEmpty((String)(filterItem = this.delegationSupport.getPropertyOfBizOrg(this.owner.getMainOrgType()))) && uiContext != null && uiContext.get("multi_org_context") != null && (orgCol = (OrgUnitCollection)uiContext.get("multi_org_context")) != null && orgCol.size() > 0) {
            HashSet<String> orgIds = new HashSet<String>();
            int size = orgCol.size();
            for (int i = 0; i < size; ++i) {
                orgIds.add(orgCol.get(i).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo(filterItem, orgIds, CompareType.INCLUDE));
        }
        return filter;
    }

    public FilterInfo buildDefaultFilter() {
        return null;
    }
}

