/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.exportexcel;

import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigParam;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ExportExcelConfigManager {
    private static Logger logger = Logger.getLogger(ExportExcelConfigManager.class);
    private static final String DEFAULT_CONFIGFILE_NAME = "exportExcelConfig.xml";
    public static final String CLIENT_ROOT = System.getProperty("easclient.root").trim();

    public static final ExportExcelConfigParam loadExportExcelConfig() {
        return ExportExcelConfigManager.loadExportExcelConfig(DEFAULT_CONFIGFILE_NAME, false);
    }

    public static final ExportExcelConfigParam loadExportExcelConfig(String fileName, boolean isFullPath) {
        XMLConfiguration config;
        File configFile;
        ExportExcelConfigParam param = null;
        String filePath = fileName;
        if (!isFullPath) {
            filePath = ExportExcelConfigManager.constructFilePath(fileName);
        }
        if (!(configFile = new File(filePath)).exists()) {
            ExportExcelConfigManager.CreateDefaultConfiguration(configFile);
        }
        if (!(param = new ExportExcelConfigParam(config = XMLConfiguration.getInstance((File)configFile))).isNewConfigFile()) {
            ExportExcelConfigManager.CreateDefaultConfiguration(configFile);
            config = XMLConfiguration.getInstance((File)configFile);
            param = new ExportExcelConfigParam(config);
        }
        return param;
    }

    public static final void saveExportExcelConfig(ExportExcelConfigParam param) {
        ExportExcelConfigManager.saveExportExcelConfig(DEFAULT_CONFIGFILE_NAME, false, param);
    }

    public static final void saveExportExcelConfig(String fileName, boolean isFullPath, ExportExcelConfigParam param) {
        String filePath = fileName;
        if (!isFullPath) {
            filePath = ExportExcelConfigManager.constructFilePath(fileName);
        }
        File configFile = new File(filePath);
        XMLConfiguration config = null;
        if (!configFile.exists()) {
            config = ExportExcelConfigManager.CreateDefaultConfiguration(configFile);
        }
        config = XMLConfiguration.getInstance((File)configFile);
        ExportExcelConfigManager.SaveConfiguration(config, param);
    }

    private static String constructFilePath(String fileName) {
        StringBuffer buffer = new StringBuffer(CLIENT_ROOT);
        buffer.append(File.separator);
        buffer.append(fileName);
        return buffer.toString();
    }

    private static XMLConfiguration CreateDefaultConfiguration(File file) {
        if (file.exists()) {
            file.delete();
        }
        ExportExcelConfigManager.createConfigFile(file);
        XMLConfiguration config = XMLConfiguration.getInstance((File)file);
        ConfigurationItem configItem = config.getConfigItem("exportParam");
        if (configItem == null) {
            configItem = new ConfigurationItem("exportParam");
            config.addConfigItem(configItem);
        }
        configItem.setProperty("configVersion", "1.0");
        ExportExcelConfigParam param = ExportExcelConfigParam.getDefaultExportExcelConfigParam();
        ExportExcelConfigManager.updateXMLConfigurationItems(param, config);
        return config;
    }

    public static void updateXMLConfigurationItems(ExportExcelConfigParam param, XMLConfiguration XMLConfig) {
        if (XMLConfig != null && param != null) {
            ConfigurationItem configItem = XMLConfig.getConfigItem("exportParam");
            if (configItem == null) {
                configItem = new ConfigurationItem("exportParam");
                XMLConfig.addConfigItem(configItem);
            }
            configItem.setProperty("excelVersion", String.valueOf(param.getExcelVersion()));
            configItem.setProperty("isExportMergeBlocks", String.valueOf(param.isExportMergeBlocks()));
            configItem.setProperty("isMergeHeadRowsExport", String.valueOf(param.isMergeHeadRowsExport()));
            configItem.setProperty("isDesensitizationExport", String.valueOf(param.isDesensitizationExport()));
            configItem.setProperty("isExportSelect", String.valueOf(param.isExportSelect()));
            configItem.setProperty("isOpenFile", String.valueOf(param.isOpenFile()));
            configItem.setProperty("savePath", param.getSavePath());
            configItem.setProperty("2003MaxRowsValue", String.valueOf(ExportExcelConfigParam.EXCEL2003_MAXROWS_VALUE));
            XMLConfig.store(true);
        }
    }

    private static void SaveConfiguration(XMLConfiguration config, ExportExcelConfigParam param) {
        if (param != null) {
            ExportExcelConfigManager.updateXMLConfigurationItems(param, config);
            config.store(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createConfigFile(File file) {
        OutputStreamWriter writer = null;
        try {
            Element element = new Element("config");
            Document document = new Document(element);
            Format format = Format.getRawFormat();
            format.setEncoding("UTF-8");
            XMLOutputter XMLOut = new XMLOutputter(format);
            writer = new FileWriter(file);
            XMLOut.output(document, (Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

