/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.modalwin;

import com.kingdee.eas.framework.client.modalwin.JModalConfiguration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class ModalWindowUtils {
    public static final int DEFAULT_SCREEN_SAFETY_MARGIN = 100;
    public static final int DEFAULT_DESKTOP_SAFETY_MARGIN = 2;
    private static final HashMap IMAGE_CACHE = new HashMap();
    private static ModalWindowUtils instance;
    private static final int STOP_SIGN_SIZE = 32;
    private static final int[] POLYGON_SIGN_X;
    private static final int[] POLYGON_SIGN_Y;
    private static final int[] POLYGON_SIGN_BORDER_X;
    private static final int[] POLYGON_SIGN_BORDER_Y;
    private static final int[] POLYGON_SIGN_S_X;
    private static final int[] POLYGON_SIGN_S_Y;
    private static final int[] POLYGON_SIGN_T_X;
    private static final int[] POLYGON_SIGN_T_Y;
    private static final int[] POLYGON_SIGN_O_X;
    private static final int[] POLYGON_SIGN_O_Y;
    private static final int[] POLYGON_SIGN_P_X;
    private static final int[] POLYGON_SIGN_P_Y;
    private static final int[] POLYGON_BORDER_S_X;
    private static final int[] POLYGON_BORDER_S_Y;
    private static final int[] POLYGON_BORDER_T_X;
    private static final int[] POLYGON_BORDER_T_Y;
    private static final int[] POLYGON_BORDER_O_X;
    private static final int[] POLYGON_BORDER_O_Y;
    private static final int[] POLYGON_INNERBORDER_O_X;
    private static final int[] POLYGON_INNERBORDER_O_Y;
    private static final int[] POLYGON_OUTERBORDER_P_X;
    private static final int[] POLYGON_OUTERBORDER_P_Y;
    private static final int[] POLYGON_INNERBORDER_P_X;
    private static final int[] POLYGON_INNERBORDER_P_Y;
    private static final int MISSING_IMAGE_SIGN_SIZE = 16;
    private static final int CROSS_TOP_LEFT_X = 2;
    private static final int CROSS_TOP_LEFT_Y = 2;
    private static final int CROSS_BOTTOM_RIGHT_X = 13;
    private static final int CROSS_BOTTOM_RIGHT_Y = 13;
    private static final int CROSS_TOP_RIGHT_X = 13;
    private static final int CROSS_TOP_RIGHT_Y = 2;
    private static final int CROSS_BOTTOM_LEFT_X = 2;
    private static final int CROSS_BOTTOM_LEFT_Y = 13;
    private static final Color DARK_RED;
    private static final Color MEDIUM_RED;
    private static final Color LIGHT_RED;
    private static final Color WHITE;

    private ModalWindowUtils() {
    }

    public static ModalWindowUtils getInstance() {
        if (instance == null) {
            instance = new ModalWindowUtils();
        }
        return instance;
    }

    public static Window windowForComponent(Component cmp) {
        JDesktopPane desktop;
        Component parent;
        JDesktopPane desktop2;
        Window window = SwingUtilities.windowForComponent(cmp);
        if (window == null && cmp instanceof JInternalFrame && (desktop2 = ((JInternalFrame)cmp).getDesktopPane()) != null) {
            window = SwingUtilities.windowForComponent(desktop2);
        }
        if (window == null && (parent = ModalWindowUtils.parentForComponentRootPane(cmp)) instanceof JInternalFrame && (desktop = ((JInternalFrame)parent).getDesktopPane()) != null) {
            window = SwingUtilities.windowForComponent(desktop);
        }
        return window;
    }

    public static Component parentForComponentRootPane(Component cmp) {
        JRootPane rootPane = SwingUtilities.getRootPane(cmp);
        if (rootPane == null) {
            return null;
        }
        return rootPane.getParent();
    }

    public static void updateComponentTreeUI(Component cmp) {
        ModalWindowUtils.updateComponentTreeUI0(cmp);
        cmp.invalidate();
        cmp.validate();
        cmp.repaint();
    }

    private static void updateComponentTreeUI0(Component cmp) {
        Component[] children = null;
        if (cmp instanceof JMenu) {
            children = ((JMenu)cmp).getMenuComponents();
        } else if (cmp instanceof Container) {
            children = ((Container)cmp).getComponents();
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                ModalWindowUtils.updateComponentTreeUI0(children[i]);
            }
        }
        if (cmp instanceof JComponent) {
            ((JComponent)cmp).updateUI();
        }
    }

    public static Cursor getBusyCursor() {
        String optionalCursorIcon = UIManager.getString("swingx.busy.cursor");
        Image cursor = optionalCursorIcon == null ? ModalWindowUtils.getStopImage() : ModalWindowUtils.getIcon(optionalCursorIcon).getImage();
        Cursor busyCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursor, new Point(0, 0), "BUSY");
        if (busyCursor.getType() != -1) {
            busyCursor = Cursor.getPredefinedCursor(1);
        }
        return busyCursor;
    }

    public static Image getMissingImage() {
        int size = 16;
        BufferedImage rv = new BufferedImage(size, size, 2);
        Graphics gfx = ((Image)rv).getGraphics();
        gfx.setColor(Color.red);
        gfx.fillRect(0, 0, size, size);
        gfx.setColor(Color.white);
        gfx.drawLine(2, 2, 13, 13);
        gfx.drawLine(3, 2, 13, 12);
        gfx.drawLine(2, 3, 12, 13);
        gfx.drawLine(2, 13, 13, 2);
        gfx.drawLine(2, 12, 12, 2);
        gfx.drawLine(3, 13, 13, 3);
        return rv;
    }

    public static Image getStopImage() {
        int size = 32;
        BufferedImage img = new BufferedImage(size, size, 2);
        Graphics gfx = ((Image)img).getGraphics();
        gfx.setColor(DARK_RED);
        gfx.fillPolygon(POLYGON_SIGN_X, POLYGON_SIGN_Y, POLYGON_SIGN_X.length);
        gfx.setColor(LIGHT_RED);
        gfx.drawPolygon(POLYGON_SIGN_X, POLYGON_SIGN_Y, POLYGON_SIGN_X.length);
        gfx.setColor(WHITE);
        gfx.drawPolygon(POLYGON_SIGN_BORDER_X, POLYGON_SIGN_BORDER_Y, POLYGON_SIGN_BORDER_X.length);
        gfx.drawPolyline(POLYGON_SIGN_S_X, POLYGON_SIGN_S_Y, POLYGON_SIGN_S_X.length);
        gfx.drawPolyline(POLYGON_SIGN_T_X, POLYGON_SIGN_T_Y, POLYGON_SIGN_T_X.length);
        gfx.drawPolyline(POLYGON_SIGN_O_X, POLYGON_SIGN_O_Y, POLYGON_SIGN_O_X.length);
        gfx.drawPolyline(POLYGON_SIGN_P_X, POLYGON_SIGN_P_Y, POLYGON_SIGN_P_X.length);
        gfx.setColor(MEDIUM_RED);
        gfx.drawPolyline(POLYGON_BORDER_S_X, POLYGON_BORDER_S_Y, POLYGON_BORDER_S_X.length);
        gfx.drawPolyline(POLYGON_BORDER_T_X, POLYGON_BORDER_T_Y, POLYGON_BORDER_T_X.length);
        gfx.drawPolyline(POLYGON_BORDER_O_X, POLYGON_BORDER_O_Y, POLYGON_BORDER_O_X.length);
        gfx.drawPolyline(POLYGON_INNERBORDER_O_X, POLYGON_INNERBORDER_O_Y, POLYGON_INNERBORDER_O_X.length);
        gfx.drawPolyline(POLYGON_OUTERBORDER_P_X, POLYGON_OUTERBORDER_P_Y, POLYGON_OUTERBORDER_P_X.length);
        gfx.drawPolyline(POLYGON_INNERBORDER_P_X, POLYGON_INNERBORDER_P_Y, POLYGON_INNERBORDER_P_X.length);
        return img;
    }

    public static ImageIcon getIcon(String name) {
        return ModalWindowUtils.getIcon(name, new ImageIcon(ModalWindowUtils.getMissingImage()));
    }

    public static ImageIcon getIcon(String name, ImageIcon defaultIcon) {
        try {
            ImageIcon icon = (ImageIcon)IMAGE_CACHE.get(name);
            if (icon != null) {
                return icon;
            }
            URL url = ModalWindowUtils.getInstance().getClass().getClassLoader().getResource(name);
            if (url == null) {
                return defaultIcon;
            }
            icon = new ImageIcon(url);
            IMAGE_CACHE.put(name, icon);
            return icon;
        }
        catch (NullPointerException npe) {
            System.out.println("Error retrieving icon:" + name);
            return defaultIcon;
        }
    }

    public static void centerOfScreen(Window win) {
        Rectangle screenBounds = win.getGraphicsConfiguration().getBounds();
        win.setLocation((int)(screenBounds.getX() + screenBounds.getWidth() / 2.0 - (double)(win.getWidth() / 2)), (int)(screenBounds.getY() + screenBounds.getHeight() / 2.0 - (double)(win.getHeight() / 2)));
    }

    public static void centerOfOwner(Window win, Window owner) {
        double x = 0.0;
        double y = 0.0;
        if (owner != null) {
            Dimension winSize = win.getSize();
            Dimension ownerSize = owner.getSize();
            x = (ownerSize.getWidth() - winSize.getWidth()) / 2.0;
            y = (ownerSize.getHeight() - winSize.getHeight()) / 2.0;
            Point p = owner.getLocation();
            x += p.getX();
            y += p.getY();
        }
        ModalWindowUtils.keepWindowCompletelyOnScreen(win, (int)x, (int)y);
    }

    public static void relativeToOwnerChild(Window win, Window owner, Component child) {
        double x = 0.0;
        double y = 0.0;
        if (owner != null && child != null) {
            Point p = child.getLocation();
            Dimension childSize = child.getSize();
            x = p.getX();
            y = p.getY() + childSize.getHeight();
            for (Container parent = child.getParent(); parent != null && parent != owner; parent = parent.getParent()) {
                p = parent.getLocation();
                x += p.getX();
                y += p.getY();
            }
            p = owner.getLocation();
            x += p.getX();
            y += p.getY();
        }
        ModalWindowUtils.keepWindowCompletelyOnScreen(win, (int)x, (int)y);
    }

    public static void keepWindowPartiallyOnScreen(Window win, int x, int y) {
        int windowDragScreenSafetyMargin = JModalConfiguration.getWindowDragScreenSafetyMargin();
        Rectangle screenBounds = win.getGraphicsConfiguration().getBounds();
        Dimension winSize = win.getSize();
        if ((double)(x + windowDragScreenSafetyMargin) > screenBounds.getX() + screenBounds.getWidth()) {
            x = (int)(screenBounds.getX() + screenBounds.getWidth() - (double)windowDragScreenSafetyMargin);
        }
        if ((double)x + winSize.getWidth() - (double)windowDragScreenSafetyMargin < screenBounds.getX()) {
            x = (int)(screenBounds.getX() + (double)windowDragScreenSafetyMargin - winSize.getWidth());
        }
        if ((double)(y + windowDragScreenSafetyMargin) > screenBounds.getY() + screenBounds.getHeight()) {
            y = (int)(screenBounds.getY() + screenBounds.getHeight() - (double)windowDragScreenSafetyMargin);
        }
        if ((double)y + winSize.getHeight() - (double)windowDragScreenSafetyMargin < screenBounds.getY()) {
            y = (int)(screenBounds.getY() + (double)windowDragScreenSafetyMargin - winSize.getHeight());
        }
        win.setLocation(x, y);
    }

    public static void keepWindowCompletelyOnScreen(Window win, int x, int y) {
        Rectangle screenBounds = win.getGraphicsConfiguration().getBounds();
        Dimension winSize = win.getSize();
        if ((double)x + winSize.getWidth() > screenBounds.getX() + screenBounds.getWidth()) {
            x = (int)(screenBounds.getX() + screenBounds.getWidth() - winSize.getWidth());
        }
        if ((double)x < screenBounds.getX()) {
            x = (int)screenBounds.getX();
        }
        if ((double)y + winSize.getHeight() > screenBounds.getY() + screenBounds.getHeight()) {
            y = (int)(screenBounds.getY() + screenBounds.getHeight() - winSize.getHeight());
        }
        if ((double)y < screenBounds.getY()) {
            y = (int)screenBounds.getY();
        }
        win.setLocation(x, y);
    }

    public static void centerOfDesktop(JInternalFrame iframe, JDesktopPane desktop) {
        double x = 0.0;
        double y = 0.0;
        if (desktop != null) {
            Rectangle desktopBounds = desktop.getBounds();
            iframe.setLocation((int)(desktopBounds.getX() + desktopBounds.getWidth() / 2.0 - (double)(iframe.getWidth() / 2)), (int)(desktopBounds.getY() + desktopBounds.getHeight() / 2.0 - (double)(iframe.getHeight() / 2)));
            Point p = iframe.getLocation();
            x = p.getX();
            y = p.getY();
        }
        ModalWindowUtils.keepIFrameCompletelyOnDesktop(iframe, desktop, (int)x, (int)y);
    }

    public static void centerOfOwner(JInternalFrame iframe, JDesktopPane desktop, JInternalFrame owner) {
        double x = 0.0;
        double y = 0.0;
        if (owner != null) {
            Dimension winSize = iframe.getSize();
            Dimension ownerSize = owner.getSize();
            x = (ownerSize.getWidth() - winSize.getWidth()) / 2.0;
            y = (ownerSize.getHeight() - winSize.getHeight()) / 2.0;
            Point p = owner.getLocation();
            x += p.getX();
            y += p.getY();
        }
        ModalWindowUtils.keepIFrameCompletelyOnDesktop(iframe, desktop, (int)x, (int)y);
    }

    public static void relativeToOwnerChild(JInternalFrame iframe, JDesktopPane desktop, JInternalFrame owner, Component child) {
        double x = 0.0;
        double y = 0.0;
        if (owner != null && child != null) {
            Point p = child.getLocation();
            Dimension childSize = child.getSize();
            x = p.getX();
            y = p.getY() + childSize.getHeight();
            for (Container parent = child.getParent(); parent != null && parent != owner; parent = parent.getParent()) {
                p = parent.getLocation();
                x += p.getX();
                y += p.getY();
            }
            p = owner.getLocation();
            x += p.getX();
            y += p.getY();
        }
        ModalWindowUtils.keepIFrameCompletelyOnDesktop(iframe, desktop, (int)x, (int)y);
    }

    public static void keepIFramePartiallyOnDesktop(JInternalFrame iframe, BasicInternalFrameTitlePane titlePane, JDesktopPane desktop, int x, int y) {
        int iframeDragDesktopSafetyMargin = 2;
        Insets iframeDragDesktopSafetyMarginInsets = iframe.getInsets();
        if (titlePane != null) {
            iframeDragDesktopSafetyMargin = titlePane.getHeight();
        }
        Rectangle desktopBounds = new Rectangle(0, 0, 0, 0);
        if (desktop != null) {
            desktopBounds = desktop.getBounds();
        }
        Dimension winSize = iframe.getSize();
        if ((double)(x + iframeDragDesktopSafetyMarginInsets.left + iframeDragDesktopSafetyMargin) > desktopBounds.getX() + desktopBounds.getWidth()) {
            x = (int)(desktopBounds.getX() + desktopBounds.getWidth() - (double)iframeDragDesktopSafetyMarginInsets.left - (double)iframeDragDesktopSafetyMargin);
        }
        if ((double)x + winSize.getWidth() - (double)iframeDragDesktopSafetyMarginInsets.right - (double)iframeDragDesktopSafetyMargin < desktopBounds.getX()) {
            x = (int)(desktopBounds.getX() + (double)iframeDragDesktopSafetyMarginInsets.right + (double)iframeDragDesktopSafetyMargin - winSize.getWidth());
        }
        if ((double)(y + iframeDragDesktopSafetyMarginInsets.top + iframeDragDesktopSafetyMargin) > desktopBounds.getY() + desktopBounds.getHeight()) {
            y = (int)(desktopBounds.getY() + desktopBounds.getHeight() - (double)iframeDragDesktopSafetyMarginInsets.top - (double)iframeDragDesktopSafetyMargin);
        }
        if ((double)y < desktopBounds.getY()) {
            y = 0;
        }
        iframe.setLocation(x, y);
    }

    public static void keepIFrameCompletelyOnDesktop(JInternalFrame iframe, JDesktopPane desktop, int x, int y) {
        Dimension winSize;
        Rectangle desktopBounds = new Rectangle(0, 0, 0, 0);
        if (desktop != null) {
            desktopBounds = desktop.getBounds();
        }
        if ((double)x + (winSize = iframe.getSize()).getWidth() > desktopBounds.getX() + desktopBounds.getWidth()) {
            x = (int)(desktopBounds.getX() + desktopBounds.getWidth() - winSize.getWidth());
        }
        if ((double)x < desktopBounds.getX()) {
            x = (int)desktopBounds.getX();
        }
        if ((double)y + winSize.getHeight() > desktopBounds.getY() + desktopBounds.getHeight()) {
            y = (int)(desktopBounds.getY() + desktopBounds.getHeight() - winSize.getHeight());
        }
        if ((double)y < desktopBounds.getY()) {
            y = (int)desktopBounds.getY();
        }
        iframe.setLocation(x, y);
    }

    static {
        POLYGON_SIGN_X = new int[]{8, 23, 31, 31, 23, 8, 0, 0};
        POLYGON_SIGN_Y = new int[]{0, 0, 8, 23, 31, 31, 23, 8};
        POLYGON_SIGN_BORDER_X = new int[]{8, 23, 30, 30, 23, 8, 1, 1};
        POLYGON_SIGN_BORDER_Y = new int[]{1, 1, 8, 23, 30, 30, 23, 8};
        POLYGON_SIGN_S_X = new int[]{4, 5, 7, 8, 8, 4, 4, 5, 7, 8};
        POLYGON_SIGN_S_Y = new int[]{21, 22, 22, 21, 17, 13, 9, 8, 8, 9};
        POLYGON_SIGN_T_X = new int[]{10, 14, 12, 12};
        POLYGON_SIGN_T_Y = new int[]{8, 8, 8, 22};
        POLYGON_SIGN_O_X = new int[]{16, 17, 19, 20, 20, 19, 17, 16, 16};
        POLYGON_SIGN_O_Y = new int[]{9, 8, 8, 9, 21, 22, 22, 21, 9};
        POLYGON_SIGN_P_X = new int[]{22, 22, 25, 26, 26, 25, 22};
        POLYGON_SIGN_P_Y = new int[]{22, 8, 8, 9, 14, 15, 15};
        POLYGON_BORDER_S_X = new int[]{3, 5, 7, 9, 9, 5, 5, 7, 8, 9, 7, 5, 3, 3, 7, 7, 5, 4, 3};
        POLYGON_BORDER_S_Y = new int[]{21, 23, 23, 21, 17, 13, 9, 9, 10, 9, 7, 7, 9, 13, 17, 21, 21, 20, 21};
        POLYGON_BORDER_T_X = new int[]{9, 15, 15, 13, 13, 11, 11, 9, 9};
        POLYGON_BORDER_T_Y = new int[]{7, 7, 9, 9, 23, 23, 9, 9, 7};
        POLYGON_BORDER_O_X = new int[]{15, 17, 19, 21, 21, 19, 17, 15, 15};
        POLYGON_BORDER_O_Y = new int[]{9, 7, 7, 9, 21, 23, 23, 21, 9};
        POLYGON_INNERBORDER_O_X = new int[]{17, 19, 19, 17, 17};
        POLYGON_INNERBORDER_O_Y = new int[]{9, 9, 21, 21, 9};
        POLYGON_OUTERBORDER_P_X = new int[]{21, 21, 25, 27, 27, 25, 23, 23, 21};
        POLYGON_OUTERBORDER_P_Y = new int[]{23, 7, 7, 9, 14, 16, 16, 23, 23};
        POLYGON_INNERBORDER_P_X = new int[]{23, 25, 25, 23, 23};
        POLYGON_INNERBORDER_P_Y = new int[]{9, 9, 14, 14, 9};
        DARK_RED = new Color(173, 57, 57);
        MEDIUM_RED = new Color(198, 115, 115);
        LIGHT_RED = new Color(214, 156, 156);
        WHITE = Color.white;
    }
}

