/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.multiDetail;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.client.multiDetail.AbstractBillMultiDetailUI;
import com.kingdee.eas.framework.client.multiDetail.IBillMultiDetail;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public abstract class BillMultiDetailUI
extends AbstractBillMultiDetailUI
implements IBillMultiDetail {
    protected abstract IObjectValue createNewDetailData(KDTable var1);

    public BillMultiDetailUI() throws Exception {
        this.init();
        this.initListener();
        this.initUIContentLayout();
        this.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.controlPanel.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddnewLine.setText(null);
        this.btnAddnewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLines.setText(null);
        this.btnRemoveLines.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    public void initUIContentLayout() {
        this.setBounds(new Rectangle(0, 0, 300, 300));
        this.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.setLayout(null);
        this.controlPanel.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.controlPanel.setLayout((LayoutManager)new BorderLayout());
        this.controlPanel.add((Component)new JLabel(""), (Object)"West");
        this.btnAddnewLine.setText("addnew");
        this.controlPanel.add((Component)this.btnAddnewLine, (Object)"East");
        this.controlPanel.add((Component)this.btnInsertLine, (Object)"East");
        this.controlPanel.add((Component)this.btnRemoveLines, (Object)"East");
        this.entryPanel.setLayout(null);
        this.entryPanel.add((Component)this.entryTable, null);
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.entryPanel, "Center");
    }

    void init() {
        this.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.entryPanel.setBorder(null);
        this.controlPanel.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.entryPanel, "South");
    }

    @Override
    public KDPanel getContainer() {
        return this;
    }

    @Override
    public KDTable getDetailTable() {
        return this.entryTable;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.enableExportExcel(this.entryTable);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
    }

    protected void afterInsertLine(KDTable table, IObjectValue lineData) {
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
    }

    @Override
    public void actionAddnewLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(this.getDetailTable());
        this.updateDetailButton();
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.insertLine(this.getDetailTable());
        this.updateDetailButton();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.getDetailTable());
        this.updateDetailButton();
    }

    protected void addLine(KDTable table) {
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = table.addRow();
        row.setUserObject((Object)detailData);
        this.loadLineFields(table, row, detailData);
        this.afterAddLine(table, detailData);
    }

    protected void insertLine(KDTable table) {
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.loadLineFields(table, row, detailData);
        this.afterInsertLine(table, detailData);
    }

    protected void removeLine(KDTable table) {
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = table.getSelectManager().get().getTop();
        if (table.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        IObjectValue detailData = (IObjectValue)table.getRow(top).getUserObject();
        table.removeRow(top);
        this.afterRemoveLine(table, detailData);
        this.updateDetailButton();
    }

    @Override
    public void loadDetail(BillBaseInfo billBaseInfo) {
        try {
            this.setDataObject((IObjectValue)billBaseInfo);
            this.onLoad();
            this.loadFields();
            this.entryTable.updateUI();
        }
        catch (Exception ex) {
            this.handUIException(ex);
            this.abort();
        }
    }

    @Override
    public void onDetailChanged(IBillMultiDetail oldDetail, IBillMultiDetail currentDetail) {
    }

    protected void updateDetailButton() {
        if (this.entryTable.getRowCount() > 0) {
            this.actionAddnewLine.setEnabled(true);
            this.ActionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        }
        if (this.entryTable.getSelectManager().size() > 0) {
            this.ActionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        }
    }
}

