/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.popup;

import com.kingdee.eas.framework.client.popup.IPopupMenuSupport;
import com.kingdee.eas.framework.client.popup.MenuSection;
import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupMenuManager {
    public static final int HEAD = 0;
    public static final int END = 1;
    private JPopupMenu menu;
    private IPopupMenuSupport provider;
    private LinkedList sections = new LinkedList();
    private LinkedList oldMenu;
    private int preserveExistMenuItem = 0;
    private boolean oldMenuSaved = false;
    private EventListenerList listeners = new EventListenerList();
    private PopupMenuListener listener = new PopupMenuListener(){

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
            if (!PopupMenuManager.this.oldMenuSaved) {
                if (PopupMenuManager.this.menu.getComponentCount() > 0) {
                    PopupMenuManager.this.oldMenu = new LinkedList();
                }
                for (int i = 0; i < PopupMenuManager.this.menu.getComponentCount(); ++i) {
                    PopupMenuManager.this.oldMenu.addLast(PopupMenuManager.this.menu.getComponent(i));
                }
                PopupMenuManager.this.oldMenuSaved = true;
            }
            PopupMenuManager.this.menu.removeAll();
            for (MenuSection section : PopupMenuManager.this.sections) {
                if (section.isDynamic()) {
                    section.show();
                }
                if (section.allMenuItems().isEmpty()) continue;
                Iterator iter1 = section.allMenuItems().iterator();
                while (iter1.hasNext()) {
                    PopupMenuManager.this.menu.add((Component)iter1.next());
                }
                PopupMenuManager.this.menu.add(new JPopupMenu.Separator());
            }
            if (PopupMenuManager.this.menu.getComponentCount() > 0) {
                PopupMenuManager.this.menu.remove(PopupMenuManager.this.menu.getComponentCount() - 1);
            }
            if (PopupMenuManager.this.preserveExistMenuItem != 0 && PopupMenuManager.this.preserveExistMenuItem != 1) {
                return;
            }
            if (PopupMenuManager.this.oldMenu != null) {
                if (PopupMenuManager.this.preserveExistMenuItem == 0) {
                    if (PopupMenuManager.this.menu.getComponentCount() > 0) {
                        PopupMenuManager.this.menu.add((Component)new JPopupMenu.Separator(), 0);
                    }
                    int i = 0;
                    Iterator iter = PopupMenuManager.this.oldMenu.iterator();
                    while (iter.hasNext()) {
                        PopupMenuManager.this.menu.add((Component)iter.next(), i++);
                    }
                } else {
                    if (PopupMenuManager.this.menu.getComponentCount() > 0) {
                        PopupMenuManager.this.menu.add(new JPopupMenu.Separator());
                    }
                    Iterator iter = PopupMenuManager.this.oldMenu.iterator();
                    while (iter.hasNext()) {
                        PopupMenuManager.this.menu.add((Component)iter.next());
                    }
                }
            }
            Object[] listenerList = PopupMenuManager.this.listeners.getListenerList();
            for (int i = listenerList.length - 2; i >= 0; i -= 2) {
                if (listenerList[i] != PopupMenuListener.class) continue;
                PopupMenuListener listener = (PopupMenuListener)listenerList[i + 1];
                listener.popupMenuWillBecomeVisible(arg0);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent arg0) {
            Object[] listenerList = PopupMenuManager.this.listeners.getListenerList();
            for (int i = listenerList.length - 2; i >= 0; i -= 2) {
                if (listenerList[i] != PopupMenuListener.class) continue;
                PopupMenuListener listener = (PopupMenuListener)listenerList[i + 1];
                listener.popupMenuCanceled(arg0);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            Object[] listenerList = PopupMenuManager.this.listeners.getListenerList();
            for (int i = listenerList.length - 2; i >= 0; i -= 2) {
                if (listenerList[i] != PopupMenuListener.class) continue;
                PopupMenuListener listener = (PopupMenuListener)listenerList[i + 1];
                listener.popupMenuWillBecomeInvisible(arg0);
            }
        }
    };

    public void addPopupMenuListener(PopupMenuListener listener) {
        this.listeners.add(PopupMenuListener.class, listener);
    }

    public void removePopupMenuListener(PopupMenuListener listener) {
        this.listeners.remove(PopupMenuListener.class, listener);
    }

    public int getPreserveExistMenuItem() {
        return this.preserveExistMenuItem;
    }

    public void setPreserveExistMenuItem(int preserveExistMenuItem) {
        this.preserveExistMenuItem = preserveExistMenuItem;
    }

    private void ensureValid(MenuSection section) {
        if (section == null) {
            throw new IllegalArgumentException("section == null");
        }
        if (this.findMenuSection(section.getName()) != null) {
            throw new IllegalArgumentException("duplicate section name [" + section.getName() + "]");
        }
    }

    public void addMenuSection(MenuSection section) {
        this.ensureValid(section);
        this.sections.addLast(section);
    }

    public void insertMenuSection(MenuSection section, String position) {
        MenuSection item;
        this.ensureValid(section);
        if (position == null) {
            this.sections.addLast(section);
        }
        int i = 0;
        Iterator iter = this.sections.iterator();
        while (iter.hasNext() && !(item = (MenuSection)iter.next()).getName().equals(position)) {
            ++i;
        }
        if (i == this.sections.size()) {
            throw new IllegalArgumentException("position not exists");
        }
        this.sections.add(i, section);
    }

    public void removeMenuSection(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        Iterator iter = this.sections.iterator();
        while (iter.hasNext()) {
            MenuSection item = (MenuSection)iter.next();
            if (!item.getName().equals(name)) continue;
            iter.remove();
            break;
        }
    }

    public MenuSection findMenuSection(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        for (MenuSection section : this.sections) {
            if (!section.getName().equals(name)) continue;
            return section;
        }
        return null;
    }

    public void install(IPopupMenuSupport provider) {
        this.provider = provider;
        this.menu = provider.installPopupMenu();
        this.menu.addPopupMenuListener(this.listener);
    }

    public void uninstall() {
        this.provider.uninstallPopupMenu();
        this.menu.removeAll();
        if (this.oldMenu != null) {
            Iterator iter = this.oldMenu.iterator();
            while (iter.hasNext()) {
                this.menu.add((Component)iter.next());
            }
        }
        this.menu.removePopupMenuListener(this.listener);
    }
}

