/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.service;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.framework.util.ConfigParams;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;

public class TableLocationServer {
    private boolean isFirstLocate = true;
    private LocateParam preLocateParam;
    private String propertyName;
    private String searchText = null;
    private boolean isMatch;
    private boolean is_case_insensitive;
    private int searcheRowCount = 0;
    private int maxReturnRowCount = 10000;
    private int maxLocateRows = 200;
    private boolean is_show_confirm = true;
    private KDTable tblMain;
    private boolean stop = false;
    private boolean isJoinMatchAtMergeRow = false;

    public int locateFirstRow(LocateParam locate_param) {
        if (!this.check(locate_param)) {
            return -1;
        }
        locate_param.setFindDirection(2);
        locate_param.setIsCaseInsensitive(false);
        locate_param.setIsMmatch(false);
        this.initParams(locate_param);
        this.is_show_confirm = false;
        int curSelectIndex = 0;
        if (!locate_param.isHashQuertPK()) {
            return this.locateFirstRowForNotIdList(locate_param);
        }
        int rowcn = this.getRowCount(locate_param);
        if (rowcn == 0) {
            return -1;
        }
        int line = this.matchCurrentRow(locate_param);
        if (line >= 0) {
            return line;
        }
        ICell curCell = this.tblMain.getRow(curSelectIndex).getCell(locate_param.getColName());
        this.isJoinMatchAtMergeRow = true;
        int row_index = this.lookup(curSelectIndex, curCell, rowcn, locate_param);
        this.is_show_confirm = true;
        return row_index;
    }

    private int matchCurrentRow(LocateParam locate_param) {
        ICell cell;
        IRow row;
        int first_match_index = locate_param.getOptions().getIntParam("current_select_index", -1);
        if (first_match_index >= 0 && (row = this.tblMain.getRow(first_match_index)) != null && (cell = row.getCell(locate_param.getColName())) != null && cell.getValue() != null) {
            String text;
            Object cellValue = this.getCellValue(cell, locate_param.getSearchText());
            String string = text = cellValue == null ? null : cellValue.toString();
            if (text != null && StringUtility.isMatch(text, locate_param.getSearchText(), locate_param.isMatch(), this.getCaseInsensitiveFlag(locate_param.isIsCaseInsensitive()))) {
                return first_match_index;
            }
        }
        return -1;
    }

    private Object getCellValue(ICell cell, String searchText) {
        if (cell == null) {
            return null;
        }
        Object cellFormattedValue = cell.getFormattedValue();
        Object cellValue = cell.getValue();
        if (!(cellFormattedValue == null || (cellValue instanceof BigDecimal || cellValue instanceof Integer || cellValue instanceof Float || cellValue instanceof Double || cellValue instanceof Long || cellValue instanceof Short) && searchText.indexOf(",") <= 0)) {
            cellValue = cellFormattedValue;
        }
        return cellValue;
    }

    protected int locateFirstRowForNotIdList(LocateParam locate_param) {
        int row_index = 0;
        IRow row = this.tblMain.getRow(row_index);
        int flag = this.getCaseInsensitiveFlag(locate_param.isIsCaseInsensitive());
        while (row != null) {
            String Search;
            if (row.getCell(locate_param.getColName()).getValue() == null) {
                row = this.tblMain.getRow(++row_index);
                continue;
            }
            ICell cell = row.getCell(locate_param.getColName());
            Object cellValue = this.getCellValue(cell, locate_param.getSearchText());
            String string = Search = cellValue == null ? null : cellValue.toString();
            if (Search != null && StringUtility.isMatch(Search, locate_param.getSearchText(), locate_param.is_match, flag)) {
                return row_index;
            }
            row = this.tblMain.getRow(++row_index);
        }
        return -1;
    }

    public LocateResult locate(LocateParam locate_param) {
        ICell curCell;
        if (!this.check(locate_param)) {
            return LocateResult.nullLocateResult;
        }
        this.isJoinMatchAtMergeRow = false;
        int curSelectIndex = this.getCurSelectIndex();
        if (this.isChangeCondition(locate_param)) {
            this.searcheRowCount = 0;
            Object cellValue = this.getCellValue(this.tblMain.getRow(curSelectIndex).getCell(locate_param.getColName()), locate_param.getSearchText());
            String selectText = cellValue == null ? null : cellValue.toString();
            int flag = this.getCaseInsensitiveFlag(locate_param.isIsCaseInsensitive());
            if (this.matchData(selectText, locate_param.getSearchText(), locate_param.isMatch(), flag)) {
                ++this.searcheRowCount;
            }
        }
        this.initParams(locate_param);
        if (!locate_param.isHashQuertPK()) {
            return this.locateForNotIdList(locate_param);
        }
        int rowcn = this.getRowCount(locate_param);
        if (rowcn == 0) {
            return LocateResult.nullLocateResult;
        }
        int next_row_index = this.getNextRow(locate_param.getFindDirection());
        int find_row_index = this.lookup(next_row_index, curCell = this.tblMain.getRow(curSelectIndex).getCell(locate_param.getColName()), rowcn, locate_param);
        boolean sucess = find_row_index != -1;
        LocateResult result = new LocateResult(sucess, find_row_index, this.searcheRowCount);
        return result;
    }

    protected int getCaseInsensitiveFlag(boolean isIsCaseInsensitive) {
        int flag = isIsCaseInsensitive ? 2 : 0;
        return flag;
    }

    protected void initParams(LocateParam locate_param) {
        this.isMatch = locate_param.isMatch();
        this.preLocateParam = locate_param;
        this.searchText = locate_param.getSearchText();
        this.propertyName = locate_param.getColName();
    }

    protected int getRowCount(LocateParam locate_param) {
        int rowCount = locate_param.getRowCount();
        if (rowCount <= 0) {
            return this.tblMain.getBody().size();
        }
        int rowcn = 0;
        rowcn = rowCount > this.getMaxReturnRowCount() ? this.getMaxReturnRowCount() : rowCount;
        return rowcn;
    }

    protected int getNextRow(int direction) {
        int row_index = direction == 2 ? this.getCurrentRow() + 1 : this.getCurrentRow() - 1;
        return row_index;
    }

    protected boolean isChangeCondition(LocateParam locate_param) {
        return this.isFirstLocate || this.preLocateParam != null && locate_param.getFindDirection() != this.preLocateParam.getFindDirection() || this.searchText != null && !this.searchText.equals(locate_param.getSearchText()) || this.propertyName != null && !locate_param.getColName().equals(this.propertyName) || this.isMatch != locate_param.isMatch();
    }

    protected int getCurSelectIndex() {
        int curSelectIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (curSelectIndex < 0 && (this.tblMain.getRowCount() > 0 || this.tblMain.getRowCount3() > 0)) {
            this.tblMain.getSelectManager().select(0, 0);
            curSelectIndex = 0;
        }
        return curSelectIndex;
    }

    protected int getCurrentRow() {
        int row_index = 0;
        if (this.tblMain.getSelectManager().get() != null) {
            row_index = this.tblMain.getSelectManager().get().getBeginRow();
        }
        return row_index;
    }

    protected boolean check(LocateParam locate_param) {
        if (this.tblMain == null || locate_param.getSearchText() == null || locate_param.getSearchText().equals("") || this.tblMain.getRowCount() == 0) {
            return false;
        }
        return this.getCurSelectIndex() >= 0;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    protected int lookup(int row_index, ICell curCell, int rowcn, LocateParam locate_param) {
        String search_text = locate_param.getSearchText();
        int find_direction = locate_param.getFindDirection();
        String col_name = locate_param.getColName();
        boolean is_match = locate_param.is_match;
        boolean is_forward = find_direction == 2;
        int flag = this.getCaseInsensitiveFlag(locate_param.isIsCaseInsensitive());
        while (!this.isStop() && !(!is_forward ? row_index <= -1 : row_index >= rowcn) && this.ConfirmContinue(row_index)) {
            if (this.findAtRow(row_index, col_name, search_text, curCell, is_match, flag)) {
                return row_index;
            }
            if (is_forward) {
                ++row_index;
                continue;
            }
            --row_index;
        }
        return -1;
    }

    protected boolean findAtRow(int row_index, String col_name, String search_text, ICell curCell, boolean is_match, int flag) {
        if (this.isAllowMatch(row_index, curCell, col_name)) {
            String text;
            IRow row = this.tblMain.getRow(row_index);
            Object cellValue = this.getCellValue(row.getCell(col_name), search_text);
            String string = text = cellValue == null ? null : cellValue.toString();
            if (this.matchData(text, search_text, is_match, flag)) {
                ++this.searcheRowCount;
                return true;
            }
        }
        return false;
    }

    protected boolean isAllowMatch(int row_index, ICell curCell, String col_name) {
        IRow row = this.tblMain.getRow(row_index);
        if (row == null || row.getCell(col_name) == null || row.getCell(col_name).getValue() == null) {
            return false;
        }
        if (this.isJoinMatchAtMergeRow) {
            return true;
        }
        ICell cell = row.getCell(col_name);
        return curCell.getMergeBlock() == null || cell.getMergeBlock() == null || !curCell.getMergeBlock().equals((Object)cell.getMergeBlock());
    }

    public void setFirstLocate(boolean isFirstLocate) {
        this.isFirstLocate = isFirstLocate;
    }

    protected boolean matchData(String cell_text, String search_text, boolean is_match, int flag) {
        boolean result = false;
        if (cell_text != null && StringUtility.isMatch(cell_text, search_text, is_match, flag)) {
            result = true;
        }
        return result;
    }

    private int getNextRowIndex(int cur_index, int direction) {
        int idx = direction == 2 ? cur_index + 1 : cur_index - 1;
        return idx;
    }

    private LocateResult locateForNotIdList(LocateParam locate_param) {
        int row_index = 0;
        row_index = this.getNextRow(locate_param.getFindDirection());
        IRow row = this.tblMain.getRow(row_index);
        int flag = this.getCaseInsensitiveFlag(locate_param.isIsCaseInsensitive());
        while (row != null) {
            String Search;
            if (row.getCell(locate_param.getColName()).getValue() == null) {
                row_index = this.getNextRowIndex(row_index, locate_param.getFindDirection());
                row = this.tblMain.getRow(row_index);
                continue;
            }
            int curSelectIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            if (curSelectIndex == row_index) {
                row_index = this.getNextRowIndex(row_index, locate_param.getFindDirection());
                row = this.tblMain.getRow(row_index);
                continue;
            }
            ICell cell = row.getCell(locate_param.getColName());
            Object cellValue = cell == null ? null : cell.getValue();
            String string = Search = cellValue == null ? null : cellValue.toString();
            if (Search != null && StringUtility.isMatch(Search, locate_param.getSearchText(), locate_param.is_match, flag)) {
                ++this.searcheRowCount;
                boolean sucess = row_index != -1;
                LocateResult result = new LocateResult(sucess, row_index, this.searcheRowCount);
                return result;
            }
            row_index = locate_param.getFindDirection() == 2 ? ++row_index : --row_index;
            row = this.tblMain.getRow(row_index);
        }
        return new LocateResult(false, -1, this.searcheRowCount);
    }

    public int getMaxReturnRowCount() {
        return this.maxReturnRowCount;
    }

    public int getMaxLocateRows() {
        return this.maxLocateRows;
    }

    protected boolean ConfirmContinue(int row_index) {
        int result;
        int current_row;
        return !this.is_show_confirm || !this.isFirstLocate || Math.abs(row_index - (current_row = this.getCurrentRow())) != this.getMaxLocateRows() || 1 != (result = MsgBox.showConfirm2New(null, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ConfirmLocate")));
    }

    public KDTable getTblMain() {
        return this.tblMain;
    }

    public void setTblMain(KDTable tblMain) {
        this.tblMain = tblMain;
    }

    public static class LocateResult {
        private boolean is_locate_sucess;
        private int locate_row;
        private int locate_row_count;
        public static LocateResult nullLocateResult = new LocateResult(false, 0, 0);

        public LocateResult(boolean locate_sucess, int locate_row, int locate_row_count) {
            this.is_locate_sucess = locate_sucess;
            this.locate_row = locate_row;
            this.locate_row_count = locate_row_count;
        }

        public boolean isLocateSuccess() {
            return this.is_locate_sucess;
        }

        public int getLocateRow() {
            return this.locate_row;
        }

        public int getLocateRowCount() {
            return this.locate_row_count;
        }
    }

    public static class LocateParam {
        private String search_text;
        private boolean is_match;
        private boolean is_case_insensitive;
        private boolean has_qyery_pk;
        private int find_direction;
        private int start_row_index;
        private int row_count;
        private String col_name;
        public static final String IS_MATCH = "is_match";
        public static final String IS_CASE_INSENSITIVE = "is_case_insensitive";
        public static final String FIND_DIRECTION = "find_direction";
        public static final String START_ROW_INDEX = "start_row_index";
        public static final String HAS_QUERYPK = "has_query_pk";
        public static final String COL_NAME = "col_name";
        public static final String ROW_COUNT = "row_count";
        public static final String CURRENT_SELECT_ROW_INDEX = "current_select_index";
        public static final int UP_Find = 1;
        public static final int Down_Find = 2;
        private ConfigParams options;

        public LocateParam(String search_text, String col_name, ConfigParams options) {
            this.search_text = search_text;
            this.col_name = col_name;
            this.options = options != null ? options : new ConfigParams();
            this.initParams();
        }

        private void initParams() {
            this.is_match = this.options.getBooleanParam(IS_MATCH, true);
            this.is_case_insensitive = this.options.getBooleanParam(IS_CASE_INSENSITIVE, true);
            this.find_direction = this.options.getIntParam(FIND_DIRECTION, 2);
            this.start_row_index = this.options.getIntParam(START_ROW_INDEX, 0);
            this.has_qyery_pk = this.options.getBooleanParam(HAS_QUERYPK, true);
            this.row_count = this.options.getIntParam(ROW_COUNT, 0);
        }

        public ConfigParams getOptions() {
            return this.options;
        }

        public boolean isMatch() {
            return this.is_match;
        }

        public void setIsMmatch(boolean is_match) {
            this.is_match = is_match;
        }

        public boolean isIsCaseInsensitive() {
            return this.is_case_insensitive;
        }

        public void setIsCaseInsensitive(boolean is_case_insensitive) {
            this.is_case_insensitive = is_case_insensitive;
        }

        public int getStartRowIndex() {
            return this.start_row_index;
        }

        public int getFindDirection() {
            return this.find_direction;
        }

        public void setFindDirection(int find_direction) {
            this.find_direction = find_direction;
        }

        public String getSearchText() {
            return this.search_text;
        }

        public String getColName() {
            return this.col_name;
        }

        public int getRowCount() {
            return this.row_count;
        }

        public void setHasQyeryPK(boolean hasQyeryPK) {
            this.has_qyery_pk = hasQyeryPK;
        }

        public boolean isHashQuertPK() {
            return this.has_qyery_pk;
        }

        public void setSearchText(String search_text) {
            this.search_text = search_text;
        }

        public void setColName(String col_name) {
            this.col_name = col_name;
        }
    }
}

