/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.sidebar;

import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.eas.framework.client.sidebar.ISideBarBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public abstract class SideBarBase
implements ISideBarBase {
    private Logger logger = Logger.getLogger(SideBarBase.class);
    private Object userObject = null;
    private Component owner = null;
    private JComponent renderComponent = null;
    private SideBarBaseDelegate delegate = null;
    private KDTabbedPane tabPane = null;
    private long delay = 0L;
    private boolean isVisible = false;
    private JDialog dialog = null;
    private JPanel selfPane = null;
    private String easlocal = null;
    private String easDCNumber = null;
    private String currentBillID = null;
    private String currentUserName = null;
    Window ownerWindow = null;

    public SideBarBase(Component parent) {
        this.owner = parent;
        this.renderComponent = this.getSideBarPane();
        this.ownerWindow = SwingUtilities.getWindowAncestor(this.getOwner());
        this.delegate = new SideBarBaseDelegate(){
            private static final long serialVersionUID = 2511411438150888542L;

            @Override
            public void addMouseListener(MouseListener l) {
                SideBarBase.this.selfPane.addMouseListener(l);
            }

            @Override
            public void removeMouseListener(MouseListener l) {
                SideBarBase.this.selfPane.removeMouseListener(l);
            }
        };
        this.tabPane = this.getCurTabbedPane(parent);
        if (this.tabPane != null) {
            ChangeListener cl = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                }
            };
            this.tabPane.addChangeListener(cl);
        }
    }

    public KDTabbedPane getCurTabbedPane(Component component) {
        Component child = component;
        for (Container parent = child.getParent(); parent != null; parent = parent.getParent()) {
            child = parent;
        }
        if (child instanceof KDTabbedPane) {
            return (KDTabbedPane)child;
        }
        return null;
    }

    @Override
    public void addActinoListener(ActionListener l) {
        this.delegate.addActionListener(l);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.delegate.addMouseListener(l);
    }

    @Override
    public JComponent getComponent() {
        return this.renderComponent;
    }

    public Component getOwner() {
        return this.owner;
    }

    @Override
    public JPanel getSideBarPane() {
        if (this.selfPane == null) {
            this.selfPane = new JPanel();
            this.selfPane.setPreferredSize(this.getPreferredSize());
            this.selfPane.setBackground(this.getSideBarBackground());
        }
        return this.selfPane;
    }

    public final Border getSideBarBorder() {
        return BorderFactory.createLineBorder(UIManager.getColor("eas.infopane.border"));
    }

    public final Color getSideBarBackground() {
        return Color.WHITE;
    }

    public abstract Dimension getPreferredSize();

    @Override
    public String getText() {
        return this.delegate.getText();
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void removeActionLitener(ActionListener l) {
        this.delegate.removeActionListener(l);
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        this.delegate.removeMouseListener(l);
    }

    @Override
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    public void setIcon(Icon icon) {
        this.delegate.setIcon(icon);
    }

    @Override
    public void setText(String text) {
        this.delegate.setText(text);
    }

    @Override
    public void setVisible(boolean b) {
        this.isVisible = b;
        if (this.isVisible) {
            this.show();
        } else {
            this.hide();
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public JDialog getDialog() {
        if (this.dialog == null) {
            if (this.ownerWindow != null) {
                if (this.ownerWindow instanceof Dialog) {
                    this.dialog = new JDialog((Dialog)this.ownerWindow);
                } else if (this.ownerWindow instanceof Frame) {
                    this.dialog = new JDialog((Frame)this.ownerWindow);
                }
            } else {
                this.dialog = new JDialog();
            }
            if (this.dialog != null) {
                this.dialog.setUndecorated(true);
                this.dialog.setContentPane(this.getSideBarPane());
            }
        }
        return this.dialog;
    }

    public Window getOwnerWindow() {
        return this.ownerWindow;
    }

    public void show() {
        this.getDialog().pack();
        this.getDialog().setVisible(true);
    }

    public void hide() {
        this.getDialog().setVisible(false);
    }

    public void close() {
        this.getDialog().dispose();
    }

    public void setLocal(String local) {
        this.easlocal = local;
    }

    public String getLocal() {
        return this.easlocal;
    }

    public void setDCNumber(String dcnumber) {
        this.easDCNumber = dcnumber;
    }

    public String getDCNumber() {
        return this.easDCNumber;
    }

    public void setBillID(String billid) {
        this.currentBillID = billid;
    }

    public String getBillID() {
        return this.currentBillID;
    }

    public void setUserName(String userName) {
        this.currentUserName = userName;
    }

    public String getUserName() {
        return this.currentUserName;
    }

    private class SideBarBaseDelegate
    implements Serializable {
        private static final long serialVersionUID = -385741932146510820L;

        private SideBarBaseDelegate() {
        }

        public String getText() {
            return "";
        }

        public void setText(String value) {
        }

        public Icon getIcon() {
            return null;
        }

        public void setIcon(Icon icon) {
        }

        public void addActionListener(ActionListener l) {
        }

        public void removeActionListener(ActionListener l) {
        }

        public void addMouseListener(MouseListener l) {
        }

        public void removeMouseListener(MouseListener l) {
        }
    }
}

