/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.tree;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.Iterator;

public class TreeDataVerify {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("\u6ca1\u6709\u8f93\u5165\u8981\u68c0\u67e5\u7684\u5b9e\u4f53\u7684\u5168\u540d\uff01");
            System.exit(0);
        }
        MetaDataPK metaDataPk = new MetaDataPK(args[0]);
        EntityObjectInfo entity = MetaDataLoader.getEntity(null, (IMetaDataPK)metaDataPk);
        ITreeBase bizInterface = (ITreeBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)entity.getType(), ITreeBase.class);
        TreeDataVerify.verify(bizInterface);
    }

    public static void verify(ITreeBase bizInterface) throws Exception {
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().add(new SelectorItemInfo("*"));
        entityView.getSelector().add(new SelectorItemInfo("parent.*"));
        TreeBaseCollection col = bizInterface.getTreeBaseCollection(entityView);
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            TreeBaseInfo node = (TreeBaseInfo)iter.next();
            String objMsg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"72_TreeDataVerify"), node.getId().toString(), node.getNumber(), node.getName(), node.getLongNumber(), new Integer(node.getLevel()));
            if (node.getLongNumber().split("!").length != node.getLevel()) {
                System.out.println(objMsg + "\u7ed3\u70b9\u7684\u957f\u7f16\u7801\u4e0e\u5176\u7ea7\u6b21\u4e0d\u4e00\u81f4!");
                continue;
            }
            if (node.get("parent") != null && node.getLevel() == 1 || node.get("parent") == null && node.getLevel() != 1) {
                System.out.println(objMsg + "\u6709\u4e14\u4ec5\u67091\u7ea7\u7ed3\u70b9\u6ca1\u6709\u7236\u7ed3\u70b9!\t\u7236\u7ed3\u70b9:" + node.get("parent"));
                continue;
            }
            if (node.getLevel() == 1) continue;
            TreeBaseInfo parentNode = (TreeBaseInfo)node.get("parent");
            String parentLongNumber = node.getLongNumber().substring(0, node.getLongNumber().lastIndexOf("!"));
            if (!parentNode.getLongNumber().equals(parentLongNumber)) {
                System.out.println(objMsg + "\u957f\u7f16\u7801\u4e0e\u5176\u7236\u7ed3\u70b9\u7684\u957f\u7f16\u7801\u4e0d\u4e00\u81f4!\t\u7236\u7ed3\u70b9\u957f\u7f16\u7801:" + parentNode.getLongNumber());
                continue;
            }
            if (node.getLevel() == parentNode.getLevel() + 1) continue;
            System.out.println(objMsg + "\u7ea7\u6b21\u4e0e\u5176\u7236\u7ed3\u70b9\u7684\u7ea7\u6b21\u4e0d\u4e00\u81f4!\t\u7236\u7ed3\u70b9\u7ea7\u6b21:" + parentNode.getLevel());
        }
    }
}

