/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.uisidebar;

import com.kingdee.bos.ctrl.swing.KDTaskPane;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.framework.client.uisidebar.ITask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SideBarCache {
    public static final Map uiToTask = new HashMap();
    static SideBarCache cache;

    public static synchronized SideBarCache getInstance() {
        if (cache == null) {
            cache = new SideBarCache();
        }
        return cache;
    }

    public void putTaskCache(IUIObject ui, ITask[] task, KDTaskPane[] taskPane) {
        uiToTask.put(ui.getClass().getName(), new CacheItem(task, taskPane));
    }

    public CacheItem getTaskCache(IUIObject ui) {
        CacheItem cache = (CacheItem)uiToTask.get(ui.getClass().getName());
        if (cache == null) {
            cache = new CacheItem(null, null);
            uiToTask.put(ui.getClass().getName(), cache);
        }
        return cache;
    }

    public CacheItem getTaskCache(String uiName) {
        CacheItem cache = (CacheItem)uiToTask.get(uiName);
        if (cache == null) {
            cache = new CacheItem(null, null);
            uiToTask.put(uiName, cache);
        }
        return cache;
    }

    class CacheItem {
        public List taskList = new ArrayList();
        public List taskPaneList = new ArrayList();

        public CacheItem(ITask[] task, KDTaskPane[] taskPane) {
            int index;
            if (task != null) {
                for (index = 0; index < task.length; ++index) {
                    this.taskList.add(task[index]);
                }
            }
            if (taskPane != null) {
                for (index = 0; index < taskPane.length; ++index) {
                    this.taskPaneList.add(taskPane[index]);
                }
            }
        }

        public void putTask(ITask[] task) {
            if (task != null) {
                for (int index = 0; index < task.length; ++index) {
                    if (this.isExistTask(task[index])) continue;
                    this.taskList.add(task[index]);
                }
            }
        }

        private boolean isExistTask(ITask t) {
            for (ITask curTask : this.taskList) {
                if (!curTask.getId().equals(t.getId())) continue;
                return true;
            }
            return false;
        }
    }
}

