/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.uisidebar;

import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDTaskPane;
import com.kingdee.bos.ctrl.swing.helper.KDHelperBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class UISideBar {
    private static Map winToBarMap = new WeakHashMap();

    static KDHelperBar buildSideBar(CoreUIObject ui) {
        Window win = SwingUtilities.getWindowAncestor((Component)ui);
        if (win == null) {
            return null;
        }
        if (!winToBarMap.containsKey(win)) {
            UISideBar.regesterWinClose(win);
            KDHelperBar bar = new KDHelperBar();
            bar.setPreferredSize(new Dimension(200, 200));
            bar.setVisible(true);
            bar.setAlignToTabbedPane(true);
            if (win instanceof KDFrame) {
                ((KDFrame)win).setHelperBar(bar);
            }
            winToBarMap.put(win, bar);
            return bar;
        }
        KDHelperBar bar = (KDHelperBar)winToBarMap.get(win);
        bar.setVisible(true);
        return bar;
    }

    static void clearSideBar() {
        winToBarMap.clear();
    }

    static KDHelperBar removeSideBar(Window win) {
        return (KDHelperBar)winToBarMap.remove(win);
    }

    static void hideSideBar(Window win) {
        KDHelperBar bar = (KDHelperBar)winToBarMap.get(win);
        if (bar != null) {
            bar.setVisible(false);
        }
    }

    static void showSideBar(Window win) {
        KDHelperBar bar = (KDHelperBar)winToBarMap.get(win);
        if (bar != null) {
            bar.setVisible(true);
        }
    }

    static KDTaskPane addTaskPane(Action[] action) {
        if (action != null) {
            KDTaskPane tp = new KDTaskPane();
            for (int i = 0; i < action.length; ++i) {
                if (action[i] == null) continue;
                tp.add(action[i]);
            }
            return tp;
        }
        return null;
    }

    static void removeTaskPane(CoreUIObject ui, List taskPane) {
        KDHelperBar bar = UISideBar.getSideBar(ui);
        if (bar != null) {
            for (int i = 0; i < taskPane.size(); ++i) {
                bar.removeTaskPane((KDTaskPane)taskPane.get(i));
            }
        }
    }

    static KDHelperBar getSideBar(CoreUIObject ui) {
        Window win = SwingUtilities.getWindowAncestor((Component)ui);
        if (win == null) {
            return null;
        }
        return (KDHelperBar)winToBarMap.get(win);
    }

    private static void regesterWinClose(final Window win) {
        win.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                UISideBar.removeSideBar(win);
            }
        });
    }
}

