/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.uisidebar;

import com.kingdee.bos.ctrl.swing.KDTaskPane;
import com.kingdee.bos.ctrl.swing.helper.KDHelperBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.uisidebar.ITask;
import com.kingdee.eas.framework.client.uisidebar.SideBarCache;
import com.kingdee.eas.framework.client.uisidebar.UISideBar;
import com.kingdee.util.StringUtils;
import javax.swing.Action;

public class UISideBarFactory {
    public static final String IS_SHOW_SIDEBAR = "IS_SHOW_SIDEBAR";
    static boolean isShowSideBar = false;

    public static void buildSideBar(CoreUIObject ui, ITask[] tasks, boolean reload) {
        try {
            if (!isShowSideBar) {
                return;
            }
            if (ui instanceof CoreUI && !((CoreUI)ui).isShowSideBar()) {
                return;
            }
            if (tasks != null) {
                UISideBarFactory.registerTask(ui, tasks);
            }
            KDHelperBar bar = UISideBar.getSideBar(ui);
            SideBarCache.CacheItem cache = SideBarCache.getInstance().getTaskCache((IUIObject)ui);
            UISideBar.removeTaskPane(ui, cache.taskPaneList);
            if (reload) {
                cache.taskPaneList.clear();
            }
            if (cache.taskPaneList.size() == 0) {
                for (int i = 0; i < cache.taskList.size(); ++i) {
                    ITask task = (ITask)cache.taskList.get(i);
                    Action[] actions = task.getTaskAction((IUIObject)ui);
                    KDTaskPane taskPane = UISideBar.addTaskPane(actions);
                    if (taskPane == null) continue;
                    taskPane.setTitle(task.getTitle());
                    cache.taskPaneList.add(taskPane);
                }
            }
            if (cache.taskPaneList.size() > 0) {
                bar = UISideBar.buildSideBar(ui);
                for (int index = 0; index < cache.taskPaneList.size(); ++index) {
                    bar.addTaskPane((KDTaskPane)cache.taskPaneList.get(index));
                }
                bar.revalidate();
                bar.repaint();
            } else {
                if (bar == null) {
                    bar = UISideBar.buildSideBar(ui);
                }
                bar.setVisible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reBuildSideBar(CoreUIObject ui) {
        UISideBarFactory.buildSideBar(ui, null, true);
    }

    public static void registerTask(CoreUIObject ui, ITask[] task) {
        SideBarCache.CacheItem cache = SideBarCache.getInstance().getTaskCache((IUIObject)ui);
        cache.taskList.clear();
        if (task != null && task.length > 0) {
            cache.putTask(task);
        }
    }

    public static void addTask(CoreUIObject ui, ITask task) {
        SideBarCache.CacheItem cache = SideBarCache.getInstance().getTaskCache((IUIObject)ui);
        cache.putTask(new ITask[]{task});
    }

    static {
        try {
            String strParam = StringUtils.cnulls((String)ParamManager.getParamValue(null, null, (String)IS_SHOW_SIDEBAR));
            if ("true".equals(strParam)) {
                isShowSideBar = true;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

