/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.wizard;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.framework.client.wizard.AbstractWizardUI;
import com.kingdee.eas.framework.client.wizard.IWizard;
import com.kingdee.eas.framework.client.wizard.IWizardPage;
import com.kingdee.eas.framework.client.wizard.WizardPageUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;

public class WizardUI
extends AbstractWizardUI {
    private IWizardPage currentPage = null;
    private IWizard wizard;
    private boolean isMovingToPreviousPage = false;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDButton getBtnBack() {
        return this.btnBack;
    }

    public KDButton getBtnNext() {
        return this.btnNext;
    }

    public KDButton getBtnFinish() {
        return this.btnFinish;
    }

    public KDButton getBtnHelp() {
        return this.btnHelp;
    }

    protected void setWizard(IWizard newWizard) throws Exception {
        this.wizard = newWizard;
        this.wizard.setContainer((KDPanel)this);
        this.wizard.addPages();
        this.updateWizardContentPanel();
        this.showStartingPage();
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    private void updateWizardContentPanel() {
        IWizardPage[] pages = this.wizard.getPages();
        for (int i = 0; i < pages.length; ++i) {
            this.wizardContentPanel.add((Component)pages[i].getContainer());
            ((WizardPageUI)pages[i].getContainer()).initLayout();
            ((WizardPageUI)pages[i].getContainer()).setVisible(false);
            this.setContentPageBounds((WizardPageUI)pages[i].getContainer());
        }
        this.wizardContentPanel.repaint();
    }

    protected void setContentPageBounds(WizardPageUI contentUI) {
        contentUI.setBounds(0, 0, 560, 348);
    }

    private void updateNumLabel(IWizardPage page) {
        this.updateButton();
        this.setUITitle(this.getWizardTitle(page));
    }

    protected String getWizardTitle(IWizardPage page) {
        String msg = null;
        Object[] objs = null;
        msg = EASResource.getString((String)"com.kingdee.eas.framework.client.wizard.WizardResource.wizardTitle");
        objs = new Object[]{page.getTitle(), String.valueOf(this.wizard.indexOfPage(page) + 1), String.valueOf(this.wizard.getPageCount())};
        msg = MessageFormat.format(msg, objs);
        return msg;
    }

    private void updateButton() {
        IWizardPage nextPage = null;
        boolean canFlipToNextPage = false;
        boolean canFinish = this.wizard.canFinish();
        if (this.btnBack != null) {
            this.btnBack.setEnabled(this.currentPage.getPreviousPage() != null);
        }
        if (this.btnNext != null) {
            nextPage = this.currentPage.getNextPage();
            if (nextPage != null) {
                this.btnNext.setEnabled(true);
            } else {
                this.btnNext.setEnabled(false);
            }
        }
        this.btnFinish.setEnabled(canFinish);
        canFlipToNextPage = this.currentPage.canFlipToNextPage();
        if (canFlipToNextPage && !canFinish) {
            this.btnNext.requestFocusInWindow();
        } else {
            this.btnFinish.requestFocusInWindow();
        }
    }

    private void showStartingPage() throws Exception {
        this.currentPage = this.wizard.getStartingPage();
        if (this.currentPage == null) {
            return;
        }
        this.currentPage.loadPage();
        this.currentPage.getContainer().setVisible(true);
        this.updateNumLabel(this.currentPage);
    }

    public void showPage(IWizardPage page) {
        if (page == null || page == this.currentPage) {
            return;
        }
        if (!this.isMovingToPreviousPage) {
            page.setPreviousPage(this.currentPage);
        } else {
            this.isMovingToPreviousPage = false;
        }
        IWizardPage oldPage = this.currentPage;
        this.currentPage = page;
        this.currentPage.loadPage();
        if (oldPage != null) {
            this.currentPage.onPageChanged(oldPage, this.currentPage);
            oldPage.getContainer().setVisible(false);
        }
        this.currentPage.getContainer().setVisible(true);
        this.updateNumLabel(this.currentPage);
    }

    public IWizardPage getCurrentPage() {
        return this.currentPage;
    }

    @Override
    protected void btnBack_actionPerformed(ActionEvent e) throws Exception {
        IWizardPage page = this.currentPage.getPreviousPage();
        if (page == null) {
            return;
        }
        this.isMovingToPreviousPage = true;
        this.showPage(page);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void btnFinish_actionPerformed(ActionEvent e) throws Exception {
        if (this.wizard.performFinish()) {
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnHelp_actionPerformed(ActionEvent e) throws Exception {
        super.btnHelp_actionPerformed(e);
    }

    @Override
    protected void btnNext_actionPerformed(ActionEvent e) throws Exception {
        if (!this.currentPage.canFlipToNextPage()) {
            return;
        }
        IWizardPage page = this.currentPage.getNextPage();
        if (page == null) {
            return;
        }
        this.showPage(page);
    }
}

