/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.workflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.KDTables2KDSBook;
import com.kingdee.bos.ctrl.kdf.export.KDTables2KDSBookVO;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.workflow.BillWorkFlowConfig;
import com.kingdee.eas.framework.workflow.IWorkFlowHtml;
import com.kingdee.eas.framework.workflow.WorkFlowHtmlFactory;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class TransferGUItoHTML {
    private Component component;
    private final String textStart = "<input type=text class=\"textclass\" readOnly  value=";
    private final String radioStart = "<input type=radio readOnly  value=";
    private final String textEnd = "</input>";
    private final String textAreaStart = "<textarea readOnly class=\"textclass\"  value=";
    private final String textAreaEnd = "</textarea>";
    private final String divTagStart = "<div ";
    private final String nameTagStart = "name=\"";
    private final String divTagEnd = "</div>";
    private final String stylePositionStart = "style=\"position:absolute;left:";
    private final String topTag = ";top:";
    private final String heightTag = ";height:";
    private final String widthTag = "width:";
    private final String bgColorTag = "px;background-color:";
    private final String overFlowTag = "; \" ";
    private final String styleEndTag = " >";
    private String Html;
    private String billId = null;
    private int absolutex = -1;
    private int absoluteHeight = -1;
    private int absolutey = -1;
    private static Logger logger = Logger.getLogger(TransferGUItoHTML.class);

    public TransferGUItoHTML(Component component) {
        this.component = component;
    }

    public void TransferToHtml(Component component) throws Exception {
        this.component = component;
        this.transferToHtml();
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public String getHtml() {
        return this.Html;
    }

    public void setHtml(String html) {
        this.Html = html;
    }

    public void transferToHtml() throws Exception {
        StringBuffer htmlFormat = new StringBuffer();
        if (this.component != null && this.component instanceof KDPanel) {
            KDPanel panel = (KDPanel)this.component;
            this.exportHeadAndBody(panel, htmlFormat);
            int size = panel.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component ob = panel.getComponent(i);
                if (!ob.isVisible()) continue;
                this.generateTag(ob, htmlFormat);
            }
        }
        this.export(htmlFormat);
        System.out.println("export compeleted!");
    }

    public String generateHtml() throws Exception {
        StringBuffer htmlFormat = new StringBuffer();
        if (this.component != null && this.component instanceof KDPanel) {
            KDPanel panel = (KDPanel)this.component;
            this.exportHeadAndBody(panel, htmlFormat);
            int size = panel.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component ob = panel.getComponent(i);
                if (!ob.isVisible()) continue;
                this.generateTag(ob, htmlFormat);
            }
        }
        htmlFormat.append("</body>\n");
        htmlFormat.append("</html>\n");
        return htmlFormat.toString();
    }

    public void transferToHtml(String billId) throws Exception {
        IWorkFlowHtml iWorkFlowHtml = WorkFlowHtmlFactory.getRemoteInstance();
        iWorkFlowHtml.save((IObjectPK)new ObjectUuidPK(billId), this.generateHtml());
    }

    private boolean defineAttachment(Component ob, StringBuffer htmlFormat, int x, int y) throws BOSException, EASBizException {
        String[] params = BillWorkFlowConfig.getInstance().isNeedAddAttach(this.component.getClass().getName());
        boolean flag = false;
        IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getRemoteInstance();
        IAttachment iAttach = AttachmentFactory.getRemoteInstance();
        if (params != null) {
            int size = params.length;
            for (int k = 0; k < size; ++k) {
                if (ob == null || ob.getName() == null || !ob.getName().equals(params[k])) continue;
                String[] attachment = iBoAttchAsso.getAttchIDsByBoID(this.billId);
                ComplexAttachmentInfo[] attachInfos = null;
                if (attachment != null && attachment.length > 0) {
                    int length = attachment.length;
                    attachInfos = new ComplexAttachmentInfo[length];
                    ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
                    cais.needMainName();
                    cais.needExtName();
                    cais.needID();
                    int height = this.absoluteHeight > -1 ? this.absoluteHeight - 10 : 50;
                    htmlFormat.append("<div ");
                    htmlFormat.append("style=\"position:absolute;left:" + (x + 10) + ";top:" + y + ";border:1 solid #9D9D9D;width:" + ob.getWidth() + ";height:" + height + ";background:#ffffff;overflow:auto");
                    htmlFormat.append(" \">");
                    int xPos = x + 10;
                    for (int i = 0; i < length; ++i) {
                        attachInfos[i] = AttachmentManagerFactory.getClientManager().getComplexAttachmentInfo(attachment[i], cais);
                        this.dealSingleAttach(attachInfos[i], ob, htmlFormat, i, xPos += (attachInfos[i].getMainName() + attachInfos[i].getExtName()).length() * 12, y);
                    }
                    htmlFormat.append("</div>");
                }
                flag = true;
            }
        }
        return flag;
    }

    private boolean defineAttachment(Component ob, StringBuffer htmlFormat) throws BOSException, EASBizException {
        String[] params = BillWorkFlowConfig.getInstance().isNeedAddAttach(this.component.getClass().getName());
        boolean flag = false;
        IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getRemoteInstance();
        if (params != null) {
            int size = params.length;
            for (int k = 0; k < size; ++k) {
                if (ob == null || ob.getName() == null || !ob.getName().equals(params[k])) continue;
                String[] attachment = iBoAttchAsso.getAttchIDsByBoID(this.billId);
                ComplexAttachmentInfo[] attachInfos = null;
                if (attachment != null && attachment.length > 0) {
                    int length = attachment.length;
                    attachInfos = new ComplexAttachmentInfo[length];
                    ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
                    cais.needMainName();
                    cais.needExtName();
                    cais.needID();
                    int height = this.absoluteHeight > -1 ? this.absoluteHeight - 10 : 50;
                    htmlFormat.append("<div ");
                    htmlFormat.append("style=\"position:absolute;left:" + (ob.getX() + 10) + ";top:" + ob.getY() + ";border:1 solid #9D9D9D;width:" + ob.getWidth() + ";height:" + height + ";background:#ffffff;overflow:auto");
                    htmlFormat.append(" \">");
                    int xPos = ob.getX() + 10;
                    for (int i = 0; i < length; ++i) {
                        attachInfos[i] = AttachmentManagerFactory.getClientManager().getComplexAttachmentInfo(attachment[i], cais);
                        this.dealSingleAttach(attachInfos[i], ob, htmlFormat, i, xPos += (attachInfos[i].getMainName() + attachInfos[i].getExtName()).length() * 12, ob.getY());
                    }
                    htmlFormat.append("</div>");
                }
                flag = true;
            }
        }
        return flag;
    }

    private void dealSingleAttach(ComplexAttachmentInfo attachment, Component ob, StringBuffer htmlFormat, int i, int x, int y) throws BOSException, EASBizException {
        String fileName = i + 1 + "." + attachment.getMainName();
        if (!StringUtils.isEmpty((String)attachment.getExtName())) {
            fileName = fileName + "." + attachment.getExtName();
        }
        htmlFormat.append("<input type=text readOnly  value=");
        htmlFormat.append(fileName);
        int height = this.absoluteHeight > -1 ? this.absoluteHeight - 10 : 30;
        htmlFormat.append("  size=18 style=\"border:0 ;cursor:hand;left:" + x + ";top:" + y + ";width:" + fileName.length() * 12 + ";height:" + height + "\"  onclick=\"javascript:getImage('");
        htmlFormat.append(attachment.getId());
        htmlFormat.append("')\" ");
        htmlFormat.append("> </input>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(StringBuffer htmlFormat) throws Exception {
        File tempFile = File.createTempFile("eastemp", ".html");
        String path = tempFile.getCanonicalPath();
        File destFile = null;
        if (path != null) {
            destFile = new File(path);
        }
        FileOutputStream os = null;
        Writer writer = null;
        try {
            os = new FileOutputStream(destFile);
            writer = new OutputStreamWriter((OutputStream)os, "UNICODE");
            htmlFormat.append("</body>\n");
            htmlFormat.append("</html>\n");
            writer.write(htmlFormat.toString());
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer generateCorrectTag(Component tabpanel, Component ob, StringBuffer htmlFormat) throws Exception {
        if (ob instanceof KDTable) {
            File file = this.toHTMLFiles((KDTable)ob);
            this.appendTablePositionTag(tabpanel, htmlFormat, 0, 0);
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UNICODE"));){
                String s = "";
                while ((s = in.readLine()) != null) {
                    htmlFormat.append(s);
                    htmlFormat.append("\n");
                }
                htmlFormat.append("</div>");
            }
        }
        return htmlFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTag(Component ob, StringBuffer htmlFormat, int x, int y) throws Exception {
        if (this.defineAttachment(ob, htmlFormat, x, y)) {
            return;
        }
        if (ob instanceof JPanel) {
            JPanel panel = (JPanel)ob;
            int size = panel.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component obj = panel.getComponent(i);
                if (!obj.isVisible()) continue;
                this.generateTag(obj, htmlFormat, x, y);
            }
        } else if (ob instanceof KDTable) {
            File file = this.toHTMLFiles((KDTable)ob);
            this.appendTablePositionTag(ob, htmlFormat, x + ob.getX(), y + ob.getY());
            StringBuffer tableHtml = new StringBuffer();
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UNICODE"));){
                String s = "";
                while ((s = in.readLine()) != null) {
                    tableHtml.append(s);
                    tableHtml.append("\n");
                }
            }
            String strTableHtml = tableHtml.toString();
            int startPos = strTableHtml.indexOf("<Table");
            int endPos = strTableHtml.indexOf("</Table>") + "</Table>".length();
            htmlFormat.append(strTableHtml.substring(startPos, endPos));
            htmlFormat.append("</div>");
        } else if (ob instanceof KDTextArea) {
            KDTextArea obj = (KDTextArea)ob;
            System.out.println("------------------------scrolllpanel x:" + x + " Y:" + y);
            System.out.println("obj:KDTextArea,X:" + obj.getX() + "Y:" + obj.getY());
            if (x <= 0) {
                x = obj.getX();
            }
            if (y <= 0) {
                y = obj.getY();
            }
            this.appendPositionTag((Component)obj, htmlFormat, x, y);
            htmlFormat.append("<textarea readOnly class=\"textclass\"  value=");
            htmlFormat.append("\"");
            htmlFormat.append(obj.getText());
            htmlFormat.append("\"");
            htmlFormat.append(" height=");
            htmlFormat.append(obj.getHeight() - 50);
            htmlFormat.append(" width=");
            htmlFormat.append(obj.getWidth());
            htmlFormat.append(" cols=");
            htmlFormat.append(obj.getWidth() / 8);
            htmlFormat.append(" rows=");
            if (this.absoluteHeight != -1) {
                htmlFormat.append(this.absoluteHeight / 17);
            } else {
                htmlFormat.append(obj.getHeight() / 15);
            }
            htmlFormat.append(" maxlength=");
            htmlFormat.append(obj.getMaxLength());
            htmlFormat.append(" >");
            htmlFormat.append(obj.getText());
            htmlFormat.append("</textarea>");
            htmlFormat.append("</div>");
            this.absoluteHeight = -1;
        } else if (ob instanceof KDLabel) {
            KDLabel obj = (KDLabel)ob;
            this.appendLabelTag((Component)obj, htmlFormat, obj.getX() + x, obj.getY() + y);
            htmlFormat.append(obj.getText());
            htmlFormat.append("</div>");
        } else {
            this.generateTag(ob, htmlFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTag(Component ob, StringBuffer htmlFormat) throws Exception {
        if (this.defineAttachment(ob, htmlFormat)) {
            return;
        }
        if (ob instanceof KDTable) {
            File file = this.toHTMLFiles((KDTable)ob);
            this.appendTablePositionTag(ob, htmlFormat, ob.getX(), ob.getY());
            StringBuffer tableHtml = new StringBuffer();
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UNICODE"));){
                String s = "";
                while ((s = in.readLine()) != null) {
                    tableHtml.append(s);
                    tableHtml.append("\n");
                }
            }
            String strTableHtml = tableHtml.toString();
            int startPos = strTableHtml.indexOf("<Table");
            int endPos = strTableHtml.indexOf("</Table>") + "</Table>".length();
            htmlFormat.append(strTableHtml.substring(startPos, endPos));
            htmlFormat.append("</div>");
        } else if (ob instanceof KDPanel) {
            KDPanel panel = (KDPanel)ob;
            int size = panel.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component obj = panel.getComponent(i);
                if (!obj.isVisible()) continue;
                this.generateTag(obj, htmlFormat);
            }
        } else if (ob instanceof KDContainer) {
            KDContainer panel = (KDContainer)ob;
            int size = panel.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component obj = panel.getComponent(i);
                if (!obj.isVisible()) continue;
                this.generateTag(obj, htmlFormat, panel.getX(), panel.getY());
            }
        } else if (ob instanceof DetailPanel) {
            DetailPanel panel = (DetailPanel)ob;
            int size = panel.getComponentCount();
            int offset = 0;
            for (int i = 0; i < size; ++i) {
                Component obj = panel.getComponent(i);
                if (obj.isVisible()) {
                    this.generateTag(obj, htmlFormat, panel.getX(), panel.getY() + offset);
                }
                offset += 19;
            }
        } else if (ob instanceof JPanel) {
            JPanel panel = (JPanel)ob;
            int size = panel.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component obj = panel.getComponent(i);
                if (!obj.isVisible()) continue;
                this.generateTag(obj, htmlFormat, panel.getX(), panel.getY());
            }
        } else if (ob instanceof KDScrollPane) {
            KDScrollPane panel = (KDScrollPane)ob;
            int size = panel.getViewport().getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component obj = panel.getViewport().getComponent(i);
                if (!obj.isVisible()) continue;
                if (obj instanceof KDPanel) {
                    this.absolutex = panel.getX();
                    this.absolutey = panel.getY();
                    this.absoluteHeight = panel.getHeight();
                }
                this.generateTag(obj, htmlFormat, panel.getX(), panel.getY());
            }
            this.absolutex = -1;
            this.absolutey = -1;
            this.absoluteHeight = -1;
        } else if (ob instanceof KDTabbedPane) {
            KDTabbedPane tabpanel = (KDTabbedPane)ob;
            int sum = tabpanel.getTabCount();
            for (int i = 0; i < tabpanel.getTabCount(); ++i) {
                Component compt = tabpanel.getComponentAt(i);
                if (compt == null || !(compt instanceof KDPanel)) continue;
                KDPanel panel = (KDPanel)compt;
                htmlFormat.append("<div ");
                int x = tabpanel.getX();
                for (int k = i; k > 0; --k) {
                    x = x + tabpanel.getX() + tabpanel.getTitleAt(k - 1).length() * 19;
                }
                htmlFormat.append("style=\"position:absolute;left:" + x + ";top:" + tabpanel.getY() + ";height:");
                htmlFormat.append("18");
                htmlFormat.append("width:");
                htmlFormat.append("80");
                htmlFormat.append("; font-size:13px");
                htmlFormat.append("; \" ");
                htmlFormat.append(" >");
                htmlFormat.append("<input type=\"button\" onclick=\"changeDiv('" + tabpanel.getName() + ";" + i + "'," + sum + ") \"  value=\"" + tabpanel.getTitleAt(i) + "\"></input>");
                htmlFormat.append("</div>");
                this.appendTabPanelPositionTag((Component)tabpanel, htmlFormat, tabpanel.getX(), tabpanel.getY() + 18, i);
                int size = panel.getComponentCount();
                for (int j = 0; j < size; ++j) {
                    Component obp = panel.getComponent(j);
                    if (obp.isVisible() && this.isDisplaycorrect(obp)) {
                        this.generateTag(obp, htmlFormat);
                        continue;
                    }
                    this.generateCorrectTag((Component)tabpanel, obp, htmlFormat);
                }
                htmlFormat.append("</div>");
            }
        } else if (ob instanceof KDLabelContainer) {
            KDLabelContainer obj = (KDLabelContainer)ob;
            JComponent editor = obj.getBoundEditor();
            if (this.absolutex > 0 || this.absolutey > 0) {
                this.appendPositionTag((Component)obj, htmlFormat, obj.getX() + this.absolutex, obj.getY() + 5 + this.absolutey);
                this.absolutex = -1;
                this.absolutey = -1;
            } else {
                this.appendPositionTag((Component)obj, htmlFormat, obj.getX(), obj.getY() + 5);
            }
            if (obj.getHeight() > 1) {
                htmlFormat.append(obj.getBoundLabelText());
            }
            htmlFormat.append("</div>");
            this.handlerEditor(obj, editor, htmlFormat, obj.getX() + obj.getBoundLabelLength(), obj.getY());
        } else if (ob instanceof KDLabel) {
            KDLabel obj = (KDLabel)ob;
            this.appendLabelTag((Component)obj, htmlFormat, obj.getX(), obj.getY());
            htmlFormat.append(obj.getText());
            htmlFormat.append("</font>");
            htmlFormat.append("</div>");
        } else if (ob instanceof KDBizMultiLangArea) {
            KDBizMultiLangArea obj = (KDBizMultiLangArea)ob;
            this.appendPositionTag((Component)obj, htmlFormat, obj.getX(), obj.getY());
            htmlFormat.append("<textarea readOnly class=\"textclass\"  value=");
            htmlFormat.append("\" ");
            htmlFormat.append("\"");
            htmlFormat.append(" height=");
            htmlFormat.append(obj.getHeight());
            htmlFormat.append(" width=");
            htmlFormat.append(obj.getWidth());
            htmlFormat.append(" cols=");
            htmlFormat.append(obj.getWidth() / 8);
            htmlFormat.append(" rows=");
            htmlFormat.append(obj.getHeight() / 10);
            htmlFormat.append(" maxlength=");
            htmlFormat.append(obj.getMaxLength());
            htmlFormat.append(" >");
            htmlFormat.append("</textarea>");
            htmlFormat.append("</div>");
        } else if (ob instanceof KDTextArea) {
            KDTextArea obj = (KDTextArea)ob;
            this.appendPositionTag((Component)obj, htmlFormat, obj.getX(), obj.getY());
            htmlFormat.append("<textarea readOnly class=\"textclass\"  value=");
            htmlFormat.append("\"");
            htmlFormat.append(obj.getText());
            htmlFormat.append("\"");
            htmlFormat.append(" height=");
            htmlFormat.append(obj.getHeight());
            htmlFormat.append(" width=");
            htmlFormat.append(obj.getWidth());
            htmlFormat.append(" cols=");
            htmlFormat.append(obj.getWidth() / 10);
            htmlFormat.append(" rows=");
            htmlFormat.append(obj.getHeight() / 10);
            htmlFormat.append(" maxlength=");
            htmlFormat.append(obj.getMaxLength());
            htmlFormat.append(" >");
            htmlFormat.append(obj.getText());
            htmlFormat.append("</textarea>");
            htmlFormat.append("</div>");
        } else if (ob instanceof KDCheckBox) {
            KDCheckBox obj = (KDCheckBox)ob;
            this.appendPositionTag((Component)obj, htmlFormat, obj.getX(), obj.getY());
            if (obj.isSelected()) {
                htmlFormat.append("<input type=\"checkbox\" disabled checked>");
            } else {
                htmlFormat.append("<input type=\"checkbox\" disabled>");
            }
            htmlFormat.append(obj.getText());
            htmlFormat.append("</input>");
            htmlFormat.append("</div>");
        } else if (ob instanceof KDSeparator) {
            KDSeparator obj = (KDSeparator)ob;
            htmlFormat.append("<div ");
            htmlFormat.append("style=\"position:absolute;left:" + obj.getX() + ";top:" + (obj.getY() - 3) + ";height:");
            htmlFormat.append(obj.getHeight());
            htmlFormat.append("width:");
            if (obj.getWidth() > 1000) {
                htmlFormat.append(996);
            } else {
                htmlFormat.append(obj.getWidth());
            }
            htmlFormat.append("; \" ");
            htmlFormat.append(" >");
            htmlFormat.append("<hr size=1>");
            htmlFormat.append("</div>");
        } else if (ob instanceof KDTextField) {
            KDTextField obj = (KDTextField)ob;
            this.appendPositionTag((Component)obj, htmlFormat, obj.getX(), obj.getY());
            htmlFormat.append("<input type=text class=\"textclass\" readOnly  value=");
            htmlFormat.append("\"");
            htmlFormat.append(obj.getText());
            htmlFormat.append("\" size=");
            htmlFormat.append(obj.getWidth() / 8);
            htmlFormat.append(" style=\"");
            htmlFormat.append("width:");
            htmlFormat.append(obj.getWidth());
            htmlFormat.append("\" ");
            htmlFormat.append(" >");
            htmlFormat.append("</input>");
            htmlFormat.append("</div>");
        } else if (ob instanceof KDRadioButton) {
            KDRadioButton obj = (KDRadioButton)ob;
            this.appendRadioPositionTag((Component)obj, htmlFormat, obj.getX(), obj.getY());
            htmlFormat.append("<input type=radio readOnly  value=");
            htmlFormat.append("\"");
            htmlFormat.append(obj.getText());
            htmlFormat.append("\" ");
            if (obj.isEnabled() && obj.isSelected()) {
                htmlFormat.append(" checked");
            }
            htmlFormat.append(" >");
            htmlFormat.append(obj.getText());
            htmlFormat.append("</input>");
            htmlFormat.append("</div>");
        } else if (ob instanceof KDDatePicker) {
            KDDatePicker obj = (KDDatePicker)ob;
            this.appendPositionTag((Component)obj, htmlFormat, obj.getX(), obj.getY());
            htmlFormat.append("<input type=text class=\"textclass\" readOnly  value=");
            htmlFormat.append("\"");
            htmlFormat.append(obj.getText());
            htmlFormat.append("\" size=");
            htmlFormat.append(obj.getWidth() / 8);
            htmlFormat.append(" style=\"");
            htmlFormat.append("width:");
            htmlFormat.append(obj.getWidth());
            htmlFormat.append("\" ");
            htmlFormat.append(" >");
            htmlFormat.append("</input>");
            htmlFormat.append("</div>");
        } else if (ob instanceof KDComboBox) {
            KDComboBox obj = (KDComboBox)ob;
            this.appendPositionTag((Component)obj, htmlFormat, obj.getX(), obj.getY());
            htmlFormat.append("<input type=text class=\"textclass\" readOnly  value=");
            htmlFormat.append("\"");
            if (obj.getSelectedItem() == null) {
                htmlFormat.append("");
            } else {
                htmlFormat.append(obj.getSelectedItem());
            }
            htmlFormat.append("\"");
            htmlFormat.append(" style=\"");
            htmlFormat.append("width:");
            htmlFormat.append(obj.getWidth());
            htmlFormat.append("\" ");
            htmlFormat.append(" >");
            htmlFormat.append("</input>");
            htmlFormat.append("</div>");
        }
    }

    private boolean isDisplaycorrect(Component ob) {
        return !ob.isVisible() || ob.getWidth() > 1 || ob.getHeight() > 1;
    }

    private String getBindingName(Component ob) {
        return ob.getName();
    }

    private void appendPositionTag(KDLabelContainer parent, Component ob, StringBuffer htmlFormat, int xpos, int ypos) {
        int height = parent.getHeight();
        int width = parent.getWidth();
        htmlFormat.append("<div ");
        htmlFormat.append("name=\"");
        htmlFormat.append(this.getBindingName(ob) + "\" ");
        htmlFormat.append("style=\"position:absolute;left:" + xpos + ";top:" + ypos + ";height:");
        htmlFormat.append(height);
        htmlFormat.append(";");
        htmlFormat.append("width:");
        htmlFormat.append(width - parent.getBoundLabelLength());
        htmlFormat.append("; \" ");
        htmlFormat.append(" >");
    }

    private void appendLabelTag(Component ob, StringBuffer htmlFormat, int xpos, int ypos) {
        int height = ob.getHeight();
        int width = ob.getWidth();
        htmlFormat.append("<div ");
        htmlFormat.append("name=\"");
        htmlFormat.append(this.getBindingName(ob) + "\" ");
        htmlFormat.append("style=\"position:absolute;left:" + xpos + ";top:" + ypos + ";height:");
        htmlFormat.append(height);
        htmlFormat.append(";");
        htmlFormat.append("width:");
        htmlFormat.append(width);
        htmlFormat.append("; font-size:12px");
        htmlFormat.append("; \" ");
        htmlFormat.append(" >");
    }

    private void appendPositionTag(Component ob, StringBuffer htmlFormat, int xpos, int ypos) {
        int height = ob.getHeight();
        int width = ob.getWidth();
        htmlFormat.append("<div ");
        htmlFormat.append("name=\"");
        htmlFormat.append(this.getBindingName(ob) + "\" ");
        htmlFormat.append("style=\"position:absolute;left:" + xpos + ";top:" + ypos + ";height:");
        htmlFormat.append(height);
        htmlFormat.append(";");
        htmlFormat.append("width:");
        htmlFormat.append(width);
        htmlFormat.append("; font-size:13px");
        htmlFormat.append("; \" ");
        htmlFormat.append(" >");
    }

    private void appendRadioPositionTag(Component ob, StringBuffer htmlFormat, int xpos, int ypos) {
        int height = ob.getHeight();
        int width = ob.getWidth() + 14;
        htmlFormat.append("<div ");
        htmlFormat.append("name=\"");
        htmlFormat.append(this.getBindingName(ob) + "\" ");
        htmlFormat.append("style=\"position:absolute;left:" + xpos + ";top:" + ypos + ";height:");
        htmlFormat.append(height);
        htmlFormat.append(";");
        htmlFormat.append("width:");
        htmlFormat.append(width);
        htmlFormat.append("; font-size:13px");
        htmlFormat.append("; \" ");
        htmlFormat.append(" >");
    }

    private void appendTablePositionTag(Component ob, StringBuffer htmlFormat, int xpos, int ypos) {
        int height = ob.getHeight();
        int width = ob.getWidth();
        htmlFormat.append("<div ");
        htmlFormat.append(" class=\"divclass\" ");
        htmlFormat.append("name=\"");
        htmlFormat.append(this.getBindingName(ob) + "\" ");
        htmlFormat.append("style=\"position:absolute;left:" + xpos + ";top:" + ypos + ";height:");
        htmlFormat.append(height);
        htmlFormat.append(";");
        htmlFormat.append("width:");
        htmlFormat.append(width);
        htmlFormat.append("px;background-color:");
        Color color = ob.getBackground();
        htmlFormat.append(StyleParser.colorToHex((Color)color));
        htmlFormat.append("\" ");
        htmlFormat.append(" >");
    }

    private void appendTabPanelPositionTag(Component ob, StringBuffer htmlFormat, int xpos, int ypos, int index) {
        int height = ob.getHeight() - 20;
        int width = ob.getWidth();
        htmlFormat.append("<div ");
        htmlFormat.append(" class=\"tabpanelclass\" ");
        htmlFormat.append("id=\"");
        htmlFormat.append(ob.getName() + ";" + index);
        htmlFormat.append("\" ");
        htmlFormat.append("name=\"");
        htmlFormat.append(this.getBindingName(ob) + "\" ");
        htmlFormat.append("style=\"position:absolute;left:" + xpos + ";top:" + ypos + ";height:");
        htmlFormat.append(height);
        htmlFormat.append(";");
        htmlFormat.append("width:");
        htmlFormat.append(width);
        htmlFormat.append("px;background-color:");
        Color color = ob.getBackground();
        htmlFormat.append(StyleParser.colorToHex((Color)color));
        if (index > 0) {
            htmlFormat.append(";visibility:hidden");
        }
        htmlFormat.append("\" ");
        htmlFormat.append(" >");
    }

    private void handlerEditor(KDLabelContainer parent, JComponent editor, StringBuffer sb, int xpos, int ypos) throws Exception {
        KDTextField kd;
        if (editor != null && !editor.isVisible() || parent.getWidth() - parent.getBoundLabelLength() <= 0) {
            return;
        }
        this.defineAttachment(editor, sb);
        if (editor instanceof KDTextField) {
            kd = (KDTextField)editor;
            this.appendPositionTag(parent, (Component)kd, sb, xpos, ypos);
            sb.append("<input type=text class=\"textclass\" readOnly  value=");
            sb.append("\"");
            sb.append(kd.getText());
            sb.append("\" size=");
            sb.append(parent.getWidth() / 8);
            sb.append(" style=\"");
            sb.append("width:");
            sb.append(parent.getWidth() - parent.getBoundLabelLength());
            sb.append("\" ");
            sb.append(" >");
            sb.append("</input>");
            sb.append("</div>");
        } else if (editor instanceof KDBizPromptBox) {
            kd = (KDBizPromptBox)editor;
            this.appendPositionTag(parent, (Component)kd, sb, xpos, ypos);
            sb.append("<input type=text class=\"textclass\" readOnly  value=");
            sb.append("\"");
            sb.append(kd.getText());
            sb.append("\" style=\"");
            sb.append("width:");
            sb.append(parent.getWidth() - parent.getBoundLabelLength());
            sb.append("\" ");
            sb.append(" >");
            sb.append("</input>");
            sb.append("</div>");
        } else if (editor instanceof KDDatePicker) {
            kd = (KDDatePicker)editor;
            this.appendPositionTag(parent, (Component)kd, sb, xpos, ypos);
            sb.append("<input type=text class=\"textclass\" readOnly  value=");
            sb.append("\"");
            sb.append(kd.getText());
            sb.append("\" size=");
            sb.append(kd.getEditor().getWidth() / 10);
            sb.append(" style=\"");
            sb.append("width:");
            sb.append(parent.getWidth() - parent.getBoundLabelLength());
            sb.append("\" ");
            sb.append(" >");
            sb.append("</input>");
            sb.append("</div>");
        } else if (editor instanceof KDComboBox) {
            kd = (KDComboBox)editor;
            this.appendPositionTag(parent, (Component)kd, sb, xpos, ypos);
            sb.append("<input type=text class=\"textclass\" readOnly  value=");
            sb.append("\"");
            sb.append(kd.getSelectedItem());
            sb.append("\"");
            sb.append(" style=\"");
            sb.append("width:");
            sb.append(parent.getWidth() - parent.getBoundLabelLength());
            sb.append("\" ");
            sb.append(" >");
            sb.append("</input>");
            sb.append("</div>");
        } else if (editor instanceof KDFormattedTextField) {
            kd = (KDFormattedTextField)editor;
            this.appendPositionTag(parent, (Component)kd, sb, xpos, ypos);
            sb.append("<input type=text class=\"textclass\" readOnly  value=");
            sb.append("\"");
            sb.append(kd.getText());
            sb.append("\"");
            sb.append(" style=\"");
            sb.append("width:");
            sb.append(parent.getWidth() - parent.getBoundLabelLength());
            sb.append("\" ");
            sb.append(" >");
            sb.append("</input>");
            sb.append("</div>");
        } else if (editor instanceof KDNumberTextField) {
            kd = (KDNumberTextField)editor;
            this.appendPositionTag(parent, (Component)kd, sb, xpos, ypos);
            sb.append("<input type=text class=\"textclass\" readOnly  value=");
            sb.append("\"");
            sb.append(kd.getText());
            sb.append("\"");
            sb.append(" style=\"");
            sb.append("width:");
            sb.append(parent.getWidth() - parent.getBoundLabelLength());
            sb.append("\" ");
            sb.append(" >");
            sb.append("</input>");
            sb.append("</div>");
        } else if (editor instanceof KDBizMultiLangBox) {
            kd = (KDBizMultiLangBox)editor;
            this.appendPositionTag(parent, (Component)kd, sb, xpos, ypos);
            sb.append("<input type=text class=\"textclass\" readOnly  value=");
            sb.append("\"");
            sb.append("\" size=");
            sb.append(parent.getWidth() / 8);
            sb.append(" style=\"");
            sb.append("width:");
            sb.append(parent.getWidth() - parent.getBoundLabelLength());
            sb.append("\" ");
            sb.append(" >");
            sb.append("</input>");
            sb.append("</div>");
        }
        if (editor instanceof KDScrollPane) {
            KDScrollPane panel = (KDScrollPane)editor;
            int size = panel.getViewport().getComponentCount();
            for (int i = 0; i < size; ++i) {
                int y;
                Component obj = panel.getViewport().getComponent(i);
                if (!obj.isVisible()) continue;
                if (obj instanceof KDPanel) {
                    this.absolutex = panel.getX();
                    this.absolutey = panel.getY();
                }
                if ((y = panel.getY()) <= 0) {
                    y = ypos;
                }
                int x = panel.getX();
                x = xpos;
                System.out.println("X:" + x);
                this.absoluteHeight = panel.getHeight();
                System.out.println("-----absolutex:" + this.absolutex + "---absolutey" + this.absolutey);
                System.out.println("ScrollpanelX:" + panel.getX() + "ScrollPanelY:" + panel.getY());
                this.generateTag(obj, sb, x, y);
            }
            this.absolutex = -1;
            this.absolutey = -1;
            this.absoluteHeight = -1;
        }
    }

    public File toHTMLFiles(KDTable table) throws Exception {
        if (table != null) {
            ExportManager exportM = new ExportManager();
            String path = null;
            File tempFile = File.createTempFile("eastemp", ".html");
            path = tempFile.getCanonicalPath();
            KDTable[] tables = new KDTable[]{table};
            KDTables2KDSBookVO[] tablesVO = new KDTables2KDSBookVO[tables.length];
            for (int i = 0; i < tables.length; ++i) {
                tablesVO[i] = new KDTables2KDSBookVO(tables[i]);
            }
            KDSBook book = null;
            book = KDTables2KDSBook.getInstance().exportKDTablesToKDSBook(tablesVO, true, true);
            PrintableBook printBook = new PrintableBook(book);
            exportM.exportToHtmlFile(printBook, path);
            File file = new File(path);
            return file;
        }
        return null;
    }

    void exportHeadAndBody(KDPanel panel, StringBuffer sb) throws IOException {
        sb.append("<html ");
        sb.append("xmlns=\"http://www.w3.org/TR/REC-html40\">\n");
        sb.append("<head><meta http-equiv=Content-Type content=\"text/html; charset=utf-8\">");
        this.exportheadScript(sb);
        sb.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"/easportal/html/portlet/messagecenter/msgViewers/text.css\">");
        sb.append(" </head>\n");
        sb.append("<body bgcolor=\"");
        sb.append("#e2e2dd\"");
        sb.append(">\n");
    }

    void exportheadScript(StringBuffer sb) {
        sb.append("<script language=\"javascript\">");
        sb.append("function changeDiv(str,num)");
        sb.append("{");
        sb.append("var first = new String(str).split(\";\");");
        sb.append("var obj = document.getElementById(str);");
        sb.append(" for(var i=0;i<num;i++)");
        sb.append("{");
        sb.append("var ob = document.getElementById(first[0] + \";\"+i);");
        sb.append("ob.style.visibility=\"hidden\";");
        sb.append(" }");
        sb.append(" obj.style.visibility=\"visible\";");
        sb.append("}");
        sb.append("function getImage(id)");
        sb.append("{");
        sb.append("var actionPath=\"/easportal/html/portlet/messagecenter/msgViewers/attachementViewer.jsp?attachId=\"+id; ");
        sb.append("window.open(actionPath,\"\",'height=400,width=600,toolbar=no,menubar=no,scrollbars=no,resizable=no,location=no,status=no');");
        sb.append("}");
        sb.append("</script>\n");
    }
}

