/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.expression;

import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizrule.common.RuleCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.runtime.RequireUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.expression.BizRuleExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizRuleSetExecutor {
    private RuleSetInfo ruleSet;
    private CoreUI targetUI;
    private Map localCtx;
    private Interpreter interpreter;
    private List ruleExecutors = new ArrayList();
    private boolean isExecuting = false;
    private static final Logger logger = CoreUIObject.getLogger(BizRuleSetExecutor.class);
    private RequireUtil requireUtil = new RequireUtil();

    public BizRuleSetExecutor(CoreUI targetUI, Context ctx, Map localCtx, RuleSetInfo ruleSet) {
        this.ruleSet = ruleSet;
        this.targetUI = targetUI;
        this.localCtx = localCtx;
        this.interpreter = BizRuleSetExecutor.createInterpreter(ctx, localCtx, targetUI);
    }

    public BizRuleSetExecutor(CoreUI targetUI, Context ctx, Map localCtx, RuleSetInfo ruleSet, RequireUtil requireUtil) {
        this.ruleSet = ruleSet;
        this.targetUI = targetUI;
        this.localCtx = localCtx;
        this.interpreter = BizRuleSetExecutor.createInterpreter(ctx, localCtx, targetUI);
        this.requireUtil = requireUtil;
    }

    public void execute() throws Exception {
        if (!this.isExecuting) {
            RuleCollection rules = this.ruleSet.getRules();
            int n = rules.size();
            for (int i = 0; i < n; ++i) {
                BizRuleExecutor executor = new BizRuleExecutor(this.targetUI, this.interpreter, this.localCtx, rules.get(i), this.requireUtil);
                this.ruleExecutors.add(executor);
                try {
                    executor.execute();
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
        this.isExecuting = true;
    }

    private static Interpreter createInterpreter(Context ctx, Map localCtx, Object target) {
        Interpreter interpreter = new Interpreter();
        localCtx.put("__bosContext", ctx);
        interpreter.setProperyExprOwnerNullIgore(true);
        interpreter.setDefaultObject(target);
        return interpreter;
    }

    public void destroy() {
        int n = this.ruleExecutors.size();
        for (int i = 0; i < n; ++i) {
            ((BizRuleExecutor)this.ruleExecutors.get(i)).destroy();
        }
        this.ruleExecutors.clear();
        this.requireUtil = new RequireUtil();
    }

    public RequireUtil getRequireUtil() {
        return this.requireUtil;
    }
}

