/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.expression;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ListUILayoutExecutor {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.expression.ListUILayoutExecutor");
    public static final String CURRENT_LIST_UI = "Current_List_UI";
    private UIObjectInfo cfgUI;
    private Map localCtx;
    private ListUI listUI;
    private boolean isExecuting = false;

    public ListUILayoutExecutor(Context ctx, Map localCtx, UIObjectInfo cfgUI) {
        Object obj;
        this.cfgUI = cfgUI;
        this.localCtx = localCtx;
        if (ctx != null && (obj = ctx.get((Object)CURRENT_LIST_UI)) != null && obj instanceof ListUI) {
            this.listUI = (ListUI)obj;
        }
    }

    public void execute() throws Exception {
        if (!this.isExecuting && this.cfgUI != null) {
            ComponentCollection col = this.cfgUI.getComponents();
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                ComponentInfo cInfo = col.get(i);
                if (!"tblMain".equals(cInfo.getName()) || !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType()) || !this.localCtx.containsKey(cInfo.getName()) || !(this.localCtx.get(cInfo.getName()) instanceof KDTable)) continue;
                KDTable table = (KDTable)this.localCtx.get(cInfo.getName());
                logger.info((Object)"\u5f00\u59cb\u8fdb\u884cListUI\u7684\u81ea\u5b9a\u4e49\u5217\u6dfb\u52a0....");
                this.addConfigureColumn(cInfo, table);
                logger.info((Object)"ListUI\u81ea\u5b9a\u4e49\u5217\u6dfb\u52a0\u7ed3\u675f....");
            }
        }
        this.isExecuting = true;
    }

    private void addConfigureColumn(ComponentInfo table, KDTable kdtEntrys) {
        if (table == null || kdtEntrys == null || this.listUI == null) {
            return;
        }
        IMetaDataPK mainQueryPK = this.listUI.getMainQueryPK();
        IMetadataStore mds = MetadataStoreFactory.getMetadataStore(null);
        JoinQueryInfo jionQueryInfo = (JoinQueryInfo)mds.getConfigureMetadata(MetaDataTypeList.JOINQUERY, mainQueryPK);
        if (jionQueryInfo == null || jionQueryInfo.getUnits() == null || jionQueryInfo.getUnits().size() == 0) {
            logger.info((Object)"jionQueryInfo \u4e3a\u7a7a \u4e0d\u505a\u4efb\u4f55\u5904\u7406");
            return;
        }
        PropertyInfo property = table.getProperties().get("formatXml");
        if (property != null) {
            TableInfo conTableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)kdtEntrys.getFormatXml());
            PropertyUnitCollection collection = jionQueryInfo.getUnits();
            HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
            KDTRow entryHead = kdtEntrys.getHead().getRow(0);
            if (entryHead.getCells().size() != headerInfo.getCellCount()) {
                logger.error((Object)"listUILayoutExcutor\u4e2daddConfigureColumn\u65f6\u83b7\u53d6tableInfo\u53d1\u751f\u9519\u8bef");
                return;
            }
            for (int head = 0; head < headerInfo.getCellCount(); ++head) {
                String headValue = entryHead.getCell(head).getValue().toString();
                if (headValue == null) continue;
                ((CellInfo)headerInfo.getCells().get(head)).setName(headValue);
            }
            List columns = tableInfo.getColumns();
            List conColumns = conTableInfo.getColumns();
            for (int conCol = 0; conCol < conColumns.size(); ++conCol) {
                CellInfo conCellInfo;
                HeaderInfo conHeaderInfo;
                ColumnInfo conColumnInfo = (ColumnInfo)conColumns.get(conCol);
                String conColumnName = conColumnInfo.getName();
                boolean exist = false;
                for (int col = 0; col < columns.size(); ++col) {
                    ColumnInfo columnInfo = (ColumnInfo)columns.get(col);
                    String columnName = columnInfo.getName();
                    if (!columnName.equals(conColumnName)) continue;
                    exist = true;
                    columnInfo.setHide(conColumnInfo.isHide());
                }
                if (exist) continue;
                for (int c = 0; c < collection.size(); ++c) {
                    if (!collection.get(c).getName().equals(conColumnName)) continue;
                    exist = true;
                }
                if (!exist || (conHeaderInfo = (HeaderInfo)conTableInfo.getHeaders().get(0)).getCellCount() < conCol || (conCellInfo = (CellInfo)conHeaderInfo.getCells().get(conCol)) == null) continue;
                headerInfo.addCell(conCellInfo);
                tableInfo.addColumn(conColumnInfo);
            }
            String[] bindFields = new String[columns.size()];
            Map bindMap = this.getPropertyMap(table);
            logger.info((Object)"----start bindfield----------");
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
                String columnName = columnInfo.getName();
                String bindField = columnInfo.getFieldName();
                if (!StringUtils.isEmpty((String)bindField)) {
                    bindFields[i] = bindField;
                } else if (bindMap.get(columnName) != null) {
                    bindFields[i] = bindMap.get(columnName).toString();
                }
                logger.info((Object)("columnName:" + columnName + ";bindField:" + bindFields[i]));
            }
            logger.info((Object)"----end bindfield----------");
            String bindObjectName = null;
            int n2 = table.getPropertyBindings().size();
            for (int i = 0; i < n2; ++i) {
                PropertyBindingInfo pbInfo = table.getPropertyBindings().get(i);
                if (pbInfo == null || StringUtils.isEmpty((String)pbInfo.getBindingObject())) continue;
                bindObjectName = pbInfo.getBindingObject();
                break;
            }
            if (!StringUtils.isEmpty(bindObjectName)) {
                kdtEntrys.removeColumns();
                kdtEntrys.removeHeadRows();
                logger.info((Object)"\u91cd\u65b0\u8bbe\u7f6ekdtEntrys\u7684formatXml");
                kdtEntrys.setFormatXml(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
                logger.info((Object)"\u91cd\u65b0\u7ed1\u5b9akdtEntrys\u7684bindContents");
                kdtEntrys.putBindContents(bindObjectName, bindFields);
                logger.info((Object)"\u91cd\u65b0\u6784\u5efakdtEntrys\u7684\u5217");
                kdtEntrys.checkParsed(true);
                kdtEntrys.getGroupManager().setGroup(true);
                logger.info((Object)"\u8bbe\u7f6e\u5355\u636e\u5934\u7684\u8868\u683c\u878d\u5408");
                if (this.listUI != null) {
                    logger.info((Object)"\u8bbe\u7f6elistUI\u7684formatXml\u8bb0\u5f55");
                    this.listUI.setCfgFormatXml(property.getValue());
                }
            }
        }
    }

    public Map getPropertyMap(ComponentInfo table) {
        HashMap<String, String> pm = new HashMap<String, String>();
        if (table != null) {
            logger.info((Object)"-----create bind map---------------");
            int n = table.getPropertyBindings().size();
            for (int j = 0; j < n; ++j) {
                PropertyBindingInfo pbInfo = table.getPropertyBindings().get(j);
                if (pbInfo.getPropertyName().indexOf(".text") < 0) continue;
                String columnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"");
                String sbindField = pbInfo.getBingdingField();
                pm.put(columnName, sbindField);
                logger.info((Object)("columnName:" + columnName + ";bindField:" + sbindField));
            }
            logger.info((Object)"-----end bind map---------------");
        }
        return pm;
    }

    public void destroy() {
    }
}

