/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.query.AbstractQuickFilterConfigUI;
import com.kingdee.eas.framework.query.CommonDynFilterPanel;
import com.kingdee.eas.framework.query.FastQueryPanel;
import com.kingdee.eas.framework.query.IQuickFilterConfig;
import com.kingdee.eas.framework.query.QueryTreePanel;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class QuickFilterConfigUI
extends AbstractQuickFilterConfigUI
implements IQuickFilterConfig {
    private QueryTreePanel itemPoolPanel;
    private CommonDynFilterPanel filterPanel;
    private MetaDataPK queryInfo;
    private boolean isSaved = false;
    private FastQueryPanel fastQuery;
    private static final Logger logger = CoreUIObject.getLogger(QuickFilterConfigUI.class);

    public QuickFilterConfigUI() throws Exception {
        this.init();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void actionBtnSave_actionPerformed(ActionEvent e) throws Exception {
        this.filterPanel.saveQuickSearchItems();
        this.isSaved = true;
        MsgBox.showInfo((Component)((Object)this), (String)QuickFilterResources.getMessage("SAVESUCCESS"));
    }

    @Override
    protected void actionBtnConfirm_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyUI();
    }

    private void destroyUI() {
        this.getUIWindow().close();
    }

    private void init() {
    }

    public void onLoad() throws Exception {
        Object query = this.getUIContext().get("QueryInfo");
        this.queryInfo = query != null && query instanceof QueryInfo ? MetaDataPK.create((String)((QueryInfo)query).getFullName()) : (MetaDataPK)query;
        this.fastQuery = (FastQueryPanel)this.getUIContext().get("FastQueryPanel");
        FilterInfo filter = (FilterInfo)this.getUIContext().get("FilterInfo");
        ListUI listUI = null;
        this.filterPanel = new CommonDynFilterPanel(listUI, this.queryInfo, filter);
        this.panFilterItem.add((Component)((Object)this.filterPanel), (Object)"Center");
        this.panFilterItem.setBorder((Border)new LineBorder(new Color(187, 191, 197)));
        this.itemPoolPanel = new QueryTreePanel(this.queryInfo, this.filterPanel);
        this.itemPoolPanel.setBounds(new Rectangle(8, 34, 230, 404));
        this.add((Component)((Object)this.itemPoolPanel), new KDLayout.Constraints(8, 34, 230, 404, 0));
        super.onLoad();
    }

    @Override
    public FilterItemCollection getSavedFilterItems() throws BOSException {
        return this.filterPanel.getFilterInfoWithoutValue().getFilterItems();
    }

    @Override
    public String[] getSavedSigns() {
        return this.filterPanel.getCompareSigns();
    }

    @Override
    public boolean isSaved() {
        return this.isSaved;
    }
}

