/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionUtils;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.query.FastQueryPanel;
import com.kingdee.eas.framework.query.IFastFilter;
import com.kingdee.eas.framework.query.IFastQuery;
import com.kingdee.eas.framework.query.ISolutionChangedListener;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.component.DateRangePopupManager;
import java.awt.Component;
import java.awt.Rectangle;

public class QuickFilteringSupportManager {
    private ListUI listUI;
    private QuickFilteringSupportItems supportItems;
    private IFastQuery fastQuery;
    private Component mainComponent;

    public QuickFilteringSupportItems getQuickFilteringSupportItems() {
        return this.supportItems;
    }

    public QuickFilteringSupportManager(ListUI listUI, QuickFilteringSupportItems supportItems) throws Exception {
        this.listUI = listUI;
        this.supportItems = supportItems;
        if (supportItems == null) {
            return;
        }
        this.supportItems.setQueryPK(listUI.getMainQueryPK());
        this.mainComponent = listUI.getMainTable();
    }

    public QuickFilteringSupportManager(ListUI listUI, QuickFilteringSupportItems supportItems, Component mainComponent) throws Exception {
        this(listUI, supportItems);
        this.mainComponent = mainComponent;
    }

    public IFastFilter getFastFilter() {
        return this.fastQuery.getFastFilter();
    }

    public boolean refresh() {
        if (this.fastQuery == null) {
            return false;
        }
        return this.fastQuery.refresh();
    }

    public void assembleQuickFiltering(QuickFilteringSupportItems supportItems) throws Exception {
        this.supportItems = supportItems;
        if (supportItems == null || supportItems.isNotSupportAny) {
            return;
        }
        this.reLayoutComponents();
        QuerySolutionInfo defaultSolution = this.listUI.getQuerySolutionInfo();
        if (defaultSolution != null && defaultSolution.getId() == null || QuerySolutionUtils.isVirtualSolution((QuerySolutionInfo)defaultSolution)) {
            defaultSolution = null;
        }
        supportItems.getSystemSolutionItem().setFastFilter(this.getFastFilter());
        if (!this.getFastFilter().executeDefaultSolution(defaultSolution)) {
            this.fastQuery.executeRecentOnWeekAtFirst();
        }
    }

    private void reLayoutComponents() {
        this.listUI.putClientProperty("OriginalBounds", this.listUI.getBounds());
        Rectangle bounds = this.mainComponent.getBounds();
        bounds = new Rectangle(bounds.x, bounds.y + 40, (int)bounds.getWidth(), (int)bounds.getHeight() - 40);
        int right = bounds.x + bounds.width;
        FastQueryPanel fastQueryPanel = new FastQueryPanel(this.listUI, new Rectangle(0, 0, this.listUI.getWidth(), 40), right, this.supportItems);
        this.fastQuery = fastQueryPanel;
        this.listUI.add((Component)((Object)fastQueryPanel), new KDLayout.Constraints(0, 0, this.listUI.getWidth(), 40, 13));
        if (this.supportItems.getQuickFilterReLayoutHandler() != null) {
            this.supportItems.getQuickFilterReLayoutHandler().beforeReLayoutMainPanel(bounds);
            if (this.supportItems.getQuickFilterReLayoutHandler().reLayoutMainPanel((Component)((Object)fastQueryPanel), bounds)) {
                return;
            }
        }
        this.mainComponent.setBounds(bounds);
        this.listUI.remove(this.mainComponent);
        this.listUI.add(this.mainComponent, new KDLayout.Constraints(bounds.x, bounds.y, bounds.width, bounds.height, 15));
    }

    public ISolutionChangedListener getSolutionChangedListener() {
        return this.getFastFilter();
    }

    public void destroyWindow() {
        this.fastQuery.getRecentQuickSearchItemsMananger().saveRecentQuickSearchItems();
    }

    public DateRangePopupManager getDateRangePopupManager() {
        return this.fastQuery.getDateRangePopupManager();
    }
}

