/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.report.IRptFilterObject;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RptFilterUtils {
    static final Logger log = Logger.getLogger(RptFilterUtils.class);

    public static Object toRptFilterMapFromObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            return RptFilterUtils.toRptFilterMapObjectArray((Object[])object);
        }
        if (object instanceof IObjectValue) {
            return RptFilterUtils.toRptFilterMap((IObjectValue)object);
        }
        if (object instanceof IObjectCollection) {
            return RptFilterUtils.toRptFilterMapCollection((IObjectCollection)object);
        }
        if (object instanceof Collection) {
            return RptFilterUtils.toRptFilterMapCollection((Collection)object);
        }
        if (object instanceof Map) {
            return RptFilterUtils.toRptFilterMap((Map)object);
        }
        if (object instanceof IRptFilterObject) {
            return ((IRptFilterObject)object).toRptFilterInfo();
        }
        if (object instanceof TreeNode) {
            return RptFilterUtils.toRptFilterMapTreeNode((TreeNode)object);
        }
        if (object instanceof IntEnum) {
            return RptFilterUtils.toRptFilterMapIntEnum((IntEnum)object);
        }
        if (object instanceof StringEnum) {
            return RptFilterUtils.toRptFilterMapStringEnum((StringEnum)object);
        }
        RptFilterUtils.logInfo(object);
        return object;
    }

    private static Object toRptFilterMapStringEnum(StringEnum objectValue) {
        if (objectValue == null) {
            return null;
        }
        RptFilterInfo filterMap = new RptFilterInfo();
        filterMap.setRptFilterObjectClassName(objectValue.getClass().getName());
        filterMap.valueMap.put("EnumName", objectValue.getName());
        return filterMap;
    }

    private static Object toRptFilterMapIntEnum(IntEnum objectValue) {
        if (objectValue == null) {
            return null;
        }
        RptFilterInfo filterMap = new RptFilterInfo();
        filterMap.setRptFilterObjectClassName(objectValue.getClass().getName());
        filterMap.valueMap.put("EnumName", objectValue.getName());
        return filterMap;
    }

    private static Object[] toRptFilterMapObjectArray(Object[] object) {
        Object[] filterMap = new Object[object.length];
        for (int i = object.length - 1; i >= 0; --i) {
            filterMap[i] = RptFilterUtils.toRptFilterMapFromObject(object[i]);
        }
        return filterMap;
    }

    private static boolean isSuportTransToRptFilterMap(Object object) {
        return object instanceof IObjectValue || object instanceof IObjectCollection || object instanceof Collection || object instanceof Map || object instanceof Object[] || object instanceof TreeNode || object instanceof IntEnum || object instanceof StringEnum || object instanceof IRptFilterObject;
    }

    private static RptFilterInfo toRptFilterMap(Map objectValue) {
        if (objectValue == null) {
            return null;
        }
        RptFilterInfo filterMap = new RptFilterInfo();
        filterMap.setRptFilterObjectClassName(objectValue.getClass().getName());
        Set keys = objectValue.keySet();
        for (Object keyObj : keys) {
            if (keyObj == null) continue;
            Object obj = objectValue.get(keyObj);
            if (RptFilterUtils.isSuportTransToRptFilterMap(obj)) {
                filterMap.valueMap.put(keyObj, RptFilterUtils.toRptFilterMapFromObject(obj));
                continue;
            }
            filterMap.valueMap.put(keyObj, obj);
            RptFilterUtils.logInfo(obj);
        }
        return filterMap;
    }

    private static RptFilterInfo toRptFilterMap(IObjectValue objectValue) {
        if (objectValue == null) {
            return null;
        }
        RptFilterInfo filterMap = new RptFilterInfo();
        filterMap.setRptFilterObjectClassName(objectValue.getClass().getName());
        Enumeration keys = objectValue.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            Object obj = objectValue.get(key);
            if (RptFilterUtils.isSuportTransToRptFilterMap(obj)) {
                filterMap.valueMap.put(key, RptFilterUtils.toRptFilterMapFromObject(obj));
                continue;
            }
            filterMap.valueMap.put(key, obj);
            RptFilterUtils.logInfo(obj);
        }
        return filterMap;
    }

    private static RptFilterCollection toRptFilterMapCollection(IObjectCollection objectColl) {
        if (objectColl == null) {
            return null;
        }
        RptFilterCollection valueColl = new RptFilterCollection();
        valueColl.setClassName(objectColl.getClass().getName());
        for (int i = 0; i < objectColl.size(); ++i) {
            valueColl.add(RptFilterUtils.toRptFilterMap(objectColl.getObject(i)));
        }
        return valueColl;
    }

    private static RptFilterCollection toRptFilterMapCollection(Collection objectColl) {
        if (objectColl == null) {
            return null;
        }
        RptFilterCollection valueColl = new RptFilterCollection();
        valueColl.setClassName(objectColl.getClass().getName());
        for (Object value : objectColl) {
            if (RptFilterUtils.isSuportTransToRptFilterMap(value)) {
                valueColl.add(RptFilterUtils.toRptFilterMapFromObject(value));
                continue;
            }
            valueColl.add(value);
            RptFilterUtils.logInfo(value);
        }
        return valueColl;
    }

    private static Object toRptFilterMapTreeNode(TreeNode objectValue) {
        if (objectValue instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            try {
                defaultMutableTreeNode = (DefaultMutableTreeNode)ObjectUtils.createCopy((Object)objectValue);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                log.error((Object)"RptFilterInfo to TreeNode error : ", (Throwable)e);
            }
            RptFilterInfo filterMap = new RptFilterInfo();
            filterMap.setRptFilterObjectClassName(objectValue.getClass().getName());
            Enumeration<TreeNode> enumer = defaultMutableTreeNode.depthFirstEnumeration();
            while (enumer.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumer.nextElement();
                defaultMutableTreeNode.setUserObject(RptFilterUtils.toRptFilterMapFromObject(defaultMutableTreeNode.getUserObject()));
            }
            filterMap.valueMap.put("defaultMutableTreeNode", defaultMutableTreeNode);
            return filterMap;
        }
        RptFilterUtils.logInfo(objectValue);
        return objectValue;
    }

    public static Object toObjectFromRptFilterMap(Object rptFilterMap) {
        if (rptFilterMap == null) {
            return null;
        }
        if (rptFilterMap instanceof Object[]) {
            return RptFilterUtils.toObjectArray((Object[])rptFilterMap);
        }
        if (rptFilterMap instanceof RptFilterInfo) {
            RptFilterInfo rptFilter = (RptFilterInfo)rptFilterMap;
            String className = rptFilter.getRptFilterObjectClassName();
            try {
                if (className == null) {
                    return null;
                }
                if (rptFilter.valueMap.get("EnumName") != null) {
                    return RptFilterUtils.toObjectISEnum(rptFilter);
                }
                Object obj = Class.forName(className).newInstance();
                if (obj instanceof IObjectValue) {
                    return RptFilterUtils.toObject((IObjectValue)obj, rptFilter);
                }
                if (obj instanceof Map) {
                    return RptFilterUtils.toObjectMap((Map)obj, rptFilter);
                }
                if (obj instanceof IRptFilterObject) {
                    return ((IRptFilterObject)obj).toIRptFilerObject(rptFilter);
                }
                if (obj instanceof TreeNode) {
                    return RptFilterUtils.toObjectTreeNode((TreeNode)obj, rptFilter);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)"RptFilterInfo to IObjectValue error : ", (Throwable)e);
            }
        } else if (rptFilterMap instanceof RptFilterCollection) {
            RptFilterCollection rptFilterCollection = (RptFilterCollection)rptFilterMap;
            String className = rptFilterCollection.getClassName();
            if (className == null) {
                return null;
            }
            try {
                Object obj = Class.forName(className).newInstance();
                if (obj instanceof IObjectCollection) {
                    return RptFilterUtils.toObjectCollection((IObjectCollection)obj, rptFilterCollection);
                }
                if (obj instanceof Collection) {
                    return RptFilterUtils.toCollection((Collection)obj, rptFilterCollection);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)"RptFilterCollection to IObjectValue error : ", (Throwable)e);
            }
        } else {
            return rptFilterMap;
        }
        return rptFilterMap;
    }

    private static Object toObjectISEnum(RptFilterInfo rptFilter) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String className = rptFilter.getRptFilterObjectClassName();
        return ClassLoader.getSystemClassLoader().loadClass(className).getField((String)rptFilter.valueMap.get("EnumName")).get("value");
    }

    private static Object[] toObjectArray(Object[] rptFilterMap) {
        Object[] obj = new Object[rptFilterMap.length];
        for (int i = rptFilterMap.length - 1; i >= 0; --i) {
            obj[i] = RptFilterUtils.toObjectFromRptFilterMap(rptFilterMap[i]);
        }
        return obj;
    }

    private static IObjectValue toObject(IObjectValue obj, RptFilterInfo rptFilterMap) {
        try {
            Set keySet = rptFilterMap.valueMap.keySet();
            for (Object keyObj : keySet) {
                if (keyObj == null) continue;
                Object value = rptFilterMap.valueMap.get(keyObj);
                if (value instanceof RptFilterInfo || value instanceof RptFilterCollection) {
                    obj.put(keyObj.toString(), RptFilterUtils.toObjectFromRptFilterMap(value));
                    continue;
                }
                obj.put(keyObj.toString(), value);
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"RptFilterInfo to IObjectValue error : ", (Throwable)e);
            return obj;
        }
    }

    private static Object toObjectMap(Map obj, RptFilterInfo rptFilterMap) {
        try {
            Set keySet = rptFilterMap.valueMap.keySet();
            for (Object keyObj : keySet) {
                if (keyObj == null) continue;
                Object value = rptFilterMap.valueMap.get(keyObj);
                if (value instanceof RptFilterInfo || value instanceof RptFilterCollection || value instanceof Object[]) {
                    obj.put(keyObj, RptFilterUtils.toObjectFromRptFilterMap(value));
                    continue;
                }
                obj.put(keyObj, value);
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"RptFilterInfo to IObjectValue error : ", (Throwable)e);
            return obj;
        }
    }

    private static Object toObjectCollection(IObjectCollection obj, RptFilterCollection rptFilterCollection) {
        for (Object value : rptFilterCollection) {
            if (value instanceof RptFilterInfo || value instanceof RptFilterCollection || value instanceof Object[]) {
                obj.addObject((IObjectValue)RptFilterUtils.toObjectFromRptFilterMap(value));
                continue;
            }
            obj.addObject((IObjectValue)value);
        }
        return obj;
    }

    private static Object toCollection(Collection obj, RptFilterCollection rptFilterCollection) {
        for (Object value : rptFilterCollection) {
            if (value instanceof RptFilterInfo || value instanceof RptFilterCollection || value instanceof Object[]) {
                obj.add(RptFilterUtils.toObjectFromRptFilterMap(value));
                continue;
            }
            obj.add(value);
        }
        return obj;
    }

    private static Object toObjectTreeNode(TreeNode obj, RptFilterInfo rptFilter) {
        if (obj instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)rptFilter.valueMap.get("defaultMutableTreeNode");
            defaultMutableTreeNode.setUserObject(RptFilterUtils.toObjectFromRptFilterMap(defaultMutableTreeNode.getUserObject()));
            Enumeration<TreeNode> enumer = defaultMutableTreeNode.depthFirstEnumeration();
            while (enumer.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumer.nextElement();
                defaultMutableTreeNode.setUserObject(RptFilterUtils.toObjectFromRptFilterMap(defaultMutableTreeNode.getUserObject()));
            }
            return defaultMutableTreeNode;
        }
        return rptFilter;
    }

    private static void logInfo(Object obj) {
        if (!(obj == null || obj instanceof String || obj instanceof Boolean || obj instanceof Integer || obj instanceof BOSUuid || obj instanceof BigDecimal || obj instanceof Date || obj instanceof Timestamp)) {
            log.info((Object)("         No support Serializable update:" + obj.getClass()));
        }
    }
}

