/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.eas.framework.report.IRptFilterObject;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;

public class RptConditionManager
implements Serializable,
IRptFilterObject {
    private static final long serialVersionUID = 5994162598093887925L;
    private static Set defaultExcluded = new HashSet();
    private Map componentStatusMap = new HashMap();
    private Map pros = new HashMap();

    public RptConditionManager() {
    }

    public RptConditionManager(Map componentStatusMap) {
        this.componentStatusMap.putAll(componentStatusMap);
    }

    public RptConditionManager(RptParams params) {
        this(params.toMap());
    }

    public RptConditionManager(RptParams params, String[] prosKey) {
        Iterator iter = params.keySet().iterator();
        HashSet<String> ks = new HashSet<String>();
        ks.addAll(Arrays.asList(prosKey));
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (ks.contains(key)) {
                this.pros.put(key, params.getObject(key));
                continue;
            }
            this.componentStatusMap.put(key, params.getObject(key));
        }
    }

    public void setProperty(String name, Object value) {
        this.pros.put(name, value);
    }

    public Object getProperty(String name) {
        return this.pros.get(name);
    }

    public boolean contains(String keyName) {
        return this.pros.keySet().contains(keyName);
    }

    public boolean recordComponentStatus(Component cc) {
        ComponentStatus cs = ComponentStatus.parseComponentStatus(cc);
        if (cs != null) {
            this.componentStatusMap.put(cs.name, cs);
            return true;
        }
        return false;
    }

    public boolean restoreComponentStatus(Component cc) {
        if (cc == null) {
            return false;
        }
        String name = cc.getName();
        ComponentStatus cs = (ComponentStatus)this.componentStatusMap.get(name);
        if (cs != null) {
            cs.restoreStatus(cc);
            return true;
        }
        return false;
    }

    public Object getComponentStatus(Component cc) {
        ComponentStatus cs = (ComponentStatus)this.componentStatusMap.get(cc.getName());
        return cs == null ? null : cs.value;
    }

    public void recordAllStatus(Container cc) {
        this.recordAllStatus(cc, new Component[0]);
    }

    public void recordAllStatus(Container cc, Component[] excluded) {
        if (this.isExcluded(cc, excluded)) {
            return;
        }
        this.recordComponentStatus(cc);
        if (cc instanceof KDBizPromptBox) {
            return;
        }
        int n = cc.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = cc.getComponent(i);
            if (this.isExcluded(c, excluded)) continue;
            if (c instanceof Container) {
                this.recordAllStatus((Container)c, excluded);
                continue;
            }
            this.recordComponentStatus(c);
        }
    }

    private boolean isExcluded(Component cc, Component[] excluded) {
        int n = excluded.length;
        for (int i = 0; i < n; ++i) {
            if (cc != excluded[i]) continue;
            return true;
        }
        return defaultExcluded.contains(cc.getName());
    }

    public void restoreAllStatus(Container cc) {
        this.restoreComponentStatus(cc);
        if (cc instanceof KDBizPromptBox) {
            return;
        }
        int n = cc.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = cc.getComponent(i);
            if (c instanceof Container) {
                this.restoreAllStatus((Container)c);
                continue;
            }
            this.restoreComponentStatus(c);
        }
    }

    public void dumpStatusList() {
        Iterator iter = this.componentStatusMap.values().iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    public Map toMap() {
        return this.toMap(null);
    }

    public Map toMap(String componentStatusPrefix) {
        HashMap map = new HashMap();
        map.putAll(this.pros);
        if (componentStatusPrefix == null || componentStatusPrefix.length() == 0) {
            map.putAll(this.componentStatusMap);
        } else {
            for (String key : this.componentStatusMap.keySet()) {
                map.put(componentStatusPrefix, this.componentStatusMap.get(key));
            }
        }
        return map;
    }

    public RptParams toRptParams() {
        return RptParams.parseFrom(this.toMap());
    }

    @Override
    public IRptFilterObject toIRptFilerObject(RptFilterInfo rptFilterMap) {
        RptConditionManager rm = new RptConditionManager();
        rm.pros = (Map)rptFilterMap.getObject("pros");
        rm.componentStatusMap = (Map)rptFilterMap.getObject("componentStatusMap");
        return rm;
    }

    @Override
    public RptFilterInfo toRptFilterInfo() {
        RptFilterInfo rptInfo = new RptFilterInfo();
        rptInfo.setRptFilterObjectClassName(this.getClass().getName());
        rptInfo.setObject("pros", this.pros);
        rptInfo.setObject("componentStatusMap", this.componentStatusMap);
        return rptInfo;
    }

    static {
        defaultExcluded.add("Spinner.formattedTextField");
    }

    public static class ComponentStatus
    implements Serializable,
    IRptFilterObject {
        private static final long serialVersionUID = -3422147559790254184L;
        private String name;
        private Object value;
        private boolean enabled;
        private boolean support = true;

        public void setName(String aName) {
            this.name = aName;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object aValue) {
            this.value = aValue;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean aEnabled) {
            this.enabled = aEnabled;
        }

        void restoreStatus(Component cc) {
            cc.setEnabled(this.enabled);
            if (cc instanceof JTextComponent) {
                this.setValue((JTextComponent)cc);
            } else if (cc instanceof JComboBox) {
                this.setValue((JComboBox)cc);
            } else if (cc instanceof JToggleButton) {
                this.setValue((JToggleButton)cc);
            } else if (cc instanceof JSpinner) {
                this.setValue((JSpinner)cc);
            } else if (cc instanceof KDBizPromptBox) {
                this.setValue((KDBizPromptBox)cc);
            } else if (cc instanceof KDTable) {
                this.setValue((KDTable)cc);
            } else if (cc instanceof KDDatePicker) {
                this.setValue((KDDatePicker)cc);
            } else {
                this.setValue(cc);
            }
        }

        public String toString() {
            StringBuffer vaArr = new StringBuffer();
            if (this.value instanceof Object[]) {
                if (this.value != null) {
                    Object[] vatmp = (Object[])this.value;
                    for (int i = 0; i < vatmp.length; ++i) {
                        vaArr.append(vatmp[i] == null ? "null" : vatmp[i].toString());
                    }
                }
            } else if (this.value != null) {
                vaArr.append(this.value.toString());
            }
            StringBuffer sb = new StringBuffer();
            sb.append("name=").append(this.name).append("\tenabled=").append(this.enabled).append("\t value=").append(vaArr);
            return sb.toString();
        }

        static ComponentStatus parseComponentStatus(Component cc) {
            ComponentStatus cs = new ComponentStatus();
            cs.name = cc.getName();
            if (cs.name == null) {
                return null;
            }
            if (cc instanceof JTextComponent) {
                cs.parseValue((JTextComponent)cc);
            } else if (cc instanceof JComboBox) {
                cs.parseValue((JComboBox)cc);
            } else if (cc instanceof JToggleButton) {
                cs.parseValue((JToggleButton)cc);
            } else if (cc instanceof JSpinner) {
                cs.parseValue((JSpinner)cc);
            } else if (cc instanceof KDBizPromptBox) {
                cs.parseValue((KDBizPromptBox)cc);
            } else if (cc instanceof KDTable) {
                cs.parseValue((KDTable)cc);
            } else if (cc instanceof KDDatePicker) {
                cs.parseValue((KDDatePicker)cc);
            } else {
                cs.parseValue(cc);
            }
            if (!cs.support) {
                return null;
            }
            cs.enabled = cc.isEnabled();
            return cs;
        }

        private void parseValue(Component cc) {
            this.support = false;
        }

        private void setValue(Component cc) {
        }

        private void parseValue(JTextComponent cc) {
            this.value = cc.getText();
        }

        private void setValue(JTextComponent cc) {
            cc.setText((String)this.value);
        }

        private void parseValue(JComboBox cc) {
            this.value = cc.getSelectedItem();
        }

        private void setValue(JComboBox cc) {
            cc.setSelectedItem(this.value);
        }

        private void parseValue(JToggleButton cc) {
            this.value = cc.isSelected();
        }

        private void setValue(JToggleButton cc) {
            cc.setSelected((Boolean)this.value);
        }

        private void parseValue(JSpinner cc) {
            this.value = cc.getValue();
        }

        private void setValue(JSpinner cc) {
            SpinnerModel sm = cc.getModel();
            if (sm != null && sm instanceof SpinnerNumberModel && this.value instanceof Comparable) {
                Comparable<?> min;
                Comparable<?> max = ((SpinnerNumberModel)sm).getMaximum();
                if (max == null) {
                    throw new RuntimeException(cc.getName() + " maximum is null");
                }
                if (max.compareTo(this.value) < 0) {
                    this.value = max;
                }
                if ((min = ((SpinnerNumberModel)sm).getMinimum()) == null) {
                    throw new RuntimeException(cc.getName() + " minimum is null");
                }
                if (min.compareTo(this.value) > 0) {
                    this.value = min;
                }
            }
            cc.setValue(this.value);
        }

        private void parseValue(KDBizPromptBox cc) {
            this.value = cc.getValue();
        }

        private void setValue(KDBizPromptBox cc) {
            cc.setValue(this.value);
        }

        private void parseValue(KDTable cc) {
            int cols = cc.getColumnCount();
            int rows = cc.getRowCount();
            Object[][] vv = new Object[rows][cols];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    vv[i][j] = cc.getCell(i, j).getValue();
                }
            }
            this.value = vv;
        }

        private void setValue(KDTable cc) {
            cc.removeRows();
            Object[] vv = (Object[])this.value;
            for (int i = 0; i < vv.length; ++i) {
                IRow r = cc.addRow();
                for (int j = 0; j < ((Object[])vv[i]).length; ++j) {
                    r.getCell(j).setValue(((Object[])vv[i])[j]);
                }
            }
        }

        private void parseValue(KDDatePicker cc) {
            this.value = cc.getValue();
        }

        private void setValue(KDDatePicker cc) {
            cc.setValue(this.value);
        }

        @Override
        public IRptFilterObject toIRptFilerObject(RptFilterInfo rptFilterMap) {
            ComponentStatus com = new ComponentStatus();
            com.value = rptFilterMap.getObject("value");
            com.enabled = rptFilterMap.getBoolean("enabled");
            com.support = rptFilterMap.getBoolean("support");
            com.name = rptFilterMap.getString("name");
            return com;
        }

        @Override
        public RptFilterInfo toRptFilterInfo() {
            RptFilterInfo rptInfo = new RptFilterInfo();
            rptInfo.setRptFilterObjectClassName(this.getClass().getName());
            rptInfo.setObject("value", this.value);
            rptInfo.setString("name", this.name);
            rptInfo.setBoolean("enabled", this.enabled);
            rptInfo.setBoolean("support", this.support);
            return rptInfo;
        }
    }
}

