/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.formula.kscript.debug;

import com.kingdee.bos.formula.kscript.debug.remote.DebugServer;
import com.kingdee.bos.kscript.debug.AbstractBreakPoints;
import com.kingdee.bos.kscript.debug.BasicValue;
import com.kingdee.bos.kscript.debug.DebugStopException;
import com.kingdee.bos.kscript.debug.DebugTracer;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IDebugEnv;
import com.kingdee.bos.kscript.debug.IDebugProvider;
import com.kingdee.bos.kscript.debug.IDebugTracer;
import com.kingdee.bos.kscript.debug.IValue;
import com.kingdee.bos.kscript.parser.Source;
import com.kingdee.bos.kscript.runtime.Interpreter;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DebugEnv
implements IDebugEnv {
    static final Logger logger = Logger.getLogger(DebugEnv.class);
    public static final Object LOCAL_IDENTIFIER = new Object[0];
    public static final String kscript_debuger = "kscript.debug";
    private static DebugEnv debugEnv;
    private final IDebugProvider provider;
    private final HashMap debugSources = new HashMap();
    private volatile boolean terminated = false;
    private final HashMap tracers = new HashMap();
    private HashMap tagMap = new HashMap();
    private static final ThreadLocal threadTracers;

    public static synchronized IDebugEnv getDebugEnv() {
        return debugEnv;
    }

    public static synchronized IDebugEnv registerDebuger(IDebugProvider provider) {
        if (debugEnv != null) {
            return debugEnv;
        }
        debugEnv = new DebugEnv(provider);
        logger.debug((Object)"a kscript debuger is registered.");
        return debugEnv;
    }

    private static synchronized void unregisterDebuger(DebugEnv x) {
        if (debugEnv == x) {
            debugEnv = null;
        }
        logger.debug((Object)"kscript debuger is unregistered.");
    }

    public static synchronized void initializeInterpreter(Interpreter interpreter) {
        DebugEnv env = (DebugEnv)DebugEnv.getDebugEnv();
        if (env != null) {
            env.init(interpreter);
        }
    }

    private DebugEnv(IDebugProvider provider) {
        this.provider = provider;
    }

    public Object getLocalIdentifier() {
        return LOCAL_IDENTIFIER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getSourcesAndBreakPoints() {
        HashMap hashMap = this.debugSources;
        synchronized (hashMap) {
            return new HashMap(this.debugSources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourcesAndBreakPoints(HashMap data) {
        HashMap hashMap = this.debugSources;
        synchronized (hashMap) {
            this.debugSources.clear();
            this.debugSources.putAll(data);
        }
    }

    private void init(Interpreter interpreter) {
        DebugTracer tracer = new DebugTracer((IDebugEnv)this, interpreter);
        interpreter.setTracer((IDebugTracer)tracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contansDebugSource(Object sourceKey) {
        HashMap hashMap = this.debugSources;
        synchronized (hashMap) {
            return this.debugSources.containsKey(sourceKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBreakPoints getBreakPoints(Object sourceKey) {
        HashMap hashMap = this.debugSources;
        synchronized (hashMap) {
            return (AbstractBreakPoints)this.debugSources.get(sourceKey);
        }
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDebugSource(Object sourceKey) {
        HashMap hashMap = this.debugSources;
        synchronized (hashMap) {
            if (!this.debugSources.containsKey(sourceKey)) {
                this.debugSources.put(sourceKey, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBreakPoints(Object sourceKey, AbstractBreakPoints breakPoints) {
        HashMap hashMap = this.debugSources;
        synchronized (hashMap) {
            this.debugSources.put(sourceKey, breakPoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDebugSource(Object sourceKey) {
        HashMap hashMap = this.debugSources;
        synchronized (hashMap) {
            this.debugSources.remove(sourceKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDebugContext getRunningContext(Object key) {
        HashMap hashMap = this.tracers;
        synchronized (hashMap) {
            return (IDebugContext)this.tracers.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningContextCount() {
        HashMap hashMap = this.tracers;
        synchronized (hashMap) {
            return this.tracers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDebugContext[] getRunningContexts() {
        HashMap hashMap = this.tracers;
        synchronized (hashMap) {
            IDebugContext[] ar = new IDebugContext[this.tracers.size()];
            this.tracers.values().toArray(ar);
            return ar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        IDebugContext[] ctxs;
        DebugEnv debugEnv = this;
        synchronized (debugEnv) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }
        DebugEnv.unregisterDebuger(this);
        HashMap hashMap = this.tracers;
        synchronized (hashMap) {
            ctxs = this.getRunningContexts();
            this.tracers.clear();
        }
        for (int i = 0; i < ctxs.length; ++i) {
            ctxs[i].stopDebug();
        }
        HashMap hashMap2 = this.debugSources;
        synchronized (hashMap2) {
            this.debugSources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evalFinish(IDebugContext debug, Source source, Map context, Object returnValue) {
        HashMap hashMap = this.tracers;
        synchronized (hashMap) {
            this.tracers.remove(debug.getKey());
        }
        if (this.contansDebugSource(source.getKey())) {
            IValue value;
            int type;
            if (returnValue != null && returnValue instanceof DebugStopException) {
                type = -3;
                value = null;
            } else {
                type = -2;
                value = BasicValue.valueOf((Object)returnValue, null);
            }
            this.provider.debugNotify(debug, type, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evalStart(IDebugContext debug, Source source, Map context) {
        HashMap hashMap = this.tracers;
        synchronized (hashMap) {
            this.tracers.put(debug.getKey(), debug);
        }
        if (this.contansDebugSource(source.getKey())) {
            this.provider.debugNotify(debug, -1, null);
        }
    }

    public void debugOutput(IDebugContext debug, String msg) {
        if (debug.isDebugEnabled()) {
            this.provider.debugNotify(debug, -4, BasicValue.valueOf((Object)msg, String.class));
        }
    }

    public void notifyStateChanged(IDebugContext debug) {
        if (debug.isDebugEnabled()) {
            this.provider.debugNotify(debug, debug.getState(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTag(Object key) {
        HashMap hashMap = this.tagMap;
        synchronized (hashMap) {
            return this.tagMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTag(Object key, Object value) {
        HashMap hashMap = this.tagMap;
        synchronized (hashMap) {
            this.tagMap.put(key, value);
        }
    }

    public static IDebugTracer setCurrentTracer(IDebugTracer tracer) {
        IDebugTracer old = (IDebugTracer)threadTracers.get();
        threadTracers.set(tracer);
        return old;
    }

    public static IDebugTracer getCurrentTracer() {
        return (IDebugTracer)threadTracers.get();
    }

    public static IDebugContext getCurrentDebugContext() {
        Object x = threadTracers.get();
        if (x != null && x instanceof IDebugContext) {
            return (IDebugContext)x;
        }
        return null;
    }

    public void runDebug(String expr, Map context) {
    }

    static {
        try {
            String s = System.getProperty(kscript_debuger);
            if (s != null) {
                if (s.equals("remote")) {
                    DebugServer.startServer();
                } else if (s.startsWith("remote:")) {
                    int port = Integer.parseInt(s.substring(7));
                    DebugServer.startServer(port);
                } else {
                    logger.error((Object)("invalid property: kscript.debug=" + s));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        threadTracers = new ThreadLocal();
    }
}

