/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.formula.kscript.debug.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class Props {
    static final Logger logger = Logger.getLogger(Props.class);
    public final File file;
    private final Properties props = new Properties();

    public Props(File file) {
        this.file = file.getAbsoluteFile();
        this.load();
    }

    public Props(Class cls) {
        this(new File(cls.getName() + ".properties"));
    }

    public void traceComponent(final String key, final Component c) {
        this.loadComponent(key, c);
        c.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Props.this.saveComponent(key, c, true);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Props.this.saveComponent(key, c, true);
            }
        });
    }

    public void loadComponent(String key, Component c) {
        int x = this.getInt(key + ".x", c.getX());
        int y = this.getInt(key + ".y", c.getY());
        int w = this.getInt(key + ".width", c.getWidth());
        int h = this.getInt(key + ".height", c.getHeight());
        c.setBounds(x, y, w, h);
    }

    public void saveComponent(String key, Component c, boolean save) {
        if (c instanceof Frame) {
            Frame frm = (Frame)c;
            if (frm.getState() != 0) {
                return;
            }
            if (frm.getExtendedState() != 0) {
                return;
            }
        }
        if (c.isVisible()) {
            this.set(key + ".x", "" + c.getX(), false);
            this.set(key + ".y", "" + c.getY(), false);
            this.set(key + ".width", "" + c.getWidth(), false);
            this.set(key + ".height", "" + c.getHeight(), save);
        }
    }

    public boolean load() {
        try {
            this.props.clear();
            if (this.file.exists()) {
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));){
                    this.props.load(in);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean save() {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));){
            this.props.store(out, this.file.getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean set(String key, String value, boolean save) {
        if (value == null) {
            this.props.remove(key);
        } else {
            this.props.setProperty(key, value);
        }
        if (save) {
            return this.save();
        }
        return true;
    }

    public void set(String key, String value) {
        this.set(key, value, true);
    }

    public String get(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public Properties getProperties(String key) {
        Properties ps = new Properties();
        key = key + ".";
        for (Map.Entry<Object, Object> ent : this.props.entrySet()) {
            String name = (String)ent.getKey();
            String value = (String)ent.getValue();
            if (!name.startsWith(key)) continue;
            ps.put(name.substring(key.length()), value);
        }
        return ps;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            value = value.toLowerCase();
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(2), 16);
            }
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            logger.debug((Object)ex, (Throwable)ex);
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
    }

    public String[] getArray(String key) {
        int count = this.getInt(key + ".count", -1);
        if (count < 0) {
            return null;
        }
        String[] ar = new String[count];
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = this.get(key + "." + i);
        }
        return ar;
    }

    public void setArray(String key, String[] array, boolean save) {
        this.clearSubKeys(key);
        int count = array == null ? -1 : array.length;
        this.set(key + ".count", String.valueOf(count), false);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                this.set(key + "." + i, array[i]);
            }
        }
        if (save) {
            this.save();
        }
    }

    public void clearSubKeys(String key) {
        key = key + ".";
        String[] names = new String[this.props.size()];
        this.props.keySet().toArray(names);
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].startsWith(key)) continue;
            this.props.remove(names[i]);
        }
    }

    public void setProperties(String key, Properties props, boolean save) {
        this.clearSubKeys(key);
        if (props != null) {
            for (Map.Entry<Object, Object> ent : props.entrySet()) {
                String name = (String)ent.getKey();
                String value = (String)ent.getValue();
                this.props.put(key + "." + name, value);
            }
        }
        if (save) {
            this.save();
        }
    }

    public File getFile(String key) {
        String path = this.get(key);
        if (path == null || path.length() == 0) {
            return null;
        }
        return new File(path);
    }

    public Font getFont(String key) {
        String name = this.get(key + ".name");
        int style = this.getInt(key + ".style");
        int size = this.getInt(key + ".size");
        if (name == null) {
            return null;
        }
        return new Font(name, style, size);
    }

    public void setFont(String key, Font font, boolean save) {
        this.set(key + ".name", font.getName(), false);
        this.set(key + ".style", "" + font.getStyle(), false);
        this.set(key + ".size", "" + font.getSize(), save);
    }

    public File selectDirectory(String key, String title) {
        return this.selectFile(key, title, 1, false);
    }

    public File selectFile(String key, String title) {
        return this.selectFile(key, title, false);
    }

    public File selectFile(String key, String title, boolean save) {
        return this.selectFile(key, title, 0, save);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File selectFile(String key, String title, int selectionMode, boolean save) {
        Frame frm = new Frame(title);
        try {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle(title);
            fc.setFileSelectionMode(selectionMode);
            File dir = this.getFile(key + ".dir");
            File file = this.getFile(key + ".file");
            if (dir != null && dir.exists()) {
                fc.setCurrentDirectory(dir);
            }
            if (file != null && file.exists()) {
                fc.setSelectedFile(file);
            }
            int r = save ? fc.showSaveDialog(frm) : fc.showOpenDialog(frm);
            this.set(key + ".dir", fc.getCurrentDirectory().getAbsolutePath());
            if (r != 0) {
                File file2 = null;
                return file2;
            }
            this.set(key + ".file", fc.getSelectedFile().getAbsolutePath());
            File file3 = fc.getSelectedFile();
            return file3;
        }
        finally {
            frm.dispose();
        }
    }

    public String inputText(String key, String title) {
        String text = this.get(key, "");
        if ((text = JOptionPane.showInputDialog(title, (Object)text)) != null) {
            this.set(key, text);
        }
        return text;
    }
}

