/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.builder;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.service.formula.api.BuilderResourceUtil;
import com.kingdee.bos.service.formula.builder.ConstantEditField;
import com.kingdee.bos.service.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.bos.service.formula.builder.FormulaEleInfo;
import com.kingdee.bos.service.formula.builder.FormulaLinePanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

class FormulaEleComponent
implements ActionListener {
    KDPopupMenu popupMenu = new KDPopupMenu();
    KDMenuItem menuItemDel = new KDMenuItem();
    FormulaEleInfo eleInfo;
    static Font dispFont = new Font("SansSerif", 0, 14);
    KDLabel label = null;
    KDTextField textFld = null;
    FormulaLinePanel parentLine = null;

    public FormulaEleComponent(FormulaEleInfo info) {
        this.eleInfo = info;
        this.init();
    }

    private void init() {
        this.label = new KDLabel();
        this.textFld = new ConstantEditField();
        this.label.setFont(dispFont);
        this.textFld.setFont(dispFont);
        this.label.setBackground(Color.white);
        if (this.eleInfo != null) {
            if (this.eleInfo.getEleType() == 14) {
                this.label.setForeground(new Color(26, 26, 144));
            }
            if (this.eleInfo.getEleType() == 17) {
                this.label.setForeground(Color.lightGray);
            }
            if (this.eleInfo.getEleType() == 11) {
                this.label.setForeground(Color.blue);
            }
            if (this.eleInfo.getEleType() == 13 || this.eleInfo.getEleType() == 12) {
                this.label.setForeground(Color.magenta);
            }
        }
        this.textFld.setOpaque(false);
        this.textFld.setBackground(Color.white);
        this.textFld.setHorizontalAlignment(0);
        this.textFld.setPreferredSize(ConstantEditField.calBestSize(this.textFld));
        this.textFld.setEditable(FormulaBuilderPanelBean.This.isEditable());
        if (this.eleInfo != null) {
            if (this.eleInfo.isLeafProp) {
                this.label.setText(this.eleInfo.getDispStr() + "\"");
            } else {
                this.label.setText(this.eleInfo.getDispStr());
            }
            if (this.eleInfo.getEleType() == 18) {
                this.textFld.setText(this.eleInfo.getConstantStr());
            }
        }
        this.createPopupMenu();
    }

    public String genFormulaStr() {
        if (this.eleInfo == null) {
            return null;
        }
        if (this.eleInfo.getEleType() == 18) {
            return this.textFld.getText();
        }
        return this.eleInfo.genFormulaStr();
    }

    public boolean isValid() {
        return this.eleInfo != null;
    }

    private void createPopupMenu() {
        this.menuItemDel.setText(BuilderResourceUtil.getString("delete"));
        this.menuItemDel.setActionCommand("delete");
        this.menuItemDel.addActionListener((ActionListener)this);
        this.popupMenu.add((JMenuItem)this.menuItemDel);
        PopupListener popupListener = new PopupListener(this.popupMenu);
        this.textFld.addMouseListener((MouseListener)popupListener);
        this.label.addMouseListener((MouseListener)popupListener);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if ("delete".equals(ae.getActionCommand()) && this.parentLine != null) {
            this.parentLine.removeEle(this, true);
        }
    }

    public void changeAliasDisp() {
        if (this.eleInfo != null) {
            this.label.setText(this.eleInfo.getDispStr());
        }
    }

    public JComponent getComponent() {
        if (this.eleInfo != null) {
            if (this.eleInfo.getEleType() == 18) {
                return this.textFld;
            }
            return this.label;
        }
        return null;
    }

    public void afterAddToContainer() {
        if (this.eleInfo != null && this.eleInfo.getEleType() == 18) {
            this.textFld.requestFocus();
        }
    }

    public void setParent(FormulaLinePanel line) {
        this.parentLine = line;
    }

    public FormulaEleInfo getEleInfo() {
        return this.eleInfo;
    }

    static class PopupListener
    extends MouseAdapter {
        KDPopupMenu popup;

        PopupListener(KDPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!FormulaBuilderPanelBean.This.isEditable()) {
                return;
            }
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

