/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.engine;

import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.service.formula.api.BaseFormulaFunctions;
import com.kingdee.bos.service.formula.api.FormulaVarInfoParser;
import com.kingdee.bos.service.formula.api.IFormulaFunctions;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.engine.RunFormulaException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class FormulaEngine {
    public static Object runFormula(String formulaStr, Map paramCtx) throws RunFormulaException {
        return FormulaEngine.runFormula(formulaStr, paramCtx, null);
    }

    public static Object runFormula(String formulaStr, Object[] params) throws RunFormulaException {
        return FormulaEngine.runFormula(formulaStr, params, null);
    }

    public static Object runFormula(String formulaStr, Map paramCtx, Context envCtx) throws RunFormulaException {
        Interpreter interpreter = new Interpreter(envCtx);
        return FormulaEngine.runFormula(interpreter, formulaStr, paramCtx, envCtx);
    }

    public static Object runFormula(Interpreter interpreter, String formulaStr, Map paramCtx, Context envCtx) throws RunFormulaException {
        if (formulaStr == null) {
            throw new RunFormulaException("Formula string couldn't be null.");
        }
        Object rtnValue = null;
        try {
            if (!paramCtx.containsKey("__bosContext") || paramCtx.get("__bosContext") == null) {
                paramCtx.put("__bosContext", envCtx);
            }
            rtnValue = interpreter.eval(formulaStr, paramCtx);
        }
        catch (InterpreterException e) {
            throw new RunFormulaException(e);
        }
        catch (ParserException e) {
            throw new RunFormulaException(e);
        }
        return rtnValue;
    }

    public static Object runFormula(String formulaStr, Object[] params, Context envCtx) throws RunFormulaException {
        if (formulaStr == null) {
            throw new RunFormulaException("Formula string couldn't be null.");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        IVarInfo[] varInfos = new FormulaVarInfoParser().getFormulaVars(formulaStr);
        int paramIdx = 0;
        if (varInfos != null && params != null) {
            for (int i = 0; i < varInfos.length; ++i) {
                if (!"in".equals(varInfos[i].getVarScope())) continue;
                if (params.length <= paramIdx) break;
                paramMap.put(varInfos[i].getVarName(), params[i]);
                ++paramIdx;
            }
        }
        return FormulaEngine.runFormula(formulaStr, paramMap, envCtx);
    }

    public static void registerFunctions(IFormulaFunctions functions) {
        if (functions == null) {
            return;
        }
        Interpreter.publicFuncProviderList.add(functions);
    }

    public static int getIntValue(Object obj) throws ClassCastException {
        return (Integer)obj;
    }

    public static byte getByteValue(Object obj) throws ClassCastException {
        return (Byte)obj;
    }

    public static short getShortValue(Object obj) throws ClassCastException {
        return (Short)obj;
    }

    public static char getCharValue(Object obj) throws ClassCastException {
        return ((Character)obj).charValue();
    }

    public static long getLongValue(Object obj) throws ClassCastException {
        return (Long)obj;
    }

    public static float getFloatValue(Object obj) throws ClassCastException {
        return ((Float)obj).floatValue();
    }

    public static double getDoubleValue(Object obj) throws ClassCastException {
        return (Double)obj;
    }

    public static boolean getBooleanValue(Object obj) throws ClassCastException {
        return (Boolean)obj;
    }

    public static BigDecimal getBigDecmialValue(Object obj) throws ClassCastException {
        return (BigDecimal)obj;
    }

    static {
        FormulaEngine.registerFunctions(new BaseFormulaFunctions());
    }
}

