/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.engine;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.bos.service.formula.builder.hr.HRF7XMLObjects;
import com.kingdee.bos.service.formula.builder.hr.IHRObject;
import com.kingdee.bos.service.formula.engine.AliasTransformer;
import com.kingdee.bos.service.formula.engine.IKScriptTransformer;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HRObjectTrasformer
implements IKScriptTransformer {
    Map hrObject;
    Map enumObject;
    Map hrF7Object;
    HRF7XMLObjects hrF7XMLObjs = new HRF7XMLObjects();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.formula.engine.HRObjectTrasformer");

    public HRObjectTrasformer(Map hrObject, Map enumObject, Map hrF7Object) {
        this.hrObject = hrObject;
        this.enumObject = enumObject;
        this.hrF7Object = hrF7Object;
    }

    @Override
    public TokenList transform(TokenList tokenList) throws ParserException {
        Token k;
        Hashtable<String, IHRObject> firstEnumObject = new Hashtable<String, IHRObject>();
        int index = 0;
        while ((k = tokenList.lookup(index)) != null && k.type != 12) {
            if (k.type == 1) {
                boolean match = false;
                Iterator<Object> iter = this.hrF7Object.keySet().iterator();
                while (iter.hasNext()) {
                    String key = iter.next().toString();
                    if (!k.value.equals(this.hrF7Object.get(key))) continue;
                    k.value = key;
                    k.type = 6;
                    this.hrF7XMLObjs.addF7Object(key, this.hrF7Object.get(key).toString());
                    match = true;
                    break;
                }
                if (!match) {
                    for (IHRObject element : this.hrObject.values()) {
                        if (!k.value.equals(AliasTransformer.propTransform(element.getAlias()))) continue;
                        k.value = element.getUuid();
                        IHRObject[] hrEnumObjs = element.getCmpItemInstList();
                        if (hrEnumObjs != null) {
                            for (int i = 0; i < hrEnumObjs.length; ++i) {
                                if (hrEnumObjs[i] == null) continue;
                                firstEnumObject.put(hrEnumObjs[i].getUuid(), hrEnumObjs[i]);
                            }
                        }
                        match = true;
                        break;
                    }
                }
                if (!match) {
                    if (!firstEnumObject.isEmpty()) {
                        for (IHRObject element : firstEnumObject.values()) {
                            if (!k.value.equals(AliasTransformer.propTransform(element.getAlias()))) continue;
                            k.value = element.getUuid();
                            k.type = 6;
                            break;
                        }
                    }
                    for (IHRObject element : this.enumObject.values()) {
                        if (!k.value.equals(AliasTransformer.propTransform(element.getAlias()))) continue;
                        k.value = element.getUuid();
                        k.type = 6;
                        break;
                    }
                }
            }
            ++index;
        }
        return tokenList;
    }

    public String getXmlStrForF7Object() {
        String xmlStr = "";
        xmlStr = this.hrF7XMLObjs.transObjsToXML();
        return xmlStr;
    }

    @Override
    public TokenList reverseTransform(TokenList tokenList) throws ParserException {
        Token k;
        int index = 0;
        while ((k = tokenList.lookup(index)) != null && k.type != 12) {
            IHRObject _hrobject;
            if (k.type == 1) {
                if (this.hrObject.containsKey(k.value)) {
                    _hrobject = (IHRObject)this.hrObject.get(k.value);
                    k.value = _hrobject.getAlias();
                }
            } else if (k.type == 6) {
                if (this.enumObject.containsKey(k.value)) {
                    _hrobject = (IHRObject)this.enumObject.get(k.value);
                    k.value = _hrobject.getAlias();
                    k.type = 1;
                } else if (this.hrF7Object.containsKey(k.value)) {
                    k.value = StringUtils.cnulls(this.hrF7Object.get(k.value));
                    k.type = 1;
                }
            }
            ++index;
        }
        return tokenList;
    }

    public Set getHRObjectsName(TokenList tokenList) throws ParserException {
        Token k;
        HashSet<String> result = new HashSet<String>();
        int index = 0;
        while ((k = tokenList.lookup(index)) != null && k.type != 12) {
            if (k.type == 1 && this.hrObject.containsKey(k.value)) {
                result.add(k.value);
            }
            ++index;
        }
        return result;
    }

    public void setHrF7XMLObjs(String f7FormulaXMLstr) {
        this.hrF7XMLObjs = HRF7XMLObjects.getHRF7ObjectsFromXML(f7FormulaXMLstr);
    }
}

