/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.gpt.dynamic.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.kingdee.bos.gpt.dynamic.exception.GPTException;
import com.kingdee.bos.gpt.dynamic.response.OpenAPIResponse;
import com.kingdee.bos.gpt.dynamic.response.token.GetAccessToken;
import com.kingdee.bos.gpt.dynamic.response.token.GetAppToken;
import com.kingdee.bos.gpt.dynamic.response.token.LoginAccessToken;
import com.kingdee.bos.gpt.dynamic.utils.GptPropertiesUtils;
import com.kingdee.bos.gpt.dynamic.utils.HttpUtils;
import com.kingdee.util.Base64Encoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;

public class TokenHelper {
    public static final String GET_TOKEN_URL = "/kapi/oauth2/getToken";
    public static final String VERIFY_TOKEN_URL = "/kapi/oauth2/verifyToken";
    public static final String REFRESH_TOKEN_URL = "/kapi/oauth2/refreshToken";
    public static final String WITHDRAW_TOKEN_URL = "/kapi/oauth2/withdrawToken";
    public static final String GET_APP_TOKEN_URL = "/api/getAppToken.do";
    public static final String LOGIN_URL = "/api/login.do";

    public static String getAccessToken() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("client_id", GptPropertiesUtils.getGptProperties("client_id"));
        params.put("client_secret", new String(Base64Encoder.altBase64ToByteArray((String)Objects.requireNonNull(GptPropertiesUtils.getGptProperties("appSecret"))), StandardCharsets.UTF_8));
        params.put("username", GptPropertiesUtils.getGptProperties("username"));
        params.put("accountId", GptPropertiesUtils.getGptProperties("accountId"));
        params.put("nonce", UUID.randomUUID());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        params.put("timestamp", sdf.format(new Date()));
        params.put("language", "zh_CN");
        String responseStr = HttpUtils.httpPost(GptPropertiesUtils.getGptProperties("openApiUrl") + GET_TOKEN_URL, params);
        OpenAPIResponse response = (OpenAPIResponse)JSON.parseObject((String)responseStr, (TypeReference)new TypeReference<OpenAPIResponse<GetAccessToken>>(){}, (Feature[])new Feature[0]);
        if (response == null) {
            throw new GPTException("\u8bf7\u6c42access token\u5f02\u5e38\uff01");
        }
        if (response.getStatus().booleanValue()) {
            return ((GetAccessToken)response.getData()).getAccess_token();
        }
        throw new GPTException(response.getMessage());
    }

    public static String getLoginAccessToken() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", GptPropertiesUtils.getGptProperties("client_id"));
        params.put("appSecret", new String(Base64Encoder.altBase64ToByteArray((String)Objects.requireNonNull(GptPropertiesUtils.getGptProperties("appSecret"))), StandardCharsets.UTF_8));
        params.put("tenantid", GptPropertiesUtils.getGptProperties("tenantId"));
        params.put("accountId", GptPropertiesUtils.getGptProperties("accountId"));
        String responseStr = HttpUtils.httpPost(GptPropertiesUtils.getGptProperties("openApiUrl") + GET_APP_TOKEN_URL, params);
        OpenAPIResponse response = (OpenAPIResponse)JSON.parseObject((String)responseStr, (TypeReference)new TypeReference<OpenAPIResponse<GetAppToken>>(){}, (Feature[])new Feature[0]);
        if (response == null) {
            throw new GPTException("\u8bf7\u6c42app token\u5f02\u5e38\uff01");
        }
        if (response.getStatus().booleanValue()) {
            params = new HashMap();
            params.put("user", GptPropertiesUtils.getGptProperties("user"));
            params.put("usertype", "Mobile");
            params.put("apptoken", ((GetAppToken)response.getData()).getApp_token());
            params.put("tenantid", GptPropertiesUtils.getGptProperties("tenantId"));
            params.put("accountId", GptPropertiesUtils.getGptProperties("accountId"));
            params.put("language", "zh_CN");
            responseStr = HttpUtils.httpPost(GptPropertiesUtils.getGptProperties("openApiUrl") + LOGIN_URL, params);
            OpenAPIResponse response2 = (OpenAPIResponse)JSON.parseObject((String)responseStr, (TypeReference)new TypeReference<OpenAPIResponse<LoginAccessToken>>(){}, (Feature[])new Feature[0]);
            if (response2 == null) {
                throw new GPTException("\u8bf7\u6c42login access token\u5f02\u5e38\uff01");
            }
            if (response2.getStatus().booleanValue()) {
                return ((LoginAccessToken)response2.getData()).getAccess_token();
            }
            throw new GPTException(((LoginAccessToken)response2.getData()).getError_desc());
        }
        throw new GPTException(((GetAppToken)response.getData()).getError_desc());
    }
}

