/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.maintain.sshTunnel.client;

import com.kingdee.bos.maintain.sshTunnel.ISshTunnelUser;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelState;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelUserFactory;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelUserInfo;
import com.kingdee.bos.maintain.sshTunnel.client.AbstractSshTunnelCheckConfigUI;
import com.kingdee.bos.maintain.sshTunnel.util.BatUtil;
import com.kingdee.bos.maintain.sshTunnel.util.InetUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class SshTunnelCheckConfigUI
extends AbstractSshTunnelCheckConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(SshTunnelCheckConfigUI.class);

    public SshTunnelCheckConfigUI() throws Exception {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.appendFilterItem("user", (Object)userID);
        EntityViewInfo evinfo = new EntityViewInfo();
        evinfo.setFilter(filterinfo);
        CoreBaseCollection sshUsers = instance.getCollection(evinfo);
        int size = sshUsers.size();
        if (size > 0) {
            SshTunnelUserInfo sshInfo = (SshTunnelUserInfo)sshUsers.get(0);
            if (!sshInfo.getState().equals((Object)SshTunnelState.AUTHORIZED)) {
                this.bootCheckBox.setEnabled(false);
                this.savBtn.setEnabled(false);
            } else if (BatUtil.hasBootReg()) {
                this.bootCheckBox.setSelected(true);
            }
        } else {
            this.bootCheckBox.setEnabled(false);
            this.savBtn.setEnabled(false);
        }
        String config = instance.getSSHConfig();
        String[] ipPort = config.split("!");
        int isize = ipPort.length;
        if (isize == 2) {
            this.ktfServerIP.setText(ipPort[0]);
            this.ktfServerPort.setText(ipPort[1]);
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void linkBtn_actionPerformed(ActionEvent e) throws Exception {
        super.linkBtn_actionPerformed(e);
        this.cancelBtn.setEnabled(false);
        ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
        String config = instance.getSSHConfig();
        String[] ipPort = config.split("!");
        int size = ipPort.length;
        if (size == 2) {
            if (ipPort[0].contains(":")) {
                String[] ipArray = ipPort[0].split(":");
                if (InetUtil.testConnection(ipArray[0], Integer.parseInt(ipPort[1]))) {
                    if (InetUtil.testConnection(ipArray[1], Integer.parseInt(ipPort[1]))) {
                        MsgBox.showInfo((String)"\u8fde\u63a5\u6210\u529f");
                    } else {
                        MsgBox.showInfo((String)("\u8fde\u63a5" + ipArray[1] + "\u5931\u8d25"));
                    }
                } else {
                    MsgBox.showInfo((String)("\u8fde\u63a5" + ipArray[0] + "\u5931\u8d25"));
                }
            } else if (InetUtil.testConnection(ipPort[0], Integer.parseInt(ipPort[1]))) {
                MsgBox.showInfo((String)"\u8fde\u63a5\u6210\u529f");
            } else {
                MsgBox.showInfo((String)"\u8fde\u63a5\u5931\u8d25");
            }
        } else {
            MsgBox.showInfo((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u8ba9\u5176\u8bbe\u7f6e\u6b63\u786e\u7684\u670d\u52a1\u5668\u4fe1\u606f");
        }
        this.cancelBtn.setEnabled(true);
    }

    protected void cancelBtn_actionPerformed(ActionEvent e) throws Exception {
        super.cancelBtn_actionPerformed(e);
        this.disposeUIWindow();
    }

    protected void savBtn_actionPerformed(ActionEvent e) throws Exception {
        if (this.bootCheckBox.isSelected()) {
            if (!BatUtil.hasBootReg()) {
                String startSshPath = System.getProperty("EAS_HOME") + "/client/easssh/startupssh.cmd";
                if (BatUtil.addBootReg(startSshPath = startSshPath.replace("/", "\\"))) {
                    MsgBox.showInfo((String)"\u4fdd\u5b58\u6210\u529f");
                } else {
                    MsgBox.showError((String)"\u6dfb\u52a0\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u81ea\u52a8\u542f\u52a8\u5931\u8d25");
                }
            } else {
                MsgBox.showInfo((String)"\u4fdd\u5b58\u6210\u529f");
            }
        } else if (BatUtil.hasBootReg()) {
            if (BatUtil.deleteBootReg()) {
                MsgBox.showInfo((String)"\u4fdd\u5b58\u6210\u529f");
            } else {
                MsgBox.showError((String)"\u53d6\u6d88\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u81ea\u52a8\u542f\u52a8\u5931\u8d25");
            }
        } else {
            MsgBox.showInfo((String)"\u4fdd\u5b58\u6210\u529f");
        }
    }
}

