/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.maintain.sshTunnel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.maintain.sshTunnel.ISshTunnelUser;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelState;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelUserFactory;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelUserInfo;
import com.kingdee.bos.maintain.sshTunnel.client.AbstractSshTunnelClientUI;
import com.kingdee.bos.maintain.sshTunnel.client.SshTunnelCheckConfigUI;
import com.kingdee.bos.maintain.sshTunnel.util.BatUtil;
import com.kingdee.bos.maintain.sshTunnel.util.FileUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.util.httpDownload.HttpDownloadUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class SshTunnelClientUI
extends AbstractSshTunnelClientUI {
    private static final Logger logger = CoreUIObject.getLogger(SshTunnelClientUI.class);
    private UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
    private String easHome = System.getProperty("EAS_HOME");
    private String sshPath = this.easHome + "/client/easssh";
    private String startSshPath = this.easHome + "/client/easssh/startupssh.cmd";
    private String stopSshPath = this.easHome + "/client/easssh/stopssh.bat";
    private String zipSshPath = this.easHome + "/client/download/easssh.zip";
    private String clientpath = this.easHome + "/client/";

    public void onShow() throws Exception {
        super.onShow();
        File easSshFile = new File(this.sshPath);
        if (!easSshFile.exists()) {
            this.SshServerConfigBtn.setEnabled(false);
        }
        this.startBtn.setEnabled(false);
        String userID = this.userInfo.getId().toString();
        ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.appendFilterItem("user", (Object)userID);
        this.refreshTable(instance, filterinfo);
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void SshServerConfigBtn_actionPerformed(ActionEvent e) throws Exception {
        super.SshServerConfigBtn_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SshTunnelCheckConfigUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        SshTunnelCheckConfigUI ui = (SshTunnelCheckConfigUI)uiWindow.getUIObject();
        uiWindow.getUIObject().setUITitle("\u7f51\u8def\u52a0\u901f\u670d\u52a1\u5668\u8bbe\u7f6e");
        uiWindow.show();
    }

    protected void ApplySshBtn_actionPerformed(ActionEvent e) throws Exception {
        super.ApplySshBtn_actionPerformed(e);
        String userID = this.userInfo.getId().toString();
        ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
        String config = instance.getSSHConfig();
        String[] ipPort = config.split("!");
        int size = ipPort.length;
        if (size != 2) {
            MsgBox.showWarning((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u6b63\u786e\u7684\u7f51\u8def\u52a0\u901f\u670d\u52a1\u5668\u4fe1\u606f\uff0c\u518d\u7533\u8bf7");
        } else if (StringUtils.isEmpty((String)ipPort[0]) || StringUtils.isEmpty((String)ipPort[1])) {
            MsgBox.showWarning((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u6b63\u786e\u7684\u7f51\u8def\u52a0\u901f\u670d\u52a1\u5668\u4fe1\u606f\uff0c\u518d\u7533\u8bf7");
        } else {
            SshTunnelUserInfo info = new SshTunnelUserInfo();
            FilterInfo filterinfo = new FilterInfo();
            filterinfo.appendFilterItem("user", (Object)userID);
            if (instance.exists(filterinfo)) {
                if (this.updateAndDownloadSsh(instance)) {
                    MsgBox.showWarning((String)"\u5df2\u7533\u8bf7\u4f7f\u7528\u7f51\u8def\u52a0\u901f\u670d\u52a1");
                }
            } else {
                File easSshFile = new File(this.sshPath);
                if (!easSshFile.exists()) {
                    if (HttpDownloadUtil.downloadFileFromServer((String)"download/easssh.zip") && FileUtil.decompressionFile(this.zipSshPath, this.clientpath)) {
                        this.addNewSshTunnel(instance, info, filterinfo, this.userInfo);
                    } else {
                        MsgBox.showError((String)"\u4e0b\u8f7d\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u914d\u4ef6\u51fa\u9519\uff0c\u8bf7\u9000\u51fa\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u548c\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38");
                    }
                } else if (!BatUtil.hasStartedSSH()) {
                    String clientMd5;
                    String serverMd5 = instance.getSSHZipMd5();
                    if (!serverMd5.equals(clientMd5 = FileUtil.getFileMd5(this.zipSshPath))) {
                        FileUtil.deleteFile(this.zipSshPath);
                        if (HttpDownloadUtil.downloadFileFromServer((String)"download/easssh.zip") && FileUtil.delAndDecompress(this.zipSshPath, this.clientpath)) {
                            this.addNewSshTunnel(instance, info, filterinfo, this.userInfo);
                        } else {
                            MsgBox.showError((String)"\u66f4\u65b0\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u914d\u4ef6\u51fa\u9519\uff0c\u8bf7\u9000\u51fa\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u548c\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38");
                        }
                    } else {
                        this.addNewSshTunnel(instance, info, filterinfo, this.userInfo);
                    }
                } else {
                    this.addNewSshTunnel(instance, info, filterinfo, this.userInfo);
                }
            }
        }
    }

    private void addNewSshTunnel(ISshTunnelUser instance, SshTunnelUserInfo info, FilterInfo filterinfo, UserInfo userInfo) throws BOSException, EASBizException {
        info.setUser(userInfo);
        info.setState(SshTunnelState.APPLIED);
        instance.submit(info);
        this.refreshTable(instance, filterinfo);
        this.SshServerConfigBtn.setEnabled(true);
    }

    private boolean updateAndDownloadSsh(ISshTunnelUser instance) throws BOSException {
        String clientMd5;
        String serverMd5;
        File easSshFile = new File(this.sshPath);
        boolean isSuccess = true;
        if (!easSshFile.exists()) {
            if (HttpDownloadUtil.downloadFileFromServer((String)"download/easssh.zip") && FileUtil.delAndDecompress(this.zipSshPath, this.clientpath)) {
                this.SshServerConfigBtn.setEnabled(true);
            } else {
                MsgBox.showError((String)"\u4e0b\u8f7d\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u914d\u4ef6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38");
                isSuccess = false;
            }
        } else if (!BatUtil.hasStartedSSH() && !(serverMd5 = instance.getSSHZipMd5()).equals(clientMd5 = FileUtil.getFileMd5(this.zipSshPath))) {
            FileUtil.deleteFile(this.zipSshPath);
            if (HttpDownloadUtil.downloadFileFromServer((String)"download/easssh.zip") && FileUtil.delAndDecompress(this.zipSshPath, this.clientpath)) {
                this.SshServerConfigBtn.setEnabled(true);
            } else {
                MsgBox.showError((String)"\u66f4\u65b0\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u914d\u4ef6\u51fa\u9519\uff0c\u8bf7\u9000\u51fa\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u548c\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38");
                isSuccess = false;
            }
        }
        return isSuccess;
    }

    private void refreshTable(ISshTunnelUser instance, FilterInfo filterinfo) throws BOSException {
        EntityViewInfo evinfo = new EntityViewInfo();
        evinfo.setFilter(filterinfo);
        CoreBaseCollection sshUsers = instance.getCollection(evinfo);
        int size = sshUsers.size();
        if (size > 0) {
            SshTunnelUserInfo sshInfo = (SshTunnelUserInfo)sshUsers.get(0);
            if (sshInfo.getState().equals((Object)SshTunnelState.AUTHORIZED)) {
                this.startBtn.setEnabled(true);
            } else if (BatUtil.hasBootReg()) {
                BatUtil.deleteBootReg();
            }
        }
        for (int i = 0; i < size; ++i) {
            SshTunnelUserInfo sshInfo = (SshTunnelUserInfo)sshUsers.get(i);
            String id = sshInfo.getId().toString();
            IRow row = this.tblSSH.addRow();
            row.getCell("id").setValue((Object)id);
            row.getCell("number").setValue((Object)this.userInfo.getNumber());
            row.getCell("name").setValue((Object)this.userInfo.getName());
            row.getCell("state").setValue((Object)sshInfo.getState());
        }
    }

    protected void refreshBtn_actionPerformed(ActionEvent e) throws Exception {
        this.tblSSH.removeRows();
        String userID = this.userInfo.getId().toString();
        ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.appendFilterItem("user", (Object)userID);
        this.refreshTable(instance, filterinfo);
    }

    protected void startBtn_actionPerformed(ActionEvent e) throws Exception {
        try {
            String userID = this.userInfo.getId().toString();
            ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
            FilterInfo filterinfo = new FilterInfo();
            filterinfo.appendFilterItem("user", (Object)userID);
            EntityViewInfo evinfo = new EntityViewInfo();
            evinfo.setFilter(filterinfo);
            CoreBaseCollection sshUsers = instance.getCollection(evinfo);
            int size = sshUsers.size();
            if (size > 0) {
                SshTunnelUserInfo sshInfo = (SshTunnelUserInfo)sshUsers.get(0);
                if (sshInfo.getState().equals((Object)SshTunnelState.AUTHORIZED)) {
                    if (this.updateAndDownloadSsh(instance)) {
                        String config = instance.getSSHConfig();
                        String[] ipPort = config.split("!");
                        ArrayList<String> ipPortlist = FileUtil.getEassshEnv(this.easHome + "/client/easssh/kdeasssh_env.bat");
                        int length = ipPort.length;
                        int isize = ipPortlist.size();
                        if (length != 2) {
                            MsgBox.showWarning((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u6b63\u786e\u7684\u7f51\u8def\u52a0\u901f\u670d\u52a1\u5668\u4fe1\u606f\uff0c\u518d\u7533\u8bf7");
                        } else {
                            if (!(length != 2 || isize != 2 || ipPortlist.get(0).equals(ipPort[0]) && ipPortlist.get(1).equals(ipPort[1]) || !HttpDownloadUtil.downloadFileFromServer((String)"download/easssh/kdeasssh_env.bat"))) {
                                String dlPath = this.easHome + "/client/download/easssh/kdeasssh_env.bat";
                                String destPath = this.easHome + "/client/easssh/kdeasssh_env.bat";
                                FileUtil.cpFile(new File(dlPath), new File(destPath));
                                FileUtil.deleteFile(this.easHome + "/client/download");
                            }
                            if (!BatUtil.hasStartedSSH()) {
                                Process proc = Runtime.getRuntime().exec("cmd.exe /C start " + this.startSshPath);
                                int wfnum = proc.waitFor();
                                if (wfnum != 0) {
                                    logger.error((Object)("Return errorcode :" + wfnum));
                                }
                                Thread.sleep(5000L);
                                proc.destroy();
                                MsgBox.showInfo((String)"\u542f\u52a8\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u6210\u529f\u3002GUI\u7528\u6237\u8bf7\u5148\u9000\u51faEAS\u5ba2\u6237\u7aef\uff0c\u7136\u540e\u91cd\u65b0\u542f\u52a8EAS\u5ba2\u6237\u7aef;portal\u7528\u6237\u5982\u4f7f\u7528IP\u5730\u5740\u8bbf\u95ee\uff0c\u8bf7\u5c06\u8bbf\u95eeIP\u5730\u5740\u6539\u4e3a127.0.0.1,\u5982http://ip:6888/easportal\u5728\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u542f\u52a8\u540e\uff0c\u8bbf\u95ee\u65b9\u5f0f\u6539\u4e3ahttp://127.0.0.1:6888/easportal;\u5982\u4f7f\u7528\u57df\u540d\u8bf7\u4f7f\u7528http://\u57df\u540d:\u7aef\u53e3/easportal\u8bbf\u95ee\u3002");
                            } else {
                                MsgBox.showWarning((String)"\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u5df2\u542f\u52a8");
                            }
                        }
                    }
                } else {
                    MsgBox.showWarning((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53d6\u5f97\u542f\u52a8\u670d\u52a1\u7684\u6743\u9650");
                }
            } else {
                MsgBox.showWarning((String)"\u8bf7\u5148\u7533\u8bf7\u7136\u540e\u8054\u7cfb\u7ba1\u7406\u5458\u53d6\u5f97\u542f\u52a8\u6b64\u670d\u52a1\u7684\u6743\u9650");
            }
        }
        catch (Exception ex) {
            logger.error((Object)("startUpSsh Exception" + e));
            MsgBox.showError((String)"\u542f\u52a8\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u51fa\u9519");
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }
}

