/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.mbos.common.util;

import com.kingdee.mbos.common.util.CMeta;
import com.kingdee.mbos.common.util.Node;
import com.kingdee.mbos.common.util.NodeMeta;

public class FileNode
implements Node {
    protected String path;
    protected String content;
    protected CMeta meta;
    protected String url;

    public FileNode(String path, String name, String caption, String mime, String content) {
        this(path, FileNode.createMeta(name, caption, mime), content);
    }

    static CMeta createMeta(String name, String caption, String mime) {
        return new CMeta(name, caption, mime);
    }

    public FileNode(String path, CMeta meta, String content) {
        if (path == null || path.length() == 0 || "/".equals(path) || path.indexOf(".") > -1) {
            path = "";
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
        this.meta = meta;
        this.content = content;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        return this.path == null || this.path.length() == 0 || "/".equals(this.path) ? this.meta.getName() : this.path + "/" + this.meta.getName();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getNodeType() {
        return "FILE";
    }

    @Override
    public NodeMeta getNodeMeta() {
        return this.meta;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

