/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.mbos.light.deploy.handle;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.mbos.light.deploy.handle.ILightDeploy;
import com.kingdee.mbos.light.deploy.handle.LightDeploy;
import com.kingdee.mbos.light.deploy.handle.SSLClient;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class lightDeployUtil {
    private String localIP = null;
    private String localServerName = null;
    private List<ServerInfo> list = null;

    public lightDeployUtil() {
        if (this.list == null) {
            this.list = this.getRemoteServerList();
        }
    }

    public List deploy(Map map) {
        List lists = null;
        if (this.list == null) {
            LightDeploy ld = new LightDeploy();
            lists = ld.deploy(map);
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                ServerInfo serverInfo = this.list.get(i);
                ILightDeploy ld = (ILightDeploy)RPCEngineFactory.getEngine((String)serverInfo.getUrl()).createObject("com.kingdee.mbos.light.deploy.handle.LightDeploy", ILightDeploy.class);
                lists = ld.deploy(map);
            }
        }
        return lists;
    }

    public String deleteDbinfo(String eid) throws Exception {
        if (this.list == null) {
            LightDeploy ld = new LightDeploy();
            ld.deleteDbinfo(eid);
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                ServerInfo serverInfo = this.list.get(i);
                ILightDeploy ld = (ILightDeploy)RPCEngineFactory.getEngine((String)serverInfo.getUrl()).createObject("com.kingdee.mbos.light.deploy.handle.LightDeploy", ILightDeploy.class);
                ld.deleteDbinfo(eid);
            }
        }
        return "success";
    }

    public String deleteDbinfo() throws Exception {
        if (this.list == null) {
            LightDeploy ld = new LightDeploy();
            ld.deleteDbinfo();
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                ServerInfo serverInfo = this.list.get(i);
                ILightDeploy ld = (ILightDeploy)RPCEngineFactory.getEngine((String)serverInfo.getUrl()).createObject("com.kingdee.mbos.light.deploy.handle.LightDeploy", ILightDeploy.class);
                ld.deleteDbinfo();
            }
        }
        return "success";
    }

    private List<ServerInfo> getRemoteServerList() {
        ArrayList<ServerInfo> ls = new ArrayList<ServerInfo>();
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            return null;
        }
        IRPCServer[] ss = sv.getServers();
        for (int i = 0; i < ss.length; ++i) {
            IRPCServer s = ss[i];
            String url = s.getUrl();
            if (s.connectionFailed() || StringUtils.isEmpty((String)url) || this.isLocal(url)) continue;
            String serverName = s.getName();
            String IP = url.split("//")[1].split(":")[0];
            ServerInfo serverInfo = new ServerInfo(url, IP, serverName);
            ls.add(serverInfo);
        }
        return ls;
    }

    private boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(String surl) {
        DefaultHttpClient httpClient = null;
        HttpGet httpGet = null;
        String result = "";
        try {
            HttpEntity resEntity;
            httpClient = lightDeployUtil.createSingleHttpClient();
            httpGet = new HttpGet(surl);
            httpGet.addHeader("Connection", "close");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            }
        }
        catch (Exception t) {
            result = t.getMessage();
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return result.toString();
    }

    private static DefaultHttpClient createSingleHttpClient() throws Exception {
        SSLClient client = new SSLClient();
        HostConfiguration config = new HostConfiguration();
        client.getParams().setParameter("http.connection.timeout", (Object)5000);
        client.getParams().setParameter("http.socket.timeout", (Object)5000);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsPost(String url, Map<String, String> reqHead, Map<String, String> paramMap) throws ParseException, IOException, Exception {
        DefaultHttpClient httpClient = null;
        HttpPost httpPost = null;
        try {
            HttpEntity resEntity;
            CloseableHttpResponse response;
            httpClient = lightDeployUtil.createSingleHttpClient();
            httpPost = new HttpPost(url);
            httpPost.addHeader("Connection", "close");
            httpPost.addHeader("Content-Type", "application/json");
            if (reqHead != null) {
                Set<String> keySet = reqHead.keySet();
                for (String key : keySet) {
                    httpPost.addHeader(key, reqHead.get(key));
                }
            }
            if (paramMap != null) {
                String jsonString = JSON.toJSONString(paramMap);
                StringEntity stringEntity = new StringEntity(jsonString, "UTF-8");
                httpPost.setEntity((HttpEntity)stringEntity);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (resEntity = response.getEntity()) != null) {
                String string = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                return string;
            }
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsGet(String surl, HashMap<String, String> reqHead) throws ParseException, IOException, Exception {
        DefaultHttpClient httpClient = null;
        HttpGet httpGet = null;
        try {
            HttpEntity resEntity;
            CloseableHttpResponse response;
            httpClient = lightDeployUtil.createSingleHttpClient();
            httpGet = new HttpGet(surl);
            httpGet.addHeader("Connection", "close");
            if (reqHead != null) {
                Set<String> keySet = reqHead.keySet();
                for (String key : keySet) {
                    httpGet.addHeader(key, reqHead.get(key));
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)httpGet)) != null && (resEntity = response.getEntity()) != null) {
                String string = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                return string;
            }
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return null;
    }

    class ServerInfo {
        private String url;
        private String IP;
        private String serverName;

        public ServerInfo(String url, String IP, String serverName) {
            this.url = url;
            this.IP = IP;
            this.serverName = serverName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getIP() {
            return this.IP;
        }

        public String getServerName() {
            return this.serverName;
        }
    }
}

