/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.receiver.BasReleaseInfo;
import com.kingdee.eas.base.receiver.ReceiversFacadeFactory;
import com.kingdee.eas.base.receiver.util.MessageInputUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mobile.ChargeCompanyFactory;
import com.kingdee.eas.mobile.ChargeCompanyInfo;
import com.kingdee.eas.mobile.IChargeCompany;
import com.kingdee.eas.mobile.IMobileMessageAssign;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MobileMessageAssignFactory;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.client.AbstractSendMsgUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class SendMsgUI
extends AbstractSendMsgUI {
    public static final String PREDEFINED_CONTENT = "PREDEFINED_CONTENT";
    private static final long serialVersionUID = 8462541887742454441L;
    private static final Logger logger = CoreUIObject.getLogger(SendMsgUI.class);
    private String resource = "com.kingdee.eas.mobile.client.SmsResource";
    private String msgresource = "com.kingdee.eas.mobile.msg.client.SmsResource";
    protected IUIWindow currOrgTreeDialog;
    private MessageInputUtils miu = new MessageInputUtils();
    Map ctx = new HashMap();
    private BasReleaseInfo receiverInfo = null;
    private static final File settingPropertyFile = new File(new StringBuffer().append(System.getProperty("easclient.root")).append(File.separator).append("SendMsgUISetting.properties").toString());

    public SendMsgUI() throws Exception {
        this.getUIContext().put("receivers", "");
        this.getUIContext().put("checkLicense", "true");
        String temp = "";
        if (SysContext.getSysContext().getCurrentCtrlUnit() != null) {
            CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            String cuId = cuInfo.getId().toString();
            IChargeCompany iChargeCompany = ChargeCompanyFactory.getRemoteInstance();
            ChargeCompanyInfo chargeComInfo = iChargeCompany.getChargeCompanyInfoByCU((IObjectPK)new ObjectUuidPK(cuId));
            String countto = EASResource.getString((String)this.resource, (String)"count.to");
            temp = chargeComInfo != null ? countto + chargeComInfo.getCompany().getName() + ")" : countto + cuInfo.getName() + ")";
        }
        String lable = this.kDLabel2.getText();
        String newLable = lable + temp;
        this.kDLabel2.setText(newLable);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.receiverInfo == null) {
            this.receiverInfo = new BasReleaseInfo();
        }
        this.txtReceiver.setEnabled(true);
        this.txtReceiver.setEditable(true);
        this.miu.initData(this.txtReceiver, this.receiverInfo);
        boolean isSuppTelNo = this.isSMSSupportInputTelNo();
        this.miu.setUserPhoneOrMail(isSuppTelNo);
        this.loadSetting();
        this.txtContent.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int contentLength = SendMsgUI.this.txtContent.getText().length();
                String lable = SendMsgUI.this.msgLabel.getText();
                String newLable = lable.substring(0, lable.indexOf("[") + 1) + contentLength + lable.substring(lable.indexOf("]"), lable.length());
                SendMsgUI.this.msgLabel.setText(newLable);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        String predefinedContent = (String)this.getUIContext().get(PREDEFINED_CONTENT);
        if (!StringUtils.isEmpty((String)predefinedContent)) {
            this.txtContent.setText(predefinedContent);
            int contentLength = this.txtContent.getText().length();
            String lable = this.msgLabel.getText();
            String newLable = lable.substring(0, lable.indexOf("[") + 1) + contentLength + lable.substring(lable.indexOf("]"), lable.length());
            this.msgLabel.setText(newLable);
        }
        this.btnSendMsg.setIcon(EASResource.getIcon((String)"imgTbtn_send"));
        this.kDLabel1.setVisible(false);
        this.chkReceiverNumber.setVisible(false);
        this.kDCheckBox2.setVisible(false);
        this.setSize(500, 325);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.txtReceiver.requestFocus();
    }

    @Override
    public void actionSendMsg_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtReceiver.getText()) || StringUtils.isEmpty((String)this.txtReceiver.getText().trim())) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"mailrecnotnull"));
            this.txtReceiver.requestFocus();
            return;
        }
        String content = this.txtContent.getText();
        if (StringUtils.isEmpty((String)content)) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"msg_content_not_null"));
            this.txtContent.requestFocus();
            return;
        }
        if ((content = content.trim()).length() > 1000) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"mobile.msg.length.warn"));
            return;
        }
        IMsgFacade iMsgFacade = MsgFacadeFactory.getRemoteInstance();
        Set set = ReceiversFacadeFactory.getRemoteInstance().getHaveNoPhone(this.receiverInfo);
        Object[] ob = null;
        if (set != null) {
            ob = set.toArray();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ob.length; ++i) {
            if (ob[i] == null) continue;
            if (i == 0) {
                sb.append(ob[i]).append(", ");
                continue;
            }
            if (i == ob.length) {
                sb.append(ob[i]).append(".");
                continue;
            }
            sb.append(ob[i]).append(", ");
        }
        String nonePhoneNumberPerson = sb.toString();
        if (sb.lastIndexOf(", ") != -1) {
            nonePhoneNumberPerson = sb.substring(0, sb.lastIndexOf(", "));
        }
        if (!nonePhoneNumberPerson.equals("") && MsgBox.showConfirm2((Component)((Object)this), (String)(EASResource.getString((String)this.resource, (String)"receivers_notcell") + " " + nonePhoneNumberPerson + EASResource.getString((String)this.resource, (String)"send.confirm"))) != 0) {
            return;
        }
        try {
            boolean isCancelSendMsg = false;
            Set tempSet = ReceiversFacadeFactory.getRemoteInstance().getPhoneNumberByReleaseInfo(this.receiverInfo);
            Set phoneSet = this.miu.getPhoneNumberOrMail();
            phoneSet.addAll(tempSet);
            if (phoneSet.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"nonePhone"));
                return;
            }
            if (this.isLimitSendCount()) {
                int sengCount = (content.length() - 1) / 70 + 1;
                int sendCountUser = phoneSet.size();
                int sendCount = sendCountUser * sengCount;
                IMobileMessageAssign iMobile = MobileMessageAssignFactory.getRemoteInstance();
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                int sendedCount = iMobile.getSendedCountByUserId(userId, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                int cansendCount = iMobile.canSendCount(userId, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                int temp = cansendCount - sendedCount;
                if (temp < 0) {
                    temp = 0;
                }
                String msg = EASResource.getString((String)this.msgresource, (String)"thismessagewillsend") + sendCountUser + EASResource.getString((String)this.msgresource, (String)"numbersendmessage") + sendCount + EASResource.getString((String)this.msgresource, (String)"sending") + temp + EASResource.getString((String)this.msgresource, (String)"howmessage");
                if (sendCount + sendedCount > cansendCount) {
                    msg = msg + EASResource.getString((String)this.msgresource, (String)"senderror");
                    MsgBox.showInfo((String)msg);
                    return;
                }
                if (MsgBox.showConfirm2((Component)((Object)this), (String)msg) == 2) {
                    isCancelSendMsg = true;
                }
            }
            if (isCancelSendMsg) {
                return;
            }
            SendMessageParamInfo paramInfo = new SendMessageParamInfo();
            paramInfo.setAppendCompanyName(this.chkAppendCompanyName.isSelected());
            paramInfo.setAppendNumber(true);
            paramInfo.setAppendPersonName(true);
            paramInfo.setAppendRevert(this.chkAppendRevert.isSelected());
            paramInfo.setAppendUserName(this.chkAppendUserName.isSelected());
            paramInfo.setContent(content);
            paramInfo.setPhoneNumber(phoneSet);
            paramInfo.setReceiver("");
            paramInfo.setCanback(this.backkDCheckBox.isSelected());
            if (iMsgFacade.sendMsg(paramInfo)) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"send_success"));
                this.getUIWindow().close();
            }
        }
        catch (EASBizException ex) {
            if (this.isShowNoConnection()) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"connection_error"));
            }
            MsgBox.showInfo((String)EASResource.getString((String)this.msgresource, (String)"messagesending"));
        }
    }

    private boolean isShowNoConnection() {
        boolean isShow = true;
        try {
            String value = ParamManager.getParamValue(null, null, (String)"isShowNoConnection");
            if (StringUtils.isEmpty((String)value)) {
                value = "true";
            }
            isShow = Boolean.valueOf(value);
        }
        catch (Exception e) {
            logger.error((Object)("get param isShowNoConnection error:" + e));
        }
        return isShow;
    }

    @Override
    public void actionSelectReceiver_actionPerformed(ActionEvent e) throws Exception {
        this.miu.showReceiverUI((Object)this);
    }

    public void loadRcrAndRcr_sec() {
        String receivers = this.txtReceiver.getText();
        if (!receivers.equals("")) {
            String subStr = receivers.substring(receivers.length() - 1);
            if (subStr.equals(",")) {
                this.txtReceiver.setText(receivers + this.getUIContext().get("receivers").toString());
            } else {
                this.txtReceiver.setText(receivers + "," + this.getUIContext().get("receivers").toString());
            }
        } else {
            this.txtReceiver.setText(this.getUIContext().get("receivers").toString());
        }
    }

    private boolean isLimitSendCount() {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            String paramValue = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"MobileSendLimit");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d6\u5f97MobileSendLimit\u53c2\u6570\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    private void loadSetting() throws Exception {
        if (settingPropertyFile.exists()) {
            Properties props = new Properties();
            props.load(new FileInputStream(settingPropertyFile));
            String userKey = this.getPathStrFromObjID(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            boolean canback = false;
            if (props.containsKey(userKey + "canback")) {
                canback = Boolean.valueOf(props.getProperty(userKey + "canback"));
            }
            this.backkDCheckBox.setSelected(canback);
            boolean appendrevert = false;
            if (props.containsKey(userKey + "appendrevert")) {
                appendrevert = Boolean.valueOf(props.getProperty(userKey + "appendrevert"));
            }
            this.chkAppendRevert.setSelected(appendrevert);
            boolean appendusername = false;
            if (props.containsKey(userKey + "appendusername")) {
                appendusername = Boolean.valueOf(props.getProperty(userKey + "appendusername"));
            }
            this.chkAppendUserName.setSelected(appendusername);
            boolean appendcompanyname = false;
            if (props.containsKey(userKey + "appendcompanyname")) {
                appendcompanyname = Boolean.valueOf(props.getProperty(userKey + "appendcompanyname"));
            }
            this.chkAppendCompanyName.setSelected(appendcompanyname);
            boolean appendnumber = false;
            if (props.containsKey(userKey + "appendnumber")) {
                appendnumber = Boolean.valueOf(props.getProperty(userKey + "appendnumber"));
            }
            this.chkReceiverNumber.setSelected(appendnumber);
            boolean appendpersonname = false;
            if (props.containsKey(userKey + "appendpersonname")) {
                appendpersonname = Boolean.valueOf(props.getProperty(userKey + "appendpersonname"));
            }
            this.kDCheckBox2.setSelected(appendpersonname);
        }
    }

    private void storeSetting() throws Exception {
        Properties props = new Properties();
        if (settingPropertyFile.exists()) {
            props.load(new FileInputStream(settingPropertyFile));
        }
        String userKey = this.getPathStrFromObjID(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        props.setProperty(userKey + "canback", new Boolean(this.backkDCheckBox.isSelected()).toString());
        props.setProperty(userKey + "appendrevert", new Boolean(this.chkAppendRevert.isSelected()).toString());
        props.setProperty(userKey + "appendusername", new Boolean(this.chkAppendUserName.isSelected()).toString());
        props.setProperty(userKey + "appendcompanyname", new Boolean(this.chkAppendCompanyName.isSelected()).toString());
        props.setProperty(userKey + "appendnumber", new Boolean(this.chkReceiverNumber.isSelected()).toString());
        props.setProperty(userKey + "appendpersonname", new Boolean(this.kDCheckBox2.isSelected()).toString());
        props.store(new FileOutputStream(settingPropertyFile), "");
    }

    private String getPathStrFromObjID(String objID) {
        return objID.replace('/', '-').replace('=', '_').replace('+', '$');
    }

    @Override
    protected void backkDCheckBox_itemStateChanged(ItemEvent e) throws Exception {
        if (this.backkDCheckBox.isSelected()) {
            this.chkAppendRevert.setText(EASResource.getString((String)this.msgresource, (String)"kehuifu"));
            this.chkAppendRevert.setToolTipText(EASResource.getString((String)this.msgresource, (String)"kehuifu"));
        } else {
            this.chkAppendRevert.setText(EASResource.getString((String)this.msgresource, (String)"bukehuifu"));
            this.chkAppendRevert.setToolTipText(EASResource.getString((String)this.msgresource, (String)"bukehuifu"));
        }
    }

    public boolean destroyWindow() {
        try {
            this.storeSetting();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return super.destroyWindow();
    }

    private boolean isSMSSupportInputTelNo() {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            String paramValue = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"SMSSupportInputTelNo");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d6\u5f97SMSSupportInputTelNo\u53c2\u6570\u51fa\u9519", (Throwable)e);
            return false;
        }
    }
}

