/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mobile.IServerEngine;
import com.kingdee.eas.mobile.ServerEnginefactory;
import com.kingdee.eas.mobile.UserInfo;
import com.kingdee.eas.mobile.msg.BizFunction;
import com.kingdee.eas.mobile.msg.BizModuleConfig;
import com.kingdee.eas.mobile.msg.BizModuleItem;
import com.kingdee.eas.mobile.msg.IUserConfig;
import com.kingdee.eas.mobile.msg.UserCommandInfo;
import com.kingdee.eas.mobile.msg.UserConfigClient;
import com.kingdee.eas.mobile.msg.client.AbstractUserConfigUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class UserConfigUI
extends AbstractUserConfigUI
implements ChangeListener {
    private static final String RESCLASS = "com.kingdee.eas.mobile.msg.client.UserConfigUIResources";
    private static final Logger logger = Logger.getLogger(UserConfigUI.class);
    private static final String[] SHORTCUTS_VALUE = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final KDComboBox SHORTCUTS = new KDComboBox((Object[])SHORTCUTS_VALUE);
    private IUserConfig userConfig;
    private IServerEngine serverEngine;
    private String userid;
    private UserConfigClient userClient = new UserConfigClient();
    private ServerEnginefactory serverClient = new ServerEnginefactory();
    private String[] localSelect;
    UserInfo userinfo;
    BizModuleConfig bizConfig;
    UserCommandInfo[] commandInfo;
    private ResourceBundleHelper uiResHelper;

    public UserConfigUI() throws Exception {
        this.saveBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    UserConfigUI.this.saveBt_actionPerformed(arg0);
                }
                catch (Exception e) {
                    UserConfigUI.this.handUIException(e);
                }
            }
        });
        this.resetBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    UserConfigUI.this.resetBt_actionPerformed(arg0);
                }
                catch (Exception e) {
                    UserConfigUI.this.handUIException(e);
                }
            }
        });
        this.kDTable1.getIndexColumn().getStyleAttributes().setHided(true);
        try {
            this.initUI();
            this.initOrmRpcObject();
            this.loadConfig();
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initUI() {
        this.userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveBt.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.resetBt.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.uiResHelper = new ResourceBundleHelper(RESCLASS);
        this.localComboBox.removeAllItems();
        this.localComboBox.addItem((Object)this.uiResHelper.getString("local_us"));
        this.localComboBox.addItem((Object)this.uiResHelper.getString("local_zh_cn"));
        this.localComboBox.addItem((Object)this.uiResHelper.getString("local_zh_tw"));
        this.kDTable1.checkParsed();
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)SHORTCUTS);
        this.kDTable1.getColumn(0).setEditor((ICellEditor)cellEditor);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void saveBt_actionPerformed(ActionEvent e) throws Exception {
        ControlUtilities.checkFocusAndCommit();
        if (this.userinfo != null) {
            if (!this.validateShortCut()) {
                String s = this.getResource("error_shortCut");
                MsgBox.showError((String)s);
                return;
            }
            this.userinfo.setEmail(this.txtEmail.getText());
            this.userinfo.setMobile(this.txtMobile.getText());
            this.userinfo.setRtx(this.txtRtx.getText());
            int commonMode = 0;
            int importantMode = 0;
            if (this.Email0.isSelected()) {
                ++commonMode;
            }
            if (this.mobile0.isSelected()) {
                commonMode += 4;
            }
            if (this.rtx0.isSelected()) {
                commonMode += 2;
            }
            if (this.Email1.isSelected()) {
                ++importantMode;
            }
            if (this.mobile1.isSelected()) {
                importantMode += 4;
            }
            if (this.rtx1.isSelected()) {
                importantMode += 2;
            }
            this.userinfo.setCommonMode(commonMode);
            this.userinfo.setImportantMode(importantMode);
            this.userinfo.setLocale(this.localComboBox.getSelectedIndex());
            ArrayList<UserCommandInfo> list = new ArrayList<UserCommandInfo>();
            for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
                IRow irow = this.kDTable1.getRow(i);
                Object obj = irow.getCell(0).getValue();
                if (obj == null) continue;
                char c = ((String)obj).trim().charAt(0);
                UserCommandInfo command = new UserCommandInfo();
                command.setShortCut(c);
                command.setAppend((String)irow.getCell(1).getValue());
                command.setClassName(((ModuleItem)irow.getCell(2).getValue()).getClassName());
                command.setFunctionNum(((FunctionItem)irow.getCell((int)3).getValue()).bizKey);
                list.add(command);
            }
            UserCommandInfo[] shortCuts = new UserCommandInfo[list.size()];
            list.toArray(shortCuts);
            this.userConfig.saveUser(this.userinfo, shortCuts);
            this.showMsg("saveOK");
        } else {
            this.alert("NoPerson");
        }
    }

    protected void resetBt_actionPerformed(ActionEvent e) throws Exception {
        this.loadConfig();
        this.init();
    }

    protected void exitBt_actionPerformed(ActionEvent e) throws Exception {
        this.onExitClick();
    }

    private void initOrmRpcObject() throws Exception {
        String url = UIConfig.getUrl();
        this.serverClient.setHostAddress(url);
        this.userClient.setHostAddress(url);
        this.serverEngine = this.serverClient.getService(url);
        this.userConfig = this.userClient.getUserConfig(url);
        logger.debug((Object)("userid:" + this.userid));
    }

    private void loadConfig() throws Exception {
        this.userinfo = this.userConfig.getUserInfo(this.userid);
        this.commandInfo = this.userConfig.getUserCommands(this.userid);
    }

    protected void init() throws Exception {
        if (this.userinfo.getPersonid() == null || this.userinfo.getPersonid().trim().length() == 0) {
            this.txtEmail.setEnabled(false);
            this.txtMobile.setEnabled(false);
            this.txtRtx.setEnabled(false);
            this.localComboBox.setEnabled(false);
            this.saveBt.setEnabled(false);
            this.resetBt.setEnabled(false);
            this.alert("noPerson");
        } else {
            this.txtEmail.setText(this.userinfo.getEmail());
            this.txtMobile.setText(this.userinfo.getMobile());
            this.txtRtx.setText(this.userinfo.getRtx());
            this.localComboBox.setSelectedIndex(this.userinfo.getLocale());
            boolean byCommonEmail = UserInfo.isByEmail(this.userinfo.getCommonMode());
            boolean byCommonMobile = UserInfo.isByMobile(this.userinfo.getCommonMode());
            boolean byCommonRtx = UserInfo.isByRtx(this.userinfo.getCommonMode());
            this.Email0.setSelected(byCommonEmail);
            this.mobile0.setSelected(byCommonMobile);
            this.rtx0.setSelected(byCommonRtx);
            boolean byImportantEmail = UserInfo.isByEmail(this.userinfo.getImportantMode());
            boolean byImportantMobile = UserInfo.isByMobile(this.userinfo.getImportantMode());
            boolean byImportantRtx = UserInfo.isByRtx(this.userinfo.getImportantMode());
            this.Email1.setSelected(byImportantEmail);
            this.mobile1.setSelected(byImportantMobile);
            this.rtx1.setSelected(byImportantRtx);
            this.saveBt.setEnabled(true);
            this.resetBt.setEnabled(true);
        }
        this.initBizConfig();
    }

    protected void initBizConfig() throws Exception {
        String url = UIConfig.getUrl();
        this.serverClient.setHostAddress(url);
        this.serverEngine = this.serverClient.getService(url);
        this.bizConfig = this.serverEngine.loadConfig();
        this.Email0.setEnabled(false);
        this.Email1.setEnabled(false);
        this.rtx0.setEnabled(false);
        this.rtx1.setEnabled(false);
        this.mobile0.setEnabled(false);
        this.mobile1.setEnabled(false);
        if (this.bizConfig.isEmailOK()) {
            this.Email0.setEnabled(true);
            this.Email1.setEnabled(true);
        }
        if (this.bizConfig.isMobileOK()) {
            this.mobile0.setEnabled(true);
            this.mobile1.setEnabled(true);
        }
        if (this.bizConfig.isRtxOK()) {
            this.rtx0.setEnabled(true);
            this.rtx1.setEnabled(true);
        }
        ArrayList configedModules = this.bizConfig.getConfigedModules();
        this.kDTable1.removeRows();
        for (int i = 0; i < configedModules.size(); ++i) {
            BizModuleItem item = (BizModuleItem)configedModules.get(i);
            BizModuleItem fullWrapInfo = this.bizConfig.getModule(item.getClassName());
            fullWrapInfo.setBizKey(item.getBizKey());
            logger.debug((Object)("" + item.getClassName()));
            this.initBizConfig(this.commandInfo, fullWrapInfo);
        }
    }

    protected void initBizConfig(UserCommandInfo[] info, BizModuleItem item) {
        IRow Irow = this.kDTable1.addRow();
        for (int i = 0; info != null && i < info.length; ++i) {
            if (!item.getClassName().equals(info[i].getClassName()) || item.getBizKey() != info[i].getFunctionNum()) continue;
            Irow.getCell(0).setValue((Object)String.valueOf(info[i].getShortCut()));
            Irow.getCell(1).setValue((Object)info[i].getAppend());
            break;
        }
        Irow.getCell(2).setValue((Object)new ModuleItem(item.getClassName(), item.getModuleName()));
        Irow.getCell(2).getStyleAttributes().setLocked(true);
        Irow.getCell(3).setValue((Object)new FunctionItem(item.getBizKey(), BizFunction.getBizDescription(item.getBizFunctions(), item.getBizKey(), SysContext.getSysContext().getLocale())));
        Irow.getCell(3).getStyleAttributes().setLocked(true);
    }

    private boolean validateShortCut() {
        boolean success = false;
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            IRow irow = this.kDTable1.getRow(i);
            String obj = (String)irow.getCell(0).getValue();
            if (obj == null || obj.trim().length() <= 0) continue;
            if (map.containsKey(obj)) {
                return false;
            }
            map.put(obj, obj);
        }
        return true;
    }

    private void onExitClick() {
        this.getUIWindow().close();
    }

    private void alert(String key) {
        String s = this.getResource(key);
        MsgBox.showError((String)s);
    }

    private void showMsg(String key) {
        String s = this.getResource(key);
        MsgBox.showInfo((String)s);
    }

    private String getResource(String itemKey) {
        String resClassName = RESCLASS;
        return EASResource.getString((String)resClassName, (String)itemKey);
    }

    public void doLayout() {
        super.doLayout();
        int width = this.kDContainer1.getWidth();
        int columnNums = this.kDTable1.getColumnCount();
        for (int i = 0; i < columnNums; ++i) {
            int perWidth = width / columnNums;
            this.kDTable1.getColumn(i).setWidth(perWidth);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.Email0 && this.Email0.isSelected()) {
            this.Email1.setSelected(false);
        }
        if (e.getSource() == this.Email1 && this.Email1.isSelected()) {
            this.Email0.setSelected(false);
        }
        if (e.getSource() == this.rtx1 && this.rtx1.isSelected()) {
            this.rtx0.setSelected(false);
        }
        if (e.getSource() == this.rtx0 && this.rtx0.isSelected()) {
            this.rtx1.setSelected(false);
        }
        if (e.getSource() == this.mobile0 && this.mobile0.isSelected()) {
            this.mobile1.setSelected(false);
        }
        if (e.getSource() == this.mobile1 && this.mobile1.isSelected()) {
            this.mobile0.setSelected(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private class FunctionItem {
        int bizKey = -1;
        String description;

        FunctionItem(int bizKey, String description) {
            this.bizKey = bizKey;
            this.description = description;
        }

        public FunctionItem(BizFunction func) {
            this.bizKey = func.getBizKey();
            this.description = func.getDescription(SysContext.getSysContext().getLocale());
        }

        public String toString() {
            return this.description;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof FunctionItem) {
                FunctionItem item = (FunctionItem)obj;
                if (item.bizKey == this.bizKey) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ModuleItem {
        String className;
        String moduleName;

        public ModuleItem(String className, String moduleName) {
            this.className = className;
            this.moduleName = moduleName;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ModuleItem) {
                ModuleItem item = (ModuleItem)obj;
                if (this.className != null && this.className.equals(item.getClassName())) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.moduleName;
        }
    }
}

