/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.util;

import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.util.PropertiesUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class MailServerConfigPropUtil {
    private static Logger logger = Logger.getLogger(MailServerConfigPropUtil.class);
    private static Properties prop = null;
    private static final String CONFIG_NAME = "mailServerConfig.properties";
    public static final String SMTP_HOST = "mail.smtp.host";
    public static final String SMTP_PORT = "mail.smtp.port";
    public static final String MAIL_FROM_ACCOUNT = "mail.from.account";
    public static final String MAIL_FROM_USERNAME = "mail.from.username";
    public static final String USERNAME = "mail.login.username";
    public static final String PASSWORD = "mail.login.password";
    public static final String SSL_ENABLE = "mail.sslEnable";
    public static final String TLS_ENABLE = "mail.tlsEnable";
    public static final String SMTP_AUTH_ENABLE = "mail.smtpAuthEnable";
    public static final String SMTP_TLS2_ENABLE = "mail.tls2Enable";
    public static final String FORCE_ENABLE_4_OLD_GATEWAY = "mail.forceEnable4OldGateway";

    public static Properties getProperties() throws IOException, ConfigurationException {
        String configFilePath = PropertiesUtil.getDefaultProFullName((String)CONFIG_NAME);
        File configFile = new File(configFilePath);
        if (prop == null) {
            prop = new Properties();
            FileInputStream fin = null;
            try {
                MailServerConfigPropUtil.createPropertiesFileIfNotExist(configFile);
                fin = new FileInputStream(configFile);
                PropertiesConfiguration config = new PropertiesConfiguration();
                config.load((InputStream)fin, "UTF-8");
                prop.setProperty(SMTP_HOST, config.getString(SMTP_HOST));
                prop.setProperty(SMTP_PORT, config.getString(SMTP_PORT));
                prop.setProperty(MAIL_FROM_ACCOUNT, config.getString(MAIL_FROM_ACCOUNT));
                prop.setProperty(MAIL_FROM_USERNAME, config.getString(MAIL_FROM_USERNAME));
                prop.setProperty(USERNAME, config.getString(USERNAME));
                prop.setProperty(PASSWORD, config.getString(PASSWORD));
                String sslEnable = config.getString(SSL_ENABLE);
                prop.setProperty(SSL_ENABLE, sslEnable == null ? "false" : sslEnable);
                String tlsEnable = config.getString(TLS_ENABLE);
                prop.setProperty(TLS_ENABLE, tlsEnable == null ? "false" : tlsEnable);
                String smtpAuthEnable = config.getString(SMTP_AUTH_ENABLE);
                prop.setProperty(SMTP_AUTH_ENABLE, smtpAuthEnable == null ? "true" : smtpAuthEnable);
                prop.setProperty(FORCE_ENABLE_4_OLD_GATEWAY, config.getString(FORCE_ENABLE_4_OLD_GATEWAY));
                String tls2Enable = config.getString(SMTP_TLS2_ENABLE);
                prop.setProperty(SMTP_TLS2_ENABLE, tls2Enable == null ? "false" : tls2Enable);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                prop = null;
                throw e;
            }
            catch (IOException e) {
                e.printStackTrace();
                prop = null;
                throw e;
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("MailServerConfigPropUtil- fin.close() IOException:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (prop != null && prop.getProperty(PASSWORD) != null && prop.getProperty(PASSWORD).startsWith("ksqle")) {
            prop.setProperty(PASSWORD, KSqlUtil.decodePassword((String)prop.getProperty(PASSWORD)));
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createPropertiesFileIfNotExist(File configFile) throws IOException, ConfigurationException {
        FileOutputStream fos = null;
        FileInputStream fin = null;
        try {
            PropertiesConfiguration config;
            if (!configFile.exists()) {
                configFile.createNewFile();
                config = new PropertiesConfiguration();
                config.setHeader("MAIL SERVER ACCOUNT CONFIGURATION.");
                config.setProperty(SMTP_HOST, (Object)"192.168.14.8");
                config.setProperty(SMTP_PORT, (Object)"25");
                config.setProperty(MAIL_FROM_ACCOUNT, (Object)"bostest@kdsv.kingdee.com");
                config.setProperty(MAIL_FROM_USERNAME, (Object)"BOS\u6d4b\u8bd5");
                config.setProperty(USERNAME, (Object)"bostest");
                config.setProperty(PASSWORD, (Object)"kingdee@2011");
                config.setProperty(SSL_ENABLE, (Object)"false");
                config.setProperty(TLS_ENABLE, (Object)"false");
                config.setProperty(SMTP_AUTH_ENABLE, (Object)"true");
                config.setProperty(FORCE_ENABLE_4_OLD_GATEWAY, (Object)"false");
                config.setProperty(SMTP_TLS2_ENABLE, (Object)"false");
                fos = new FileOutputStream(configFile);
                config.save((OutputStream)fos, "UTF-8");
            } else {
                String tls2;
                String smtp;
                String tls;
                fin = new FileInputStream(configFile);
                config = new PropertiesConfiguration();
                PropertiesConfiguration configNew = new PropertiesConfiguration();
                config.load((InputStream)fin, "UTF-8");
                String ssl = config.getString(SSL_ENABLE);
                boolean flag = false;
                if (StringUtils.isEmpty((String)ssl)) {
                    configNew.setProperty(SSL_ENABLE, (Object)"false");
                    flag = true;
                }
                if (StringUtils.isEmpty((String)(tls = config.getString(TLS_ENABLE)))) {
                    configNew.setProperty(TLS_ENABLE, (Object)"false");
                    flag = true;
                }
                if (StringUtils.isEmpty((String)(smtp = config.getString(SMTP_AUTH_ENABLE)))) {
                    configNew.setProperty(SMTP_AUTH_ENABLE, (Object)"true");
                    flag = true;
                }
                if (StringUtils.isEmpty((String)(tls2 = config.getString(SMTP_TLS2_ENABLE)))) {
                    configNew.setProperty(SMTP_TLS2_ENABLE, (Object)"false");
                    flag = true;
                }
                if (flag) {
                    fos = new FileOutputStream(configFile, true);
                    configNew.save((OutputStream)fos, "UTF-8");
                }
            }
        }
        catch (ConfigurationException e) {
            logger.error((Object)("MailServerConfigPropUtil-ConfigurationException:" + e.getMessage()));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("MailServerConfigPropUtil-FileNotFoundException:" + e.getMessage()));
        }
        catch (IOException e) {
            logger.error((Object)("MailServerConfigPropUtil-IOException:" + e.getMessage()));
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("MailServerConfigPropUtil-IOException:" + e.getMessage()));
            }
        }
    }

    public static void saveProperties(Properties properties) throws IOException, ConfigurationException {
        String configFilePath = PropertiesUtil.getDefaultProFullName((String)CONFIG_NAME);
        File configFile = new File(configFilePath);
        MailServerConfigPropUtil.createPropertiesFileIfNotExist(configFile);
        PropertiesConfiguration config = new PropertiesConfiguration(configFile.getPath());
        config.setHeader("MAIL SERVER ACCOUNT CONFIGURATION.");
        config.setProperty(SMTP_HOST, (Object)properties.getProperty(SMTP_HOST));
        config.setProperty(SMTP_PORT, (Object)properties.getProperty(SMTP_PORT));
        config.setProperty(MAIL_FROM_ACCOUNT, (Object)properties.getProperty(MAIL_FROM_ACCOUNT));
        config.setProperty(MAIL_FROM_USERNAME, (Object)properties.getProperty(MAIL_FROM_USERNAME));
        config.setProperty(USERNAME, (Object)properties.getProperty(USERNAME));
        if (!StringUtils.isEmpty((String)properties.getProperty(PASSWORD)) && !properties.getProperty(PASSWORD).startsWith("ksqle")) {
            String pwd = KSqlUtil.encodePassword((String)properties.getProperty(PASSWORD));
            config.setProperty(PASSWORD, (Object)pwd);
        }
        config.setProperty(SSL_ENABLE, (Object)properties.getProperty(SSL_ENABLE));
        config.setProperty(TLS_ENABLE, (Object)properties.getProperty(TLS_ENABLE));
        config.setProperty(SMTP_AUTH_ENABLE, (Object)properties.getProperty(SMTP_AUTH_ENABLE));
        config.setProperty(FORCE_ENABLE_4_OLD_GATEWAY, (Object)properties.getProperty(FORCE_ENABLE_4_OLD_GATEWAY));
        config.setProperty(SMTP_TLS2_ENABLE, (Object)properties.getProperty(SMTP_TLS2_ENABLE));
        FileOutputStream fos = new FileOutputStream(configFile);
        config.save((OutputStream)fos, "UTF-8");
        fos.close();
        prop = properties;
    }

    public static String getProperty(String key) {
        Properties prop = null;
        try {
            prop = MailServerConfigPropUtil.getProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return prop == null ? null : prop.getProperty(key);
    }

    public static String getSmtpHost() {
        return MailServerConfigPropUtil.getProperty(SMTP_HOST);
    }

    public static String getSmtpPort() {
        return MailServerConfigPropUtil.getProperty(SMTP_PORT);
    }

    public static String getMailFromAccount() {
        return MailServerConfigPropUtil.getProperty(MAIL_FROM_ACCOUNT);
    }

    public static String getMailFromUsername() {
        return MailServerConfigPropUtil.getProperty(MAIL_FROM_USERNAME);
    }

    public static String getUsername() {
        return MailServerConfigPropUtil.getProperty(USERNAME);
    }

    public static String getPassword() {
        String pwd = MailServerConfigPropUtil.getProperty(PASSWORD);
        if (!StringUtils.isEmpty((String)pwd) && pwd.startsWith("ksqle")) {
            pwd = KSqlUtil.decodePassword((String)pwd);
        }
        return pwd;
    }

    public static String getSslEnable() {
        return MailServerConfigPropUtil.getProperty(SSL_ENABLE);
    }

    public static String getTlsEnable() {
        return MailServerConfigPropUtil.getProperty(TLS_ENABLE);
    }

    public static String getTls2Enable() {
        return MailServerConfigPropUtil.getProperty(SMTP_TLS2_ENABLE);
    }

    public static String getForceEnable4OldGateway() {
        return MailServerConfigPropUtil.getProperty(FORCE_ENABLE_4_OLD_GATEWAY);
    }

    public static boolean isForceEnable4OldGateway() {
        return "true".equalsIgnoreCase(MailServerConfigPropUtil.getProperty(FORCE_ENABLE_4_OLD_GATEWAY));
    }

    public static void main(String[] args) throws IOException, ConfigurationException {
    }

    public static String getSmtpAuthEnable() {
        return MailServerConfigPropUtil.getProperty(SMTP_AUTH_ENABLE);
    }

    public static void syncClusterConfig(Properties properties, Map map) throws IOException, ConfigurationException {
        String configFilePath = PropertiesUtil.getDefaultProFullName((String)CONFIG_NAME);
        File configFile = new File(configFilePath);
        MailServerConfigPropUtil.createPropertiesFileIfNotExist(configFile);
        PropertiesConfiguration config = new PropertiesConfiguration(configFile.getPath());
        config.setHeader("MAIL SERVER ACCOUNT CONFIGURATION.");
        config.setProperty(SMTP_HOST, (Object)properties.getProperty(SMTP_HOST));
        config.setProperty(SMTP_PORT, (Object)properties.getProperty(SMTP_PORT));
        config.setProperty(MAIL_FROM_ACCOUNT, (Object)properties.getProperty(MAIL_FROM_ACCOUNT));
        config.setProperty(MAIL_FROM_USERNAME, (Object)properties.getProperty(MAIL_FROM_USERNAME));
        config.setProperty(USERNAME, (Object)properties.getProperty(USERNAME));
        config.setProperty(PASSWORD, (Object)properties.getProperty(PASSWORD));
        config.setProperty(SSL_ENABLE, (Object)properties.getProperty(SSL_ENABLE));
        config.setProperty(TLS_ENABLE, (Object)properties.getProperty(TLS_ENABLE));
        config.setProperty(SMTP_AUTH_ENABLE, (Object)properties.getProperty(SMTP_AUTH_ENABLE));
        config.setProperty(FORCE_ENABLE_4_OLD_GATEWAY, (Object)properties.getProperty(FORCE_ENABLE_4_OLD_GATEWAY));
        config.setProperty(SMTP_TLS2_ENABLE, (Object)properties.getProperty(SMTP_TLS2_ENABLE));
        FileOutputStream fos = new FileOutputStream(configFile);
        config.save((OutputStream)fos, "UTF-8");
        fos.close();
        prop = properties;
    }
}

