/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.PermissionInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.PermissionKind;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionBO {
    private static Logger log = LogUtil.getPackageLogger(PermissionBO.class);
    private static String user_org_role_report_sql = "select p.FReportID, p.fpermission from T_RM_Permission p INNER JOIN T_RM_CustKsqlRpt r on p.FReportID = r.fid where p.FUserID = ? and p.FOrgID = ? and p.FReportID = ? union all select p.FReportID, p.fpermission from T_RM_Permission p INNER JOIN T_RM_CustKsqlRpt r on p.FReportID = r.fid where p.FUserID = ? and p.FOrgID is null and p.FReportID = ? union all select p.FReportID, p.fpermission from T_RM_Permission p INNER JOIN T_RM_CustKsqlRpt r on p.FReportID = r.fid INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid where uro.FUserID = ? and uro.FOrgID = ? and p.FReportID = ?";
    private static HashMap UserAllPermissionMap_Client = null;
    private static String oldUserId = "";
    private static String oldOrgId = "";

    public static final boolean isEmpty(Context ctx) {
        try {
            ArrayList lst = ExtDBUtil.getResultListBySql(ctx, "select top 1 * from T_RM_Permission", null);
            return lst.isEmpty();
        }
        catch (BOSException e) {
            return false;
        }
    }

    private static final boolean isLoginChange() {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (!userID.equals(oldUserId) || !orgID.equals(oldOrgId)) {
            oldUserId = userID;
            oldOrgId = orgID;
            return true;
        }
        return false;
    }

    public static final ArrayList getPerListByID(int type, String fid) throws BOSException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(String.valueOf(type));
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select p.FReportID, p.FPermission, ");
        sbSQL.append("r.Fname_").append(strLocal).append(" as reportname ");
        sbSQL.append("from T_RM_Permission p ");
        sbSQL.append("LEFT OUTER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid ");
        sbSQL.append("where FPermissionType = ?");
        switch (type) {
            case 0: {
                String[] arr = fid.split("\\\\");
                String userID = arr[0];
                String orgID = arr[1];
                queryValue.add(userID);
                queryValue.add(orgID);
                sbSQL.append(" and p.FUserID = ? and p.FOrgID = ?");
                break;
            }
            case 1: {
                sbSQL.append(" and p.FRoleID = ?");
                queryValue.add(fid);
                break;
            }
            case 2: {
                sbSQL.append(" and p.FUserID = ?");
                queryValue.add(fid);
            }
        }
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final String getPermissionWhere(int type, String fid, String reportID) {
        String where = " FPermissionType = " + type;
        switch (type) {
            case 0: {
                String[] arr = fid.split("\\\\");
                String userID = arr[0];
                String orgID = arr[1];
                where = where + " and FUserID = '" + userID + "' and FOrgID = '" + orgID + "' and FReportID = '" + reportID + "'";
                break;
            }
            case 1: {
                where = where + " and FRoleID = '" + fid + "' and FReportID = '" + reportID + "'";
                break;
            }
            case 2: {
                where = where + " and FUserID = '" + fid + "' and FReportID = '" + reportID + "'";
            }
        }
        return where;
    }

    public static final String getInsertSQL(int type, String fid, String reportID, String fpermission) {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into T_RM_Permission(FUserID, FOrgID, FRoleID, FReportID, FPermission, FPermissionType) values (");
        switch (type) {
            case 0: {
                String[] arr = fid.split("\\\\");
                String userID = arr[0];
                String orgID = arr[1];
                sb.append("'").append(userID).append("', '").append(orgID).append("', null, '").append(reportID).append("', '").append(fpermission).append("', ").append(type);
                break;
            }
            case 1: {
                sb.append("null, null, '").append(fid).append("', '").append(reportID).append("', '").append(fpermission).append("', ").append(type);
                break;
            }
            case 2: {
                sb.append("'").append(fid).append("', null, null, '").append(reportID).append("', '").append(fpermission).append("', ").append(type);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static final ArrayList getPerListByType(int type) throws BOSException {
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(String.valueOf(type));
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select p.FUserID, p.FOrgID, p.FRoleID, p.FReportID, p.FPermission, p.FPermissionType ");
        sbSQL.append("from T_RM_Permission p ");
        sbSQL.append("where FPermissionType = ?");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList viewPermissionByType(int type, String userID, String orgID, String roleID, String[] reportIDs) throws BOSException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        StringBuffer sbSQL = new StringBuffer();
        String orderBy = "";
        ArrayList<String> queryValue = new ArrayList<String>();
        switch (type) {
            case 0: {
                sbSQL.append("select p.FUserID, p.FOrgID, p.FReportID, p.FPermission, p.FPermissionType, ");
                sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
                sbSQL.append("r.Fname_").append(strLocal).append(" as reportname, ");
                sbSQL.append("u.Fname_").append(strLocal).append(" as username ");
                sbSQL.append("from T_RM_Permission p LEFT OUTER JOIN t_pm_user u on p.FUserID=u.fid ");
                sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on p.FOrgID=org.fid ");
                sbSQL.append("LEFT OUTER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid ");
                sbSQL.append("where p.FPermissionType = ? ");
                queryValue.add(String.valueOf(type));
                orderBy = " order by p.FUserID, p.FOrgID, p.FReportID ";
                break;
            }
            case 1: {
                sbSQL.append("select p.FRoleID, p.FReportID, p.FPermission, p.FPermissionType, ");
                sbSQL.append("role.Fname_").append(strLocal).append(" as rolename, ");
                sbSQL.append("r.Fname_").append(strLocal).append(" as reportname ");
                sbSQL.append("from T_RM_Permission p LEFT OUTER JOIN t_pm_role role on p.FRoleID=role.fid ");
                sbSQL.append("LEFT OUTER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid ");
                sbSQL.append("where p.FPermissionType = ? ");
                queryValue.add(String.valueOf(type));
                orderBy = " order by p.FRoleID, p.FReportID ";
                break;
            }
            case 2: {
                sbSQL.append("select p.FUserID, p.FReportID, p.FPermission, p.FPermissionType, ");
                sbSQL.append("r.Fname_").append(strLocal).append(" as reportname, ");
                sbSQL.append("u.Fname_").append(strLocal).append(" as username ");
                sbSQL.append("from T_RM_Permission p LEFT OUTER JOIN t_pm_user u on p.FUserID=u.fid ");
                sbSQL.append("LEFT OUTER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid ");
                sbSQL.append("where p.FPermissionType = ? ");
                queryValue.add(String.valueOf(type));
                orderBy = " order by p.FUserID, p.FReportID ";
                break;
            }
            case -1: {
                sbSQL.append("select p.FUserID, p.FOrgID, p.FRoleID, p.FReportID, p.FPermission, p.FPermissionType, ");
                sbSQL.append("role.Fname_").append(strLocal).append(" as rolename, ");
                sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
                sbSQL.append("r.Fname_").append(strLocal).append(" as reportname, ");
                sbSQL.append("u.Fname_").append(strLocal).append(" as username ");
                sbSQL.append("from T_RM_Permission p LEFT OUTER JOIN t_pm_user u on p.FUserID=u.fid ");
                sbSQL.append("LEFT OUTER JOIN t_pm_role role on p.FRoleID=role.fid ");
                sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on p.FOrgID=org.fid ");
                sbSQL.append("LEFT OUTER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid ");
                sbSQL.append("where 1=1 ");
                orderBy = " order by p.FUserID, p.FOrgID, p.FRoleID, p.FReportID ";
            }
        }
        if (null != userID) {
            sbSQL.append("and p.FUserID = ? ");
            queryValue.add(userID);
        }
        if (null != orgID) {
            sbSQL.append("and p.FOrgID = ? ");
            queryValue.add(orgID);
        }
        if (null != roleID) {
            sbSQL.append("and p.FRoleID = ? ");
            queryValue.add(roleID);
        }
        if (null != reportIDs) {
            sbSQL.append(" and p.FReportID in (");
            int size = reportIDs.length;
            for (int i = 0; i < size; ++i) {
                sbSQL.append("?");
                if (i < size - 1) {
                    sbSQL.append(",");
                }
                queryValue.add(reportIDs[i]);
            }
            sbSQL.append(") ");
        }
        String sql = sbSQL.toString() + orderBy;
        return ExtDBUtil.getResultListBySql(null, sql, queryValue);
    }

    public static final int viewPermissionCountByType(int type, String userID, String orgID, String roleID, String[] reportIDs) {
        StringBuffer sbSQL = new StringBuffer();
        ArrayList<String> queryValue = new ArrayList<String>();
        switch (type) {
            case -1: {
                sbSQL.append("select count(*) as total ");
                sbSQL.append("from T_RM_Permission p ");
                sbSQL.append("where 1=1 ");
                break;
            }
            default: {
                sbSQL.append("select count(*) as total ");
                sbSQL.append("from T_RM_Permission p ");
                sbSQL.append("where p.FPermissionType = ? ");
                queryValue.add(String.valueOf(type));
            }
        }
        if (null != userID) {
            sbSQL.append("and p.FUserID = ? ");
            queryValue.add(userID);
        }
        if (null != orgID) {
            sbSQL.append("and p.FOrgID = ? ");
            queryValue.add(orgID);
        }
        if (null != roleID) {
            sbSQL.append("and p.FRoleID = ? ");
            queryValue.add(roleID);
        }
        if (null != reportIDs) {
            sbSQL.append(" and p.FReportID in (");
            int size = reportIDs.length;
            for (int i = 0; i < size; ++i) {
                sbSQL.append("?");
                if (i < size - 1) {
                    sbSQL.append(",");
                }
                queryValue.add(reportIDs[i]);
            }
            sbSQL.append(") ");
        }
        try {
            HashMap map = ExtDBUtil.getResultMapBySql(null, sbSQL.toString(), queryValue);
            int total = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("total")));
            return total;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static final ArrayList getUserAllPermission(Context ctx, String userID, List orgIDList) throws BOSException {
        String orgID;
        StringBuffer sql1 = new StringBuffer();
        sql1.append("select p.FReportID, p.fpermission \n");
        sql1.append("from T_RM_Permission p INNER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid \n");
        sql1.append("where p.FUserID = ? and p.FOrgID in (");
        StringBuffer sql2 = new StringBuffer();
        sql2.append(") \n union all \n");
        sql2.append("select  p.FReportID, p.fpermission \n");
        sql2.append("from T_RM_Permission p INNER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid \n");
        sql2.append("where p.FUserID = ? and p.FOrgID is null \n");
        sql2.append("union all \n");
        sql2.append("select p.FReportID, p.fpermission \n");
        sql2.append("from T_RM_Permission p INNER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid \n");
        sql2.append("INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid \n");
        sql2.append("where uro.FUserID = ? and uro.FOrgID in ( ");
        StringBuffer sql3 = new StringBuffer(" )");
        HashSet<String> targetIdSet = new HashSet<String>();
        targetIdSet.addAll(orgIDList);
        String string = orgID = orgIDList.isEmpty() ? null : (String)orgIDList.get(0);
        if (null == ctx) {
            if (userID == null) {
                userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            }
            if (orgID == null) {
                orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            }
        } else {
            if (userID == null) {
                userID = ctx.getCaller().toString();
            }
            if (orgID == null) {
                orgID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            }
        }
        targetIdSet.add(orgID);
        StringBuffer orgSqlSub = new StringBuffer();
        int length = targetIdSet.size() - 1;
        for (int i = 0; i < length; ++i) {
            orgSqlSub.append("?,");
        }
        orgSqlSub.append("?");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(sql1.toString());
        sqlBuffer.append(orgSqlSub.toString());
        sqlBuffer.append(sql2.toString());
        sqlBuffer.append(orgSqlSub.toString());
        sqlBuffer.append(sql3.toString());
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userID);
        queryValue.addAll(targetIdSet);
        queryValue.add(userID);
        queryValue.add(userID);
        queryValue.addAll(targetIdSet);
        ArrayList listUserPermission = ExtDBUtil.getResultListBySql(ctx, sqlBuffer.toString(), queryValue);
        return listUserPermission;
    }

    public static final HashMap getUserAllPermissionCache(Context ctx, String userID, String orgID) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)orgID)) {
            idList.add(orgID);
        }
        if (null == ctx) {
            if (UserAllPermissionMap_Client == null) {
                UserAllPermissionMap_Client = new HashMap();
                ArrayList listPermission = PermissionBO.getUserAllPermission(ctx, userID, idList);
                PermissionBO.chgListToMap(listPermission, UserAllPermissionMap_Client);
                PermissionBO.isLoginChange();
            } else if (PermissionBO.isLoginChange()) {
                ArrayList listPermission = PermissionBO.getUserAllPermission(ctx, userID, idList);
                PermissionBO.chgListToMap(listPermission, UserAllPermissionMap_Client);
            }
            return UserAllPermissionMap_Client;
        }
        ArrayList listPermission = PermissionBO.getUserAllPermission(ctx, userID, idList);
        HashMap map = new HashMap();
        PermissionBO.chgListToMap(listPermission, map);
        return map;
    }

    public static final HashMap getUserAllPermissionForMultyOrg(Context ctx, String userID, List orgIdList) throws BOSException {
        HashMap resultMap = new HashMap();
        ArrayList listPermission = PermissionBO.getUserAllPermission(ctx, userID, orgIdList);
        PermissionBO.chgListToMap(listPermission, resultMap);
        return resultMap;
    }

    private static final void chgListToMap(ArrayList listPermission, HashMap mapPermission) {
        if (listPermission != null) {
            if (mapPermission == null) {
                mapPermission = new HashMap<String, PermissionInfo>();
            }
            mapPermission.clear();
            for (HashMap map : listPermission) {
                String freportid = CtrlReportUtil.getObjectString(map.get("freportid"));
                String fpermission = CtrlReportUtil.getObjectString(map.get("fpermission"));
                if (mapPermission.get(freportid) != null) {
                    StringBuffer joinPermission = new StringBuffer();
                    PermissionInfo info = (PermissionInfo)mapPermission.get(freportid);
                    String currentPermission = info.getPermission();
                    for (int i = 0; i < PermissionKind.PermissionKinds.length; ++i) {
                        joinPermission.append(PermissionBO.joioMaxPermission(PermissionKind.PermissionKinds[i], currentPermission, fpermission)).append(';');
                    }
                    joinPermission.deleteCharAt(joinPermission.length() - 1);
                    info.setPermission(joinPermission.toString());
                    continue;
                }
                PermissionInfo info = new PermissionInfo();
                info.setPermission(fpermission);
                info.setReportID(freportid);
                mapPermission.put(freportid, info);
            }
        }
    }

    private static final String joioMaxPermission(PermissionKind kind, String permission1, String permission2) {
        String flag2;
        String flag1 = PermissionKind.getPermissionString(permission1, kind);
        if (flag1.equals(flag2 = PermissionKind.getPermissionString(permission2, kind))) {
            return flag1;
        }
        int i1 = Integer.parseInt(flag1);
        int i2 = Integer.parseInt(flag2);
        i1 = Math.max(i1, i2);
        return String.valueOf(i1);
    }

    public static final void clearClientUserPermission() {
        if (UserAllPermissionMap_Client != null) {
            UserAllPermissionMap_Client.clear();
            UserAllPermissionMap_Client = null;
        }
    }

    public static final boolean hasDataPermission(String reportID, PermissionKind permissionKind) {
        try {
            Object obj;
            HashMap mapPermission = PermissionBO.getUserAllPermissionCache(null, null, null);
            if (mapPermission != null && (obj = mapPermission.get(reportID)) != null) {
                PermissionInfo info = (PermissionInfo)obj;
                String currentPermission = info.getPermission();
                return PermissionKind.isHoldPermission(currentPermission, permissionKind);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u6743\u9650\u5224\u65ad\u5931\u8d25", (Throwable)e);
            return false;
        }
        return false;
    }

    public static final boolean hasDataPermissionByReportId(Context ctx, String userId, String orgId, String reportId, PermissionKind permissionKind) {
        try {
            ArrayList<String> queryValue = new ArrayList<String>();
            queryValue.add(userId);
            queryValue.add(orgId);
            queryValue.add(reportId);
            queryValue.add(userId);
            queryValue.add(reportId);
            queryValue.add(userId);
            queryValue.add(orgId);
            queryValue.add(reportId);
            ArrayList listUserPermission = ExtDBUtil.getResultListBySql(ctx, user_org_role_report_sql, queryValue);
            HashMap mapPermission = new HashMap();
            PermissionBO.chgListToMap(listUserPermission, mapPermission);
            Object obj = mapPermission.get(reportId);
            if (obj != null) {
                PermissionInfo info = (PermissionInfo)obj;
                String currentPermission = info.getPermission();
                return PermissionKind.isHoldPermission(currentPermission, permissionKind);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u6743\u9650\u5224\u65ad\u5931\u8d25", (Throwable)e);
            return false;
        }
        return false;
    }

    public static final Object getUserPermissionObj(Context ctx, String userId, String orgId) throws BOSException, EASBizException {
        return PermissionBO.getUserAllPermissionCache(ctx, userId, orgId);
    }

    public static final void removePermission(String reportId) {
        try {
            String sql = "DELETE from T_RM_Permission where FReportID = '" + reportId + "'";
            ExtDBUtil.maintainRecord(null, sql, null);
        }
        catch (BOSException e) {
            log.error((Object)"\u79fb\u9664\u79bb\u6563\u6570\u636e\u6388\u6743\u8bb0\u5f55\u9519\u8bef", (Throwable)e);
        }
    }

    public static final Map<String, Map<String, String>> getPermissionByType(Context ctx, String userID, String orgID, String type) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select p.FReportID, p.fpermission \n");
        sql.append("from T_RM_Permission p INNER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid \n");
        sql.append("where p.FUserID = ? and p.FOrgID = ? and p.fpermission like ?\n");
        sql.append("union all \n");
        sql.append("select  p.FReportID, p.fpermission \n");
        sql.append("from T_RM_Permission p INNER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid \n");
        sql.append("where p.FUserID = ? and p.FOrgID is null and p.fpermission like ?\n");
        sql.append("union all \n");
        sql.append("select p.FReportID, p.fpermission \n");
        sql.append("from T_RM_Permission p INNER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid \n");
        sql.append("INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid \n");
        sql.append("where uro.FUserID = ? and uro.FOrgID = ? and p.fpermission like ?");
        if (null == ctx) {
            if (userID == null) {
                userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            }
            if (orgID == null) {
                orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            }
        } else {
            if (userID == null) {
                userID = ctx.getCaller().toString();
            }
            if (orgID == null) {
                orgID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            }
        }
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userID);
        queryValue.add(orgID);
        queryValue.add(type);
        queryValue.add(userID);
        queryValue.add(type);
        queryValue.add(userID);
        queryValue.add(orgID);
        queryValue.add(type);
        ArrayList permission = ExtDBUtil.getResultListBySql(ctx, sql.toString(), queryValue);
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        PermissionBO.chgListToMap(permission, map);
        return map;
    }
}

