/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.ThemeReportTreeNode;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.AbstractChoosedTreeUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ExtReportManageUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class ChoosedBITreeUI
extends AbstractChoosedTreeUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ChoosedBITreeUI.class);
    protected HashMap mapData = new HashMap();
    private boolean isOk = false;
    boolean isCanceled = false;
    ExtReportManageUI reportUI;

    public ChoosedBITreeUI() throws Exception {
    }

    public ChoosedBITreeUI(ExtReportManageUI reportUI) throws Exception {
        this.reportUI = reportUI;
    }

    public void onLoad() throws Exception {
        this.initTree();
    }

    protected void initTree() {
        TreeModel treeModel = null;
        RptParams prModel = new RptParams();
        prModel.setString("MethodName", "getBIMenuPath");
        try {
            RptParams ps_r = ReportFacadeFactory.getRemoteInstance().commonExecuteNever(prModel);
            treeModel = (TreeModel)ps_r.getObject("TreeModel");
        }
        catch (BOSException e) {
            logger.error((Object)"initTree:", (Throwable)e);
            MessageUtil.showInfo("label166", true);
        }
        if (treeModel != null) {
            ThemeReportTreeNode root = (ThemeReportTreeNode)treeModel.getRoot();
            int icount = root.getChildCount();
            if (icount == 0) {
                MessageUtil.showInfo("label232", true);
                this.abort();
            }
            this.convertToKingdeeTreeNode(root);
        }
        this.treeMain.setModel(treeModel);
        this.treeMain.getSelectionModel().setSelectionMode(1);
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.setRootVisible(false);
        this.treeView.getControlPane().removeAll();
    }

    private void convertToKingdeeTreeNode(ThemeReportTreeNode nodeRoot) {
        int icount = nodeRoot.getChildCount();
        for (int i = 0; i < icount; ++i) {
            ThemeReportTreeNode subNode = (ThemeReportTreeNode)nodeRoot.getChildAt(i);
            if (subNode.isLeaf() && subNode.isFolder()) {
                subNode.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
            }
            this.convertToKingdeeTreeNode(subNode);
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isOk = false;
        this.isCanceled = true;
        this.closeWin();
    }

    private String getPathText(ThemeReportTreeNode currentNode) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(currentNode.getText());
        while (null != (currentNode = (ThemeReportTreeNode)currentNode.getParent())) {
            lst.add(currentNode.getText());
        }
        for (int i = lst.size() - 1; i >= 0; --i) {
            sb.append(lst.get(i).toString());
            if (i <= 0) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        String name;
        ThemeReportTreeNode subNode;
        int i;
        int icount;
        DefaultKingdeeTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        boolean isLeaf = false;
        ArrayList<String> lstName = new ArrayList<String>();
        String path = null;
        String pathText = null;
        ThemeReportTreeNode currentNode = (ThemeReportTreeNode)treeNode;
        if (treeNode.isLeaf()) {
            ThemeReportTreeNode parentNode = (ThemeReportTreeNode)currentNode.getParent();
            if (currentNode.isFolder()) {
                path = currentNode.getRepositoryPath();
                pathText = this.getPathText(currentNode);
            } else if (null != parentNode) {
                path = parentNode.getRepositoryPath();
                if (null == path) {
                    MessageUtil.showInfo("label209", true);
                    return;
                }
                pathText = this.getPathText(parentNode);
                icount = currentNode.getChildCount();
                for (i = 0; i < icount; ++i) {
                    subNode = (ThemeReportTreeNode)currentNode.getChildAt(i);
                    name = subNode.getText();
                    lstName.add(name);
                }
            }
            isLeaf = true;
        } else {
            path = currentNode.getRepositoryPath();
            pathText = this.getPathText(currentNode);
        }
        if (!isLeaf) {
            icount = currentNode.getChildCount();
            for (i = 0; i < icount; ++i) {
                subNode = (ThemeReportTreeNode)currentNode.getChildAt(i);
                name = subNode.getText();
                lstName.add(name);
            }
        }
        this.mapData.put("path", path);
        this.mapData.put("pathText", pathText);
        this.mapData.put("lstName", lstName);
        this.isOk = true;
        this.isCanceled = false;
        this.closeWin();
    }

    protected void treeMain_mouseClicked(MouseEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode;
        if (e.getClickCount() == 2 && (treeNode = this.getSelectedTreeNode()) != null && treeNode.isLeaf()) {
            this.btnSelect_actionPerformed(null);
        }
    }

    public DefaultKingdeeTreeNode getSelectedTreeNode() {
        return (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    public HashMap getMapData() {
        return this.mapData;
    }

    public void setMapData(HashMap mapData) {
        this.mapData = mapData;
    }

    public void clear() {
        this.mapData.clear();
    }

    protected void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isOk() {
        return this.isOk;
    }
}

