/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.immit.filter.IExtDatasetFilter;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.base.reportmeta.ctrlreport.DefineReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ExtReportManageUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory.DataSetBaseFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory.ExtDataSetEnumFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory.ExtDataSetKSQLFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory.ExtDataSetTextFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.ExtCompleteTempModel;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignInputStream;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ExportCompleteRepoertAction
extends AbstractAction {
    private static final long serialVersionUID = 8675919445815840216L;
    private static Logger logger = LogUtil.getPackageLogger(ExportCompleteRepoertAction.class);
    private Book _excutorBook;
    private Component _own;
    private String _pk;

    public ExportCompleteRepoertAction(String name, Component own) {
        super(name, EASResource.getIcon((String)"imgTbtn_input"));
        this._own = own;
    }

    public void setBook(Book excutorBook) {
        this._excutorBook = excutorBook;
    }

    public void setPK(String pk) {
        this._pk = pk;
    }

    private void export() throws Exception {
        KDFileChooser chooser = new KDFileChooser(){

            public void approveSelection() {
                boolean yes;
                File f = this.getSelectedFile();
                String fname = this.getName(f);
                if (f.isFile()) {
                    fname = f.getName();
                } else {
                    String lowerName = fname.toLowerCase();
                    if (!lowerName.endsWith("complete-kds")) {
                        fname = fname.concat("complete-kds");
                    }
                }
                f = this.getCurrentDirectory();
                f = new File(f.getPath().concat(File.separator).concat(fname));
                if (f.exists() && !(yes = WindowUtil.msgboxYesNo((Component)((Object)this), (Object)"\u8be5\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u786e\u5b9a\u8981\u8986\u76d6\u5417\uff1f", (String)"Save"))) {
                    return;
                }
                super.approveSelection();
            }
        };
        chooser.setDialogType(1);
        chooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label51"));
        FileFilter[] ff = chooser.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            chooser.removeChoosableFileFilter(ff[i]);
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return "complete-kds".equals(CtrlUtil.File.getExtension((File)f)) || f.isDirectory();
            }

            public String getDescription() {
                return ".complete-kds";
            }
        });
        int r = chooser.showSaveDialog(this._own);
        if (r == 0) {
            File exportFile = chooser.getSelectedFile();
            String fname = chooser.getName(exportFile);
            fname = exportFile.isFile() ? exportFile.getName() : fname.concat(".complete-kds");
            exportFile = chooser.getCurrentDirectory();
            exportFile = new File(exportFile.getPath().concat(File.separator).concat(fname));
            String msg = MessageUtil.getMsgInfo("label59");
            String strRet = this.btnExportReport(exportFile);
            if (!strRet.equals("")) {
                msg = msg + "\r\n\u5b58\u5728\u9519\u8bef\uff1a\r\n" + strRet;
            }
            MessageUtil.showInfo(msg, false);
        }
    }

    protected String btnExportReport(File file) throws Exception {
        StringBuffer sbRetTotal = new StringBuffer();
        String currentMsg = null;
        sbRetTotal.append("");
        DefineReportInfo info = DefineReportBO.getReportInfo(null, this._pk);
        byte[] data = info.getContent();
        Book book = BookIOUtil.unpack((byte[])data);
        ExtDataSetManager manager = book.getDataSetManager();
        int size = manager.size();
        for (int n = 0; n < size; ++n) {
            String dbsourcename;
            String defineNew;
            String define;
            ExtDataSet dateset = manager.getAt(n);
            ExtDataSetType dsType = dateset.getDataSetType();
            if (dsType != ExtDataSetType.SQL_KSQL || (define = dateset.getDefine()).startsWith(defineNew = dsType.getPrefixedString("InnerLink"))) continue;
            HashMap mapDefine = RunReportParam.splitDefineToMap(define);
            String dbsourceid = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceID"));
            String orgID = CtrlReportUtil.getObjectString(mapDefine.get("OrgID"));
            String systemid = CtrlReportUtil.getObjectString(mapDefine.get("SystemID"));
            CtrlDesignInputStream in = new CtrlDesignInputStream(null, systemid, dbsourcename = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceName")), orgID, dbsourceid, true);
            if (!in.isFound()) {
                logger.error((Object)("\u627e\u4e0d\u5230\u6570\u636e\u6e90, systemid = " + systemid + ", dbsourcename" + dbsourcename + ", orgID = " + orgID + ", dbsourceid = " + dbsourceid));
                currentMsg = "\u627e\u4e0d\u5230\u6570\u636e\u6e90\uff1a " + dbsourcename + "\r\n";
                continue;
            }
            String sqlModelXmlString = in.getXmlString();
            String dbsourceidNew = dbsourceid + System.currentTimeMillis();
            define = ExtStringUtil.replace(define, dbsourceid, dbsourceidNew);
            defineNew = ExtStringUtil.replace(define, "sql_ksql@@", defineNew + "@@");
            dateset.setDefine(defineNew);
            dateset.setMeta(sqlModelXmlString);
        }
        if (this._excutorBook == null) {
            ExtDataSetManager dm = book.getDataSetManager();
            ExecutionContext _ctx = dm.getExecutionContext();
            ExtCallbackImpl _dataProvider = new ExtCallbackImpl((ExtReportManageUI)((Object)this._own));
            HashMap<String, String> mapData = new HashMap<String, String>();
            mapData.put("id", this._pk);
            _dataProvider.setMapData(mapData);
            IExtDatasetFilter filter = _dataProvider.fetchDataSetFilter(MiscUtil.collectExtDataSets((Book)book), _ctx);
            if (filter != null) {
                _ctx.registerDataSetCacheObject((Object)"showFilter", (Object)"false");
                Map params = filter.filter(true);
                _ctx.setDataSetParameters(params);
            }
            HashMap<ExtDataSetType, DataSetBaseFactory> mapFactories = new HashMap<ExtDataSetType, DataSetBaseFactory>();
            mapFactories.put(ExtDataSetType.TXT, new ExtDataSetTextFactory());
            mapFactories.put(ExtDataSetType.SQL_KSQL, ExtDataSetKSQLFactory.getInstance());
            mapFactories.put(ExtDataSetType.SQL_ENUM, ExtDataSetEnumFactory.getInstance());
            _ctx.registerDataSetFactories(mapFactories);
            _ctx.registerDataSetCacheObject((Object)"isLimitComplete", (Object)"true");
            for (int i = 0; i < dm.size(); ++i) {
                dm.updateDataSet(dm.getAt(i));
            }
        } else {
            ExtDataSetManager excutorManger = this._excutorBook.getDataSetManager();
            Map map = excutorManger.getExecutionContext().getDataSetParameters();
            manager.getExecutionContext().setDataSetParameters(map);
            manager.removeAll();
            for (int i = 0; i < size; ++i) {
                manager.addDataSet(excutorManger.getAt(i));
            }
        }
        String logs = MiscUtil.getLastExeDocuments();
        ExtCompleteTempModel mode = new ExtCompleteTempModel();
        mode.setTempBook(book);
        mode.setReslutBook(this._excutorBook);
        mode.setLog(logs);
        mode.exportCompleteReport(file);
        if (currentMsg != null) {
            sbRetTotal.append(currentMsg);
        }
        return sbRetTotal.toString();
    }

    public void actionPerformed(ActionEvent e) {
        if (!MiscUtil.shouldLog()) {
            MsgBox.showWarning((String)"\u6269\u5c55\u62a5\u8868\u63a7\u5236\u53f0\u672a\u6253\u5f00\uff0c\u65e0\u6cd5\u6536\u96c6\u65e5\u5fd7\u3002\u8bf7\u4f7f\u7528\u3010\u5de5\u5177->\u62a5\u8868\u63a7\u5236\u53f0\u3011\u6253\u5f00\u62a5\u8868\u63a7\u5236\u53f0\uff0c\u91cd\u65b0\u6267\u884c\u62a5\u8868\u6a21\u677f\u540e\u518d\u5bfc\u51fa\u5168\u4fe1\u606f\u6a21\u677f\u3002");
            return;
        }
        try {
            this.export();
        }
        catch (Exception ex) {
            logger.error((Object)e);
            StringWriter sw = new StringWriter();
            PrintWriter printWriter = new PrintWriter(sw);
            ex.printStackTrace(printWriter);
            MsgBox.showDetailAndOK((Component)this._own, (String)"Export template failed !", (String)sw.toString(), (int)2);
        }
    }
}

