/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.AbstractImageImportUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.ICustKSQLReport;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.IKSQLReport;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.KDImagePanel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.KSQLReportFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ImageImportUI
extends AbstractImageImportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ImageImportUI.class);
    private KDImagePanel imagePanel = null;
    private File input = null;
    private String rptID = null;
    private boolean isSys = true;
    KDFileChooser chooser = null;

    public ImageImportUI() throws Exception {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnImport.setEnabled(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext() != null && this.getUIContext().containsKey("isSys")) {
            this.isSys = (Boolean)this.getUIContext().get("isSys");
        }
        if (this.getUIContext() != null && this.getUIContext().containsKey("rptID")) {
            this.rptID = (String)this.getUIContext().get("rptID");
        }
        if (StringUtils.isEmpty((String)this.rptID)) {
            this.abort();
        }
        try {
            Object report;
            byte[] b = null;
            if (this.isSys) {
                report = KSQLReportFactory.getRemoteInstance();
                KSQLReportInfo info = report.getKSQLReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rptID)));
                b = info.getIcon();
            } else {
                report = CustKSQLReportFactory.getRemoteInstance();
                CustKSQLReportInfo info = report.getCustKSQLReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rptID)));
                b = info.getIcon();
            }
            if (b != null) {
                BufferedImage ima = ImageIO.read(new ByteArrayInputStream(b));
                this.paintImage(ima);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (IOException e) {
            this.handUIException(e);
        }
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.rptID)) {
            return;
        }
        if (this.input == null || !this.input.exists()) {
            return;
        }
        FileInputStream fis = null;
        fis = new FileInputStream(this.input);
        FileChannel fc = fis.getChannel();
        long size = fc.size();
        byte[] b = new byte[new Long(size).intValue()];
        MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        mbb.get(b);
        mbb.clear();
        fc.close();
        fis.close();
        if (this.isSys) {
            IKSQLReport report = KSQLReportFactory.getRemoteInstance();
            report.addImage(this.rptID, b);
        } else {
            ICustKSQLReport report = CustKSQLReportFactory.getRemoteInstance();
            report.addImage(this.rptID, b);
        }
        this.destroyWindow();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        ImageFilter imageFilter = new ImageFilter();
        if (this.chooser == null) {
            this.chooser = new KDFileChooser();
        }
        this.chooser.setDialogType(0);
        this.chooser.setFileSelectionMode(0);
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setDialogTitle("\u6253\u5f00\u56fe\u7247");
        this.chooser.setApproveButtonText(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label54"));
        FileFilter[] ff = this.chooser.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            this.chooser.removeChoosableFileFilter(ff[i]);
        }
        this.chooser.setFileFilter((FileFilter)imageFilter);
        int r = this.chooser.showOpenDialog((Component)((Object)this));
        File imageFile = null;
        if (r == 0) {
            imageFile = this.chooser.getSelectedFile();
        }
        if (imageFile == null) {
            return;
        }
        BufferedImage image = ImageIO.read(imageFile);
        this.input = imageFile;
        this.paintImage(image);
    }

    private void paintImage(Image image) {
        if (this.imagePanel == null) {
            this.imagePanel = new KDImagePanel(image, "Centre");
            this.imagePanel.setBounds(0, 0, this.kDImagePanel.getWidth(), this.kDImagePanel.getHeight());
        }
        this.imagePanel.setImage(image);
        this.kDImagePanel.add((Component)((Object)this.imagePanel));
    }

    class ImageFilter
    extends FileFilter {
        ImageFilter() {
        }

        public boolean accept(File dir) {
            String fullname = dir.getName();
            String extname = StringUtil4File.getExtendedFileName((String)fullname);
            return (extname = extname.toLowerCase()).equals("jpg") || extname.equals("png") || extname.equals("jpeg") || extname.equals("gif") || dir.isDirectory();
        }

        public String getDescription() {
            return "\u56fe\u7247" + EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label53") + "(*.jpg,*.png,*.jpeg,*.gif)";
        }
    }
}

