/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.AbstractReportDesignUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportQuery;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportCollection;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustTreeFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustTreeInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.ICustKSQLReport;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.IReportMetaFacade;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.ReportMetaFacadeFactory;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ReportDesignUI
extends AbstractReportDesignUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ReportDesignUI.class);
    Map<String, List<String>> addMap = new HashMap<String, List<String>>();
    Map<String, List<String>> removeMap = new HashMap<String, List<String>>();
    private TreeSelectionListener treeSelectionListener = null;
    protected ITreeBuilder treeBuilder;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        this.btnMoveTo.setEnabled(true);
        this.btnMoveTo.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnSave.setEnabled(true);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.kDTreeView2.getControlPane().add((Component)this.btnGroupRemove);
        this.btnGroupRemove.setEnabled(true);
        this.btnGroupRemove.setIcon(EASResource.getIcon((String)"imgTree_delete"));
        this.initSysTree();
        this.initCustTree();
    }

    private void initSysTree() {
        BOSObjectType[] types = new BOSObjectType[]{MetaDataTypeList.PACKAGE};
        IBriefViewTreeNode root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_packages", (BOSObjectType[])types);
        DefaultKingdeeTreeNode nodeRoot = new DefaultKingdeeTreeNode((Object)"EAS");
        nodeRoot.setText(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.ReportsResource", (String)"reportRoot"));
        nodeRoot.setUserObject((Object)root);
        nodeRoot = this.convertToKingdeeTreeNode(root, nodeRoot);
        this.setSysNode(nodeRoot);
        this.sysKDTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)nodeRoot));
        ((KingdeeTreeModel)this.sysKDTree.getModel()).setAsksAllowsChildren(false);
        this.sysKDTree.getSelectionModel().setSelectionMode(1);
        this.sysKDTree.setAutoscrolls(true);
    }

    private DefaultKingdeeTreeNode convertToKingdeeTreeNode(IBriefViewTreeNode root, DefaultKingdeeTreeNode nodeRoot) {
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)enu.nextElement();
            String strNodeName = bvNode.getAlias() + "(" + bvNode.getName() + ")";
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setText(strNodeName);
            node.setUserObject((Object)bvNode);
            nodeRoot.add((MutableTreeNode)node);
            this.convertToKingdeeTreeNode(bvNode, node);
        }
        return nodeRoot;
    }

    private void addCustTreeNode(KDTreeNode node) {
        CustKSQLReportCollection col = null;
        try {
            col = this.getCustDataList(node);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if ((col == null || col.size() <= 0) && node.isLeaf()) {
            node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_close"));
            return;
        }
        for (int i = 0; i < col.size(); ++i) {
            CustKSQLReportInfo info = col.get(i);
            KDTreeNode treeNode = new KDTreeNode((Object)info.getId().toString());
            treeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_table"));
            treeNode.setText(info.getName());
            node.add((MutableTreeNode)treeNode);
        }
    }

    private void setCustNode(KDTreeNode node) {
        if (node.isLeaf()) {
            this.addCustTreeNode(node);
        } else {
            Enumeration enume = node.children();
            while (enume.hasMoreElements()) {
                KDTreeNode repNode = (KDTreeNode)enume.nextElement();
                this.setCustNode(repNode);
            }
            if (!node.isRoot()) {
                this.addCustTreeNode(node);
            }
        }
    }

    private void addSysTreeNode(DefaultKingdeeTreeNode node) {
        List list = null;
        try {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)node.getUserObject();
            list = this.getDataList(bvNode.getFullName());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if ((list == null || list.size() <= 0) && node.isLeaf()) {
            node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_close"));
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode();
            treeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_table"));
            treeNode.setText((String)map.get("fname"));
            treeNode.setUserObject(map.get("fid"));
            node.add((MutableTreeNode)treeNode);
        }
    }

    private void setSysNode(DefaultKingdeeTreeNode node) {
        if (node.isLeaf()) {
            this.addSysTreeNode(node);
        } else {
            Enumeration enume = node.children();
            while (enume.hasMoreElements()) {
                DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
                this.setSysNode(repNode);
            }
            if (!node.isRoot()) {
                this.addSysTreeNode(node);
            }
        }
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return CustTreeFactory.getRemoteInstance();
    }

    private final FilterInfo getDefaultCUFilter(boolean isIgnore) {
        FilterInfo filter = new FilterInfo();
        if (isIgnore) {
            return filter;
        }
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }

    private void initCustTree() {
        try {
            this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)new DefaultLNTreeNodeCtrl(this.getTreeInterface()), (int)0, (int)4, (FilterInfo)this.getDefaultCUFilter(false), null);
            KDTreeNode rootNode = new KDTreeNode((Object)"EAS");
            ((DefaultTreeModel)this.custKDTree.getModel()).setRoot((TreeNode)rootNode);
            this.treeBuilder.buildTree(this.custKDTree);
            this.custKDTree.setShowPopMenuDefaultItem(true);
            this.treeBuilder.refreshTreeNode(this.custKDTree, rootNode, this.getDefaultCUFilter(true));
            this.setCustNode(rootNode);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        for (int i = 0; i < this.custKDTree.getTreeSelectionListeners().length; ++i) {
            this.custKDTree.removeTreeSelectionListener(this.custKDTree.getTreeSelectionListeners()[i]);
        }
        if (this.treeSelectionListener == null) {
            this.treeSelectionListener = new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                }
            };
            this.custKDTree.addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    public CustKSQLReportCollection getCustDataList(KDTreeNode node) throws Exception {
        if (node == null || !node.isLeaf() || node.getUserObject() == null) {
            return null;
        }
        CustTreeInfo info = null;
        if (node.getUserObject() instanceof CustTreeInfo) {
            info = (CustTreeInfo)node.getUserObject();
        }
        if (info == null || info.getId() == null) {
            return null;
        }
        String treeID = info.getId().toString();
        String oql = "select id,name,orgunit.id,orgunit.name,orgunit.number,creator.id,creator.name where treeNode.id = '" + treeID + "'";
        ICustKSQLReport icust = CustKSQLReportFactory.getRemoteInstance();
        CustKSQLReportCollection col = icust.getCustKSQLReportCollection(oql);
        return col;
    }

    public List getDataList(String sysID) throws Exception {
        return CtrlReportQuery.getDbSourceListBySystemID("2", sysID);
    }

    public void loadFields() {
        super.loadFields();
    }

    public void actionMoveTo_actionPerformed(ActionEvent e) throws Exception {
        this.CustTreeAddNode();
    }

    private void CustTreeAddNode() {
        KDTreeNode selectedNode = (KDTreeNode)this.custKDTree.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode sysNode = (DefaultKingdeeTreeNode)this.sysKDTree.getLastSelectedPathComponent();
        if (sysNode == null || !sysNode.isLeaf() || sysNode.isLeaf() && !(sysNode.getUserObject() instanceof String)) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u7cfb\u7edf\u62a5\u8868\u8282\u70b9\uff01");
            return;
        }
        String reportID = sysNode.getUserObject().toString();
        if (selectedNode == null || selectedNode.isRoot() || !(selectedNode.getUserObject() instanceof CustTreeInfo)) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u9886\u57df\u8282\u70b9\uff01");
            return;
        }
        KDTreeNode treeNode = new KDTreeNode(sysNode.getUserObject());
        treeNode.setText(sysNode.getText());
        treeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_table"));
        Enumeration child = selectedNode.children();
        if (child == null || !child.hasMoreElements()) {
            String treeNodeID = ((CustTreeInfo)selectedNode.getUserObject()).getId().toString();
            if (this.removeMap.containsKey(treeNodeID)) {
                List<String> list = this.removeMap.get(treeNodeID);
                if (list.contains(reportID)) {
                    list.remove(reportID);
                }
                if (list.size() <= 0) {
                    this.removeMap.remove(treeNodeID);
                }
            } else {
                List<Object> list = null;
                list = this.addMap.containsKey(treeNodeID) ? this.addMap.get(treeNodeID) : new ArrayList();
                if (!list.contains(reportID)) {
                    list.add(reportID);
                }
                this.addMap.put(treeNodeID, list);
            }
            selectedNode.add((MutableTreeNode)treeNode);
            ((KingdeeTreeModel)this.custKDTree.getModel()).reload((TreeNode)selectedNode);
        } else if (child != null && child.hasMoreElements()) {
            boolean isExist = false;
            while (child.hasMoreElements()) {
                KDTreeNode node = (KDTreeNode)child.nextElement();
                if (node == null || node.getUserObject() == null || !sysNode.getText().equals(node.getText())) continue;
                MsgBox.showInfo((String)"\u6539\u8282\u70b9\u4e0b\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u62a5\u8868\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5bfc\u5165\uff01");
                isExist = true;
                break;
            }
            String treeNodeID = ((CustTreeInfo)selectedNode.getUserObject()).getId().toString();
            if (!isExist) {
                if (this.removeMap.containsKey(treeNodeID)) {
                    List<String> list = this.removeMap.get(treeNodeID);
                    if (list.contains(reportID)) {
                        list.remove(reportID);
                    }
                    if (list.size() <= 0) {
                        this.removeMap.remove(treeNodeID);
                    }
                } else {
                    List<Object> list = null;
                    list = this.addMap.containsKey(treeNodeID) ? this.addMap.get(treeNodeID) : new ArrayList();
                    if (!list.contains(reportID)) {
                        list.add(reportID);
                    }
                    this.addMap.put(treeNodeID, list);
                }
                selectedNode.add((MutableTreeNode)treeNode);
                ((KingdeeTreeModel)this.custKDTree.getModel()).reload((TreeNode)selectedNode);
            }
        }
    }

    private void CustTreeRemoveNode() {
        KDTreeNode selectedNode = (KDTreeNode)this.custKDTree.getLastSelectedPathComponent();
        if (selectedNode == null || selectedNode.isRoot() || selectedNode.getUserObject() instanceof CustTreeInfo) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u62a5\u8868\u8282\u70b9\uff01");
            return;
        }
        if (this.addMap.containsKey((String)selectedNode.getUserObject())) {
            this.addMap.remove((String)selectedNode.getUserObject());
            ((KDTreeNode)selectedNode.getParent()).remove((MutableTreeNode)selectedNode);
        } else {
            String treeNodeID = ((CustTreeInfo)((KDTreeNode)selectedNode.getParent()).getUserObject()).getId().toString();
            String sysid = (String)selectedNode.getUserObject();
            if (this.removeMap.containsKey(treeNodeID)) {
                List<String> list = this.removeMap.get(treeNodeID);
                if (!list.contains(sysid)) {
                    list.add(sysid);
                }
                if (list.size() > 0) {
                    this.removeMap.put(treeNodeID, list);
                }
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(sysid);
                this.removeMap.put(treeNodeID, list);
            }
        }
        KDTreeNode node = (KDTreeNode)selectedNode.getParent();
        ((KingdeeTreeModel)this.custKDTree.getModel()).removeNodeFromParent((MutableTreeNode)selectedNode);
        if (node.isLeaf()) {
            node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_close"));
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        try {
            IReportMetaFacade ireport = ReportMetaFacadeFactory.getRemoteInstance();
            ireport.updateRelation(this.addMap, this.removeMap);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.CustTreeRemoveNode();
    }
}

