/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SeriesPanel
extends JComponent {
    private Object[] _colorAndTexts;
    private boolean _rightAlign = false;

    public SeriesPanel(Object[] colorAndTexts) {
        this._colorAndTexts = colorAndTexts;
    }

    protected void paintComponent(Graphics g) {
        if (!this._rightAlign) {
            this.drawLeftAlignment(g);
        } else {
            this.drawRightAlignment(g);
        }
        super.paintComponent(g);
    }

    private void drawLeftAlignment(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        int x = 0;
        int y = 0;
        BasicStroke stroke = new BasicStroke(1.0f);
        for (int i = 0; i < this._colorAndTexts.length; i += 2) {
            Rectangle s = new Rectangle(x, y + 1, 13, 13);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(stroke);
            g2d.draw(s);
            g2d.setColor((Color)this._colorAndTexts[i]);
            g2d.fill(s);
            g2d.setColor(Color.BLACK);
            g2d.drawString((String)this._colorAndTexts[i + 1], x += 19, y + 12);
            x = x + 10 + SwingUtilities.computeStringWidth(g.getFontMetrics(), (String)this._colorAndTexts[i + 1]);
        }
        g2d.dispose();
    }

    private void drawRightAlignment(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        int x = this.getWidth();
        int y = 0;
        BasicStroke stroke = new BasicStroke(1.0f);
        for (int i = this._colorAndTexts.length - 1; i > -1; i -= 2) {
            int textLen = SwingUtilities.computeStringWidth(g.getFontMetrics(), (String)this._colorAndTexts[i]);
            x = x - textLen - 10;
            g2d.setColor(Color.BLACK);
            g2d.drawString((String)this._colorAndTexts[i], x, y + 12);
            Rectangle s = new Rectangle(x -= 19, y + 1, 13, 13);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(stroke);
            g2d.draw(s);
            g2d.setColor((Color)this._colorAndTexts[i - 1]);
            g2d.fill(s);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame("\u6d4b\u8bd5\u7cfb\u5217\u9762\u677f");
                Object[] objs = new Object[]{Color.RED, "\u6807\u51c6\u62a5\u8868", Color.ORANGE, "\u6269\u5c55\u62a5\u8868"};
                SeriesPanel series = new SeriesPanel(objs);
                series.setRightAlign(false);
                frame.add(series);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public boolean isRightAlign() {
        return this._rightAlign;
    }

    public void setRightAlign(boolean rightAlign) {
        this._rightAlign = rightAlign;
    }
}

