/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.adapter.TableManager;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.LicenseBo;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.MainMenuItemBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.AbstractVerifyMenuUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.DeployBatchUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.StdImportUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.DeployMenu;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.VerifyMenu;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class VerifyMenuUI
extends AbstractVerifyMenuUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(VerifyMenuUI.class);
    private boolean isinitLayout = false;
    private boolean isCancel = true;
    JButton btnUnDeploy;
    JButton btnRestoreDeploy;
    JButton btnDeleteMenu;

    public VerifyMenuUI() throws Exception {
        this.initLayout();
        this.tableReport.checkParsed();
        this.tableMenu.checkParsed();
    }

    public void onLoad() throws Exception {
        this.txtMessage.setSelectAllOnFocus(false);
        this.initPanelReport();
        this.initPanelMenu();
        this.setCreateEnable(true);
    }

    private void initPanelReport() {
        this.kDPanel_report.setCustomInsets(new Insets(5, 5, 5, 5));
        this.kDContainer1.setCustomInsets(new Insets(5, 5, 5, 5));
        this.tableReport.getSelectManager().setSelectMode(10);
        this.kDContainer1.setContainerType(1);
        this.btnUnDeploy = new KDWorkButton();
        this.btnUnDeploy.setIcon(EASResource.getIcon((String)"imgTbtn_cancelcollate"));
        this.btnUnDeploy.setText("\u64a4\u9500\u53d1\u5e03");
        this.kDContainer1.addButton(this.btnUnDeploy);
        this.btnRestoreDeploy = new KDWorkButton();
        this.btnRestoreDeploy.setIcon(EASResource.getIcon((String)"imgTbtn_releasebyuser"));
        this.btnRestoreDeploy.setText("\u91cd\u65b0\u751f\u6210\u83dc\u5355");
        this.kDContainer1.addButton(this.btnRestoreDeploy);
        this.btnUnDeploy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    VerifyMenuUI.this.btnUnDeploy_actionPerformed(e);
                }
                catch (Exception e1) {
                    MessageUtil.showDetailAndOK(null, "\u64a4\u9500\u53d1\u5e03\u5931\u8d25", e1);
                }
            }
        });
        this.btnRestoreDeploy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    VerifyMenuUI.this.btnRestoreDeploy_actionPerformed(e);
                }
                catch (Exception e1) {
                    MessageUtil.showDetailAndOK(null, "\u91cd\u65b0\u751f\u6210\u83dc\u5355", e1);
                }
            }
        });
    }

    private void initPanelMenu() {
        this.kDPanel_menu.setCustomInsets(new Insets(5, 5, 5, 5));
        this.kDContainer2.setCustomInsets(new Insets(5, 5, 5, 5));
        this.tableMenu.getSelectManager().setSelectMode(10);
        this.kDContainer2.setContainerType(1);
        this.btnDeleteMenu = new KDWorkButton();
        this.btnDeleteMenu.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDeleteMenu.setText("\u5220\u9664\u83dc\u5355");
        this.kDContainer2.addButton(this.btnDeleteMenu);
        this.btnDeleteMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    VerifyMenuUI.this.btnDeleteMenu_actionPerformed(e);
                }
                catch (Exception e1) {
                    MessageUtil.showDetailAndOK(null, "\u5220\u9664\u83dc\u5355\u5931\u8d25", e1);
                }
            }
        });
    }

    private void setCreateEnable(boolean isEnable) {
        this.btnOk.setEnabled(isEnable);
        this.btnUnDeploy.setEnabled(false);
        this.btnRestoreDeploy.setEnabled(false);
        this.btnDeleteMenu.setEnabled(false);
        this.txtMessage.selectAll();
        Rectangle rect = this.txtMessage.getBounds();
        rect.setLocation(rect.x, rect.height);
        this.kDScrollPane1.getViewport().scrollRectToVisible(rect);
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    protected void btnUnDeploy_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstSelected = TableManager.getSelectedTableIndexs(this.tableReport);
        if (lstSelected.isEmpty()) {
            MessageUtil.showInfo("label8", true);
            return;
        }
        int confirm = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label160"));
        if (confirm == 2) {
            return;
        }
        int iSuccessCount = 0;
        int iErrorCount = 0;
        String errReportName = "";
        String errMsgAll = "";
        for (int i = 0; i < lstSelected.size(); ++i) {
            String strRowIndex = lstSelected.get(i).toString();
            HashMap mapInfo = (HashMap)this.tableReport.getRow(Integer.parseInt(strRowIndex)).getUserObject();
            String fid = mapInfo.get("fid").toString();
            String fmenuid = CtrlReportUtil.getObjectString(mapInfo.get("fmenuid"));
            String fname = CtrlReportUtil.getObjectString(mapInfo.get("fname"));
            String fisstdproduct = CtrlReportUtil.getObjectString(mapInfo.get("fisstdproduct"));
            if (fmenuid.equals("")) continue;
            try {
                HashMap<String, Boolean> stdInfo = new HashMap<String, Boolean>();
                Boolean isDelMenuUI = new Boolean(!"1".equals(fisstdproduct));
                stdInfo.put("isDelMenuUI", isDelMenuUI);
                DeployMenu.unDeployReport(fid, fmenuid, false, stdInfo);
                ++iSuccessCount;
                continue;
            }
            catch (BOSException ex) {
                ++iErrorCount;
                errReportName = errReportName + fname + ", ";
                errMsgAll = errMsgAll + ex.getMessage() + "\r\n";
            }
        }
        String msgAll = "";
        String msg1 = EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label161");
        String msg2 = EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label162");
        msgAll = msgAll + msg1 + iSuccessCount + msg2 + "," + MessageUtil.getMsgInfo("undeploysuccess");
        if (iErrorCount > 0) {
            String msg3 = EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label181");
            String msg4 = EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label182");
            errReportName = errReportName.substring(0, errReportName.length() - 2);
            msgAll = msgAll + "\r\n" + msg3 + iErrorCount + msg4 + errReportName;
            String errCause = EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label183");
            MessageUtil.showDetailAndOK(null, msgAll, new Exception(errCause + errMsgAll));
        } else {
            MsgBox.showInfo((String)msgAll);
        }
        LicenseBo.updateCacheSpareCount(null);
        this.kDButtonOk_actionPerformed(null);
    }

    protected void btnRestoreDeploy_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstSelected = TableManager.getSelectedTableIndexs(this.tableReport);
        if (lstSelected.isEmpty()) {
            MessageUtil.showInfo("label8", true);
            return;
        }
        boolean isRestore = MessageUtil.showConfirm("\u786e\u5b9a\u91cd\u65b0\u751f\u6210\u83dc\u5355\uff1f", false);
        if (!isRestore) {
            return;
        }
        MainMenuItemBO mmib = null;
        int iSuccessCount = 0;
        int iErrorCount = 0;
        String errMsgAll = "";
        for (int i = 0; i < lstSelected.size(); ++i) {
            String strRowIndex = lstSelected.get(i).toString();
            HashMap mapInfo = (HashMap)this.tableReport.getRow(Integer.parseInt(strRowIndex)).getUserObject();
            String fid = CtrlReportUtil.getObjectString(mapInfo.get("fid"));
            String fname = CtrlReportUtil.getObjectString(mapInfo.get("fname"));
            String fdeploypathFullName = CtrlReportUtil.getObjectString(mapInfo.get("fdeploypath"));
            String fdeploypathNumber = MainMenuItemBO.getDeployNumber(fdeploypathFullName);
            String deployAlias = MainMenuItemBO.getDeployName(fdeploypathFullName);
            String fmenuui = CtrlReportUtil.getObjectString(mapInfo.get("fmenuui"));
            if (mmib == null) {
                mmib = new MainMenuItemBO(null);
            }
            String[] menuNumbers = fdeploypathNumber.split("!");
            String menuNumber = menuNumbers[menuNumbers.length - 1];
            HashMap<String, String> menuNameMap = new HashMap<String, String>();
            String[] menuNames = deployAlias.split("/");
            String menuName = menuNames[menuNames.length - 1];
            String parentMenuNumber = ExtStringUtil.replaceFirst(fdeploypathNumber, "!" + menuNumber, "");
            MainMenuItemInfo parentMenu = mmib.getMainMenuItemInfo(parentMenuNumber);
            if (parentMenu == null) {
                ++iErrorCount;
                errMsgAll = errMsgAll + "\u91cd\u65b0\u751f\u6210\u83dc\u5355\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u4e0a\u7ea7\u83dc\u5355\uff1a" + parentMenuNumber + "\uff0c\u8bf7\u64a4\u9500\u540e\u91cd\u65b0\u53d1\u5e03 \uff1a" + fname + "\r\n";
                continue;
            }
            String name_l2 = STConverter.tc2sc((String)menuName);
            menuNameMap.put("l2", name_l2);
            String name_l3 = STConverter.sc2tc((String)menuName);
            menuNameMap.put("l3", name_l3);
            MainMenuItemInfo mi = DeployBatchUI.getRestoreMenuItemInfo(parentMenu, menuNameMap, fid, menuNumber, fmenuui);
            String strRet = DeployBatchUI.insertMenu(mi, fdeploypathFullName, fid, null);
            if (strRet.length() > 0) {
                logger.error((Object)strRet);
                ++iErrorCount;
                errMsgAll = errMsgAll + "\u91cd\u65b0\u751f\u6210\u83dc\u5355\u5931\u8d25\uff0c\u8bf7\u64a4\u9500\u540e\u91cd\u65b0\u53d1\u5e03\uff1a" + fname + "\r\n";
                continue;
            }
            ++iSuccessCount;
        }
        try {
            IMainFunctionMenu imenu = MainFunctionMenuFactory.getRemoteInstance();
            imenu.updateMenuCache("");
            MenuCacheFactory.getRemoteInstance().updateAllMenuCache();
        }
        catch (Exception ex) {
            logger.error((Object)"\u66f4\u65b0\u83dc\u5355\u7f13\u5b58", (Throwable)ex);
        }
        String msgAll = "";
        msgAll = "\u6210\u529f\u6062\u590d" + iSuccessCount + "\u4e2a\u83dc\u5355" + ", \u91cd\u65b0\u767b\u5f55\u540e\u83dc\u5355\u9879\u751f\u6548";
        if (iErrorCount > 0) {
            msgAll = msgAll + "\r\n\u5176\u4e2d\uff0c" + iErrorCount + "\u4e2a\u9519\u8bef";
            MessageUtil.showDetailAndOK(null, msgAll, new Exception("\u5931\u8d25\u539f\u56e0\r\n" + errMsgAll));
        } else {
            MsgBox.showInfo((String)msgAll);
        }
        this.kDButtonOk_actionPerformed(null);
    }

    protected void btnDeleteMenu_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstSelected = TableManager.getSelectedTableIndexs(this.tableMenu);
        if (lstSelected.isEmpty()) {
            MessageUtil.showInfo("\u8bf7\u9009\u62e9\u8bb0\u5f55", false);
            return;
        }
        boolean flag = MessageUtil.showConfirm("\u786e\u5b9a\u5220\u9664\u83dc\u5355\uff1f", false);
        if (!flag) {
            return;
        }
        ArrayList<String> lstDel = new ArrayList<String>();
        for (int i = 0; i < lstSelected.size(); ++i) {
            String strRowIndex = lstSelected.get(i).toString();
            HashMap mapInfo = (HashMap)this.tableMenu.getRow(Integer.parseInt(strRowIndex)).getUserObject();
            String menuid = CtrlReportUtil.getObjectString(mapInfo.get("fid"));
            lstDel.add("delete from t_pm_mainMenuItem where fid = '" + menuid + "'");
        }
        ExtDBUtil.executeBatch(null, lstDel);
        try {
            IMainFunctionMenu imenu = MainFunctionMenuFactory.getRemoteInstance();
            imenu.updateMenuCache("");
            MenuCacheFactory.getRemoteInstance().updateAllMenuCache();
        }
        catch (Exception ex) {
            logger.error((Object)"\u66f4\u65b0\u83dc\u5355\u7f13\u5b58", (Throwable)ex);
        }
        MsgBox.showInfo((String)"\u5220\u9664\u6210\u529f\uff0c\u91cd\u65b0\u767b\u5f55\u540e\u83dc\u5355\u9879\u751f\u6548");
        this.kDButtonOk_actionPerformed(null);
    }

    private void verifyReport() {
        this.tableReport.removeRows();
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    VerifyMenu vm = new VerifyMenu(VerifyMenuUI.this.tableReport, VerifyMenuUI.this.kDScrollPane1, VerifyMenuUI.this.txtMessage);
                    vm.verifyDeployReport();
                }
                finally {
                    if (VerifyMenuUI.this.tableReport.getRowCount() > 0) {
                        VerifyMenuUI.this.btnUnDeploy.setEnabled(true);
                        VerifyMenuUI.this.btnRestoreDeploy.setEnabled(true);
                    }
                    VerifyMenuUI.this.btnOk.setEnabled(true);
                    VerifyMenuUI.this.btnCancel.setEnabled(true);
                }
            }
        });
        t.start();
    }

    private void verifyMenu() {
        this.tableMenu.removeRows();
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    VerifyMenu vm = new VerifyMenu(VerifyMenuUI.this.tableMenu, VerifyMenuUI.this.kDScrollPane1, VerifyMenuUI.this.txtMessage);
                    vm.verifyMenu();
                }
                finally {
                    if (VerifyMenuUI.this.tableMenu.getRowCount() > 0) {
                        VerifyMenuUI.this.btnDeleteMenu.setEnabled(true);
                    }
                    VerifyMenuUI.this.btnOk.setEnabled(true);
                    VerifyMenuUI.this.btnCancel.setEnabled(true);
                }
            }
        });
        t.start();
    }

    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        this.txtMessage.setText("");
        StdImportUI.setTxtMsg(this.kDScrollPane1, this.txtMessage, "\u6b63\u5728\u6821\u9a8c\uff0c\u8bf7\u7a0d\u5019......\r\n");
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        if (this.kDTabbedPane1.getSelectedIndex() == 0) {
            this.verifyReport();
        } else {
            this.verifyMenu();
        }
    }

    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

