/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.data.DataConvert;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory.DataSetBaseFactory;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

public class ExtDataSetTextFactory
extends DataSetBaseFactory {
    public ExtDataSetTextFactory() {
        this.dsType = ExtDataSetType.TXT;
    }

    public ExtDataSet getDataSet(Book book, String name, String diskFile) {
        if (StringUtil.isEmptyString((String)diskFile)) {
            return null;
        }
        ExtDataSet ds = new ExtDataSet(book, name, diskFile, ExtDataSetType.TXT);
        this.updateDataSet(ds, book.getDataSetManager().getExecutionContext());
        return ds;
    }

    public boolean updateDataSet(ExtDataSet ds, ExecutionContext execCtx) {
        LineNumberReader lr = null;
        try {
            String str;
            IParameter param = execCtx.getDataSetParameter("url");
            String diskFile = param != null ? param.getValue().getVariant().toString() : ExtDataSetType.TXT.trimPrefix(ds.getDefine());
            lr = new LineNumberReader(new FileReader(diskFile));
            String[] names = null;
            DataConvert.IDataConvert[] convert = null;
            String nameMark = "colname=";
            String typeMark = "coltype=";
            int lines = 0;
            while ((str = lr.readLine()) != null) {
                if (lines == 0 && str.indexOf(nameMark) == 0) {
                    ++lines;
                    str = str.substring(nameMark.length());
                    names = str.split("\t");
                    continue;
                }
                if (str.indexOf(typeMark) != 0) continue;
                String[] types = (str = str.substring(typeMark.length())).split("\t");
                if (types.length != names.length) {
                    return false;
                }
                for (int i = 0; i < types.length; ++i) {
                    ds.addColumn(new ExtColumn(ds, names[i], i, Integer.parseInt(types[i])));
                }
                convert = DataConvert.getConvertArray((ExtDataSet)ds);
                break;
            }
            ObjectArray al = new ObjectArray();
            while ((str = lr.readLine()) != null) {
                int i;
                names = str.split("\t");
                Variant[] rowData = new Variant[convert.length];
                int size = Math.min(names.length, rowData.length);
                for (i = 0; i < size; ++i) {
                    rowData[i] = convert[i].convertString(names[i]);
                }
                while (i < rowData.length) {
                    rowData[i] = Variant.nullVariant;
                    ++i;
                }
                al.append((Object)rowData);
            }
            al.trimToSize();
            ds.setData(al);
            lr.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }
}

