/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.email;

import com.kingdee.eas.base.reportmeta.ctrlreport.email.ByteArrayDataSource;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public abstract class MailSender
extends Authenticator {
    private String smtpHost = null;
    private String username = null;
    private String userpasswd = null;
    protected BodyPart messageBodyPart = null;
    protected Multipart multipart = new MimeMultipart("related");
    protected MimeMessage mailMessage = null;
    protected Session mailSession = null;
    protected Properties mailProperties = System.getProperties();
    protected InternetAddress mailFromAddress = null;
    protected InternetAddress mailToAddress = null;
    protected Authenticator authenticator = null;
    protected String mailSubject = "";
    protected Date mailSendDate = null;

    protected MailSender(String smtpHost, String username, String password) {
        this.smtpHost = smtpHost;
        this.username = username;
        this.userpasswd = password;
        this.mailProperties.put("mail.smtp.host", smtpHost);
        this.mailProperties.put("mail.smtp.auth", "true");
        this.mailSession = Session.getDefaultInstance((Properties)this.mailProperties, (Authenticator)this);
        this.mailSession.setDebug(true);
        this.mailMessage = new MimeMessage(this.mailSession);
        this.messageBodyPart = new MimeBodyPart();
    }

    public static MailSender getTextMailSender(String smtpHost, String username, String password) {
        return new MailSender(smtpHost, username, password){

            public void setMailContent(String mailContent) throws MessagingException {
                this.messageBodyPart.setText(mailContent);
                this.multipart.addBodyPart(this.messageBodyPart);
            }
        };
    }

    public static MailSender getHtmlMailSender(String smtpHost, String username, String password) {
        return new MailSender(smtpHost, username, password){
            private ArrayList arrayList1 = new ArrayList();
            private ArrayList arrayList2 = new ArrayList();
            private static final String ISO8859_1 = "8859_1";

            public void setMailContent(String mailContent) throws MessagingException {
                this.multipart.addBodyPart(this.messageBodyPart);
                this.processHtmlImage(mailContent);
            }

            private void processHtmlImage(String mailContent) throws MessagingException {
                for (int i = 0; i < this.arrayList1.size(); ++i) {
                    this.messageBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource((String)this.arrayList1.get(i));
                    this.messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    String contentId = "<" + (String)this.arrayList2.get(i) + ">";
                    this.messageBodyPart.setHeader("Content-ID", contentId);
                    this.messageBodyPart.setFileName((String)this.arrayList1.get(i));
                    this.multipart.addBodyPart(this.messageBodyPart);
                }
            }

            private String createRandomStr() {
                char[] randomChar = new char[8];
                for (int i = 0; i < 8; ++i) {
                    randomChar[i] = (char)(Math.random() * 26.0 + 97.0);
                }
                String replaceStr = new String(randomChar);
                return replaceStr;
            }
        };
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.username, this.userpasswd);
    }

    public void setSubject(String mailSubject) throws MessagingException {
        this.mailSubject = mailSubject;
        this.mailMessage.setSubject(mailSubject);
    }

    public abstract void setMailContent(String var1) throws MessagingException;

    public void setSendDate(Date sendDate) throws MessagingException {
        this.mailSendDate = sendDate;
        this.mailMessage.setSentDate(sendDate);
    }

    public void setAttachments(String fileFullName) throws MessagingException {
        this.messageBodyPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(fileFullName);
        this.messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
        int index = fileFullName.lastIndexOf(File.separator);
        String attachmentRealName = fileFullName.substring(index + 1);
        this.messageBodyPart.setFileName(attachmentRealName);
        this.multipart.addBodyPart(this.messageBodyPart);
    }

    public void setAttachments(byte[] data, String fileName) throws MessagingException {
        ByteArrayDataSource bds = new ByteArrayDataSource(data, "application/octet-stream");
        this.messageBodyPart = new MimeBodyPart();
        this.messageBodyPart.setDataHandler(new DataHandler((DataSource)bds));
        this.messageBodyPart.setFileName(fileName);
        this.multipart.addBodyPart(this.messageBodyPart);
    }

    public void setMailFrom(String mailFrom) throws MessagingException {
        this.mailFromAddress = new InternetAddress(mailFrom);
        this.mailMessage.setFrom((Address)this.mailFromAddress);
    }

    public void setMailTo(String[] mailTo, String mailType) throws Exception {
        for (int i = 0; i < mailTo.length; ++i) {
            this.mailToAddress = new InternetAddress(mailTo[i]);
            if (mailType.equalsIgnoreCase("to")) {
                this.mailMessage.addRecipient(Message.RecipientType.TO, (Address)this.mailToAddress);
                continue;
            }
            if (mailType.equalsIgnoreCase("cc")) {
                this.mailMessage.addRecipient(Message.RecipientType.CC, (Address)this.mailToAddress);
                continue;
            }
            if (mailType.equalsIgnoreCase("bcc")) {
                this.mailMessage.addRecipient(Message.RecipientType.BCC, (Address)this.mailToAddress);
                continue;
            }
            throw new Exception("Unknown mailType: " + mailType + "!");
        }
    }

    public void sendMail() throws MessagingException {
        if (this.mailToAddress == null) {
            return;
        }
        this.mailMessage.setContent(this.multipart);
        this.mailMessage.saveChanges();
        Transport transport = this.mailSession.getTransport("smtp");
        transport.connect(this.smtpHost, this.username, this.userpasswd);
        transport.sendMessage((Message)this.mailMessage, this.mailMessage.getAllRecipients());
        transport.close();
    }

    public static void main(String[] args) {
        String femail = "fuxiuhu@kingdee.com\uff0cjunwu_qin@kingdee.com";
        femail = ExtStringUtil.replace(femail, "\uff0c", ";");
        femail = ExtStringUtil.replace(femail, ",", ";");
        femail = ExtStringUtil.replace(femail, "\uff1b", ";");
        try {
            String mailHost = "smtp.kingdee.com";
            String mailUser = "fuxiuhu";
            String[] toAddress = femail.split(";");
            String mailPassword = "*****";
            MailSender sendmail = MailSender.getTextMailSender(mailHost, mailUser, mailPassword);
            String reportname = "\u8c03\u5ea6\u90ae\u4ef6\u7b56\u5212\u56db";
            sendmail.setSubject(reportname + "--\u6267\u884c\u7ed3\u679c");
            sendmail.setSendDate(new Date());
            String ftitle = "\u8c03\u5ea6\u90ae\u4ef6";
            String content = "\u90ae\u4ef6\u5185\u5bb9\u6765\u81ea\u4e8e\u81ea\u52a8\u8c03\u5ea6\u7684\u6267\u884c\u7ed3\u679c\r\n";
            content = content + "\u8c03\u5ea6\u540d\u79f0\uff1a" + ftitle + "\r\n";
            content = content + "\u62a5\u8868\u540d\u79f0\uff1a" + reportname + "\r\n";
            sendmail.setMailContent(content);
            sendmail.setMailFrom("fuxiuhu@kingdee.com");
            sendmail.setMailTo(toAddress, "to");
            sendmail.sendMail();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

