/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.AbstractDefaultDateTimeValueUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DefaultDateTimeValueUI
extends AbstractDefaultDateTimeValueUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DefaultDateTimeValueUI.class);
    private boolean isinitLayout = false;
    private boolean isCancel = false;
    private int dataType = 4;

    public DefaultDateTimeValueUI() throws Exception {
        this.initLayout();
        this.kDButtonGroup1.add((AbstractButton)this.rbSystem);
        this.kDButtonGroup1.add((AbstractButton)this.rbFix);
        this.kDButtonGroup1.add((AbstractButton)this.rbDateAdd);
        this.kDButtonGroup1.add((AbstractButton)this.rbDateSub);
        this.kDButtonGroup1.add((AbstractButton)this.rbMonthBegin);
        this.kDButtonGroup1.add((AbstractButton)this.rbMonthEnd);
        this.kDButtonGroup2.add((AbstractButton)this.rbFixTime);
        this.kDButtonGroup2.add((AbstractButton)this.rbSystemTime);
        this.spAdd.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000, 1));
        this.spSub.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000, 1));
    }

    public DefaultDateTimeValueUI(String value, int dataType) throws Exception {
        this();
        SimpleDateFormat sdf;
        String formatString;
        String unit;
        this.dataType = dataType;
        this.initDateFormat();
        String dateValue = value;
        String timeValue = "";
        if (value.indexOf("|") != -1) {
            String[] arr = value.split("\\|");
            dateValue = arr[0];
            timeValue = arr[1];
        }
        if (dateValue.startsWith("getSystemDate()")) {
            this.rbSystem.setSelected(true);
        } else if (dateValue.startsWith("dayBegin")) {
            this.rbMonthBegin.setSelected(true);
        } else if (dateValue.startsWith("dayEnd")) {
            this.rbMonthEnd.setSelected(true);
        } else if (dateValue.startsWith("dateAdd + ")) {
            this.rbDateAdd.setSelected(true);
            dateValue = ExtStringUtil.replace(dateValue, "dateAdd + ", "");
            int lenth = dateValue.length();
            int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
            unit = dateValue.substring(lenth - 1);
            this.spAdd.setModel((SpinnerModel)new SpinnerNumberModel(addNumber, 0, 1000, 1));
        } else if (dateValue.startsWith("dateSub - ")) {
            this.rbDateSub.setSelected(true);
            dateValue = ExtStringUtil.replace(dateValue, "dateSub - ", "");
            int lenth = dateValue.length();
            int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
            unit = dateValue.substring(lenth - 1);
            this.spSub.setModel((SpinnerModel)new SpinnerNumberModel(addNumber, 0, 1000, 1));
        } else {
            this.rbFix.setSelected(true);
            formatString = "yyyy-MM-dd";
            if (dataType == 4) {
                formatString = "yyyy-MM-dd HH:mm:ss";
            }
            Date date = null;
            if (dateValue != null && !dateValue.equals("")) {
                try {
                    sdf = new SimpleDateFormat(formatString);
                    date = sdf.parse(dateValue);
                }
                catch (ParseException e) {}
            } else {
                date = RunReportParam.getServerDate(null);
            }
            this.kDDatePicker1.setValue((Object)date);
        }
        if (timeValue.startsWith("getSystemTime()")) {
            this.rbSystemTime.setSelected(true);
        } else {
            this.rbFixTime.setSelected(true);
            formatString = "HH:mm:ss";
            Date date = null;
            if (timeValue != null && !timeValue.equals("")) {
                try {
                    sdf = new SimpleDateFormat(formatString);
                    date = sdf.parse(timeValue);
                }
                catch (ParseException e) {}
            } else {
                date = RunReportParam.getServerDate(null);
            }
            this.kDTimePicker1.setValue((Object)date);
        }
    }

    public DefaultDateTimeValueUI(String value, int dataType, boolean isProcedure) throws Exception {
        this(value, dataType);
        if (isProcedure) {
            this.rbSystem.setEnabled(false);
            this.rbDateAdd.setEnabled(false);
            this.rbDateSub.setEnabled(false);
            this.rbMonthBegin.setEnabled(false);
            this.rbMonthEnd.setEnabled(false);
            this.spAdd.setEnabled(false);
            this.spSub.setEnabled(false);
            this.btnClear.setEnabled(false);
        }
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    private void initDateFormat() {
        if (this.dataType == 4) {
            String datePatternOld = this.kDDatePicker1.getDatePattern();
            this.kDDatePicker1.setTimeEnabled(true);
            String datePatternNew = this.kDDatePicker1.getDatePattern();
            this.kDDatePicker1.setDatePattern(ExtStringUtil.replace(datePatternNew, datePatternOld, datePatternOld + " "));
            Date date = RunReportParam.getServerDate(null);
            this.kDDatePicker1.setValue((Object)date);
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.closeWin();
    }

    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(true);
        this.kDDatePicker1.setValue(null);
        this.rbFix.setSelected(true);
    }

    protected void rbFix_itemStateChanged(ItemEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(true);
    }

    protected void rbSystem_itemStateChanged(ItemEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(false);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public String getDateSelected() {
        String ret = null;
        if (this.rbSystem.isSelected()) {
            ret = "getSystemDate()";
        } else if (this.rbMonthBegin.isSelected()) {
            ret = "dayBegin";
            ret = this.joinDateTime(ret);
        } else if (this.rbMonthEnd.isSelected()) {
            ret = "dayEnd";
            ret = this.joinDateTime(ret);
        } else if (this.rbDateAdd.isSelected()) {
            ret = "dateAdd + " + this.spAdd.getIntegerVlaue() + "D";
            ret = this.joinDateTime(ret);
        } else if (this.rbDateSub.isSelected()) {
            ret = "dateSub - " + this.spSub.getIntegerVlaue() + "D";
            ret = this.joinDateTime(ret);
        } else {
            ret = CtrlReportUtil.getObjectString(this.kDDatePicker1.getText());
            if (!ret.equals("")) {
                String formatString = "yyyy-MM-dd";
                if (this.dataType == 4) {
                    formatString = "yyyy-MM-dd HH:mm:ss";
                }
                String pattern = this.kDDatePicker1.getDatePattern();
                ret = CtrlReportUtil.formatDate(pattern, formatString, ret);
            }
        }
        return ret;
    }

    private String joinDateTime(String value) {
        return value + "|" + this.getTimeSelected();
    }

    private String getTimeSelected() {
        String ret = null;
        if (this.rbSystemTime.isSelected()) {
            ret = "getSystemTime()";
        } else {
            ret = CtrlReportUtil.getObjectString(this.kDTimePicker1.getText());
            if (!ret.equals("")) {
                String formatString = "HH:mm:ss";
                String pattern = this.kDTimePicker1.getTimePattern();
                ret = CtrlReportUtil.formatDate(pattern, formatString, ret);
            }
        }
        return ret;
    }
}

